/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;

public class SecureChatServerHandler
extends SimpleChannelInboundHandler<String> {
    static final ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public void channelActive(ChannelHandlerContext ctx) {
        ((SslHandler)ctx.pipeline().get(SslHandler.class)).handshakeFuture().addListener(future -> {
            ctx.writeAndFlush((Object)"Welcome to secure chat service!\n");
            ctx.writeAndFlush((Object)("Your session is protected by " + ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession().getCipherSuite() + " cipher suite.\n"));
            channels.add((Object)ctx.channel());
        });
    }

    public void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        for (Channel c : channels) {
            if (c != ctx.channel()) {
                c.writeAndFlush((Object)("[" + ctx.channel().remoteAddress() + "] " + msg + '\n'));
                continue;
            }
            c.writeAndFlush((Object)("[you] " + msg + '\n'));
        }
        if ("bye".equals(msg.toLowerCase())) {
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

