/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.example.proxy.HexDumpProxyFrontendHandler;

public class HexDumpProxyBackendHandler
extends ChannelInboundHandlerAdapter {
    private final Channel inboundChannel;

    public HexDumpProxyBackendHandler(Channel inboundChannel) {
        this.inboundChannel = inboundChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (!this.inboundChannel.isActive()) {
            HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
        } else {
            ctx.read();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.inboundChannel.writeAndFlush(msg).addListener(future -> {
            if (future.isSuccess()) {
                ctx.read();
            } else {
                ctx.close();
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        HexDumpProxyFrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
    }
}

