/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.frame.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class Http2ClientStreamFrameResponseHandler
extends SimpleChannelInboundHandler<Http2StreamFrame> {
    private final CountDownLatch latch = new CountDownLatch(1);

    protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame msg) throws Exception {
        System.out.println("Received HTTP/2 'stream' frame: " + msg);
        if (msg instanceof Http2DataFrame && ((Http2DataFrame)msg).isEndStream()) {
            this.latch.countDown();
        } else if (msg instanceof Http2HeadersFrame && ((Http2HeadersFrame)msg).isEndStream()) {
            this.latch.countDown();
        }
    }

    public boolean responseSuccessfullyCompleted() {
        try {
            return this.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            System.err.println("Latch exception: " + ie.getMessage());
            return false;
        }
    }
}

