/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.dns.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.dns.DefaultDnsQuery;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsResponse;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsQuery;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.codec.dns.TcpDnsQueryDecoder;
import io.netty.handler.codec.dns.TcpDnsQueryEncoder;
import io.netty.handler.codec.dns.TcpDnsResponseDecoder;
import io.netty.handler.codec.dns.TcpDnsResponseEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class TcpDnsServer {
    private static final String QUERY_DOMAIN = "www.example.com";
    private static final int DNS_SERVER_PORT = 53;
    private static final String DNS_SERVER_HOST = "127.0.0.1";
    private static final byte[] QUERY_RESULT = new byte[]{-64, -88, 1, 1};

    public static void main(String[] args) throws Exception {
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory()), (EventLoopGroup)new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory())).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TcpDnsQueryDecoder(), new TcpDnsResponseEncoder(), new SimpleChannelInboundHandler<DnsQuery>(){

                    protected void channelRead0(ChannelHandlerContext ctx, DnsQuery msg) throws Exception {
                        DnsQuestion question = (DnsQuestion)msg.recordAt(DnsSection.QUESTION);
                        System.out.println("Query domain: " + question);
                        ctx.writeAndFlush((Object)this.newResponse(msg, question, 600L, new byte[][]{QUERY_RESULT}));
                    }

                    private DefaultDnsResponse newResponse(DnsQuery query, DnsQuestion question, long ttl, byte[] ... addresses) {
                        DefaultDnsResponse response = new DefaultDnsResponse(query.id());
                        response.addRecord(DnsSection.QUESTION, (DnsRecord)question);
                        for (byte[] address : addresses) {
                            DefaultDnsRawRecord queryAnswer = new DefaultDnsRawRecord(question.name(), DnsRecordType.A, ttl, Unpooled.wrappedBuffer((byte[])address));
                            response.addRecord(DnsSection.ANSWER, (DnsRecord)queryAnswer);
                        }
                        return response;
                    }
                }});
            }
        });
        final Channel channel = bootstrap.bind(53).channel();
        Executors.newSingleThreadScheduledExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpDnsServer.clientQuery();
                    channel.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 1000L, TimeUnit.MILLISECONDS);
        channel.closeFuture().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clientQuery() throws Exception {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new TcpDnsQueryEncoder()}).addLast(new ChannelHandler[]{new TcpDnsResponseDecoder()}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DefaultDnsResponse>(){

                        protected void channelRead0(ChannelHandlerContext ctx, DefaultDnsResponse msg) {
                            try {
                                TcpDnsServer.handleQueryResp(msg);
                            }
                            finally {
                                ctx.close();
                            }
                        }
                    }});
                }
            });
            Channel ch = b.connect(DNS_SERVER_HOST, 53).sync().channel();
            int randomID = new Random().nextInt(59000) + 1000;
            DnsQuery query = new DefaultDnsQuery(randomID, DnsOpCode.QUERY).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
            ch.writeAndFlush((Object)query).sync();
            boolean success = ch.closeFuture().await(10L, TimeUnit.SECONDS);
            if (!success) {
                System.err.println("dns query timeout!");
                ch.close().sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void handleQueryResp(DefaultDnsResponse msg) {
        if (msg.count(DnsSection.QUESTION) > 0) {
            DnsQuestion question = (DnsQuestion)msg.recordAt(DnsSection.QUESTION, 0);
            System.out.printf("name: %s%n", question.name());
        }
        int count = msg.count(DnsSection.ANSWER);
        for (int i = 0; i < count; ++i) {
            DnsRecord record = msg.recordAt(DnsSection.ANSWER, i);
            if (record.type() != DnsRecordType.A) continue;
            DnsRawRecord raw = (DnsRawRecord)record;
            System.out.println(NetUtil.bytesToIpAddress((byte[])ByteBufUtil.getBytes((ByteBuf)raw.content())));
        }
    }
}

