/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.message;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.message.MsgEchoClientHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public final class MsgEchoClient {
    private static final Logger log = Logger.getLogger(MsgEchoClient.class.getName());
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", "8007"));
    static final int SIZE = Integer.parseInt(System.getProperty("size", "256"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DefaultThreadFactory connectFactory = new DefaultThreadFactory("connect");
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)connectFactory, NioUdtProvider.MESSAGE_PROVIDER);
        try {
            Bootstrap boot = new Bootstrap();
            ((Bootstrap)((Bootstrap)boot.group((EventLoopGroup)connectGroup)).channelFactory(NioUdtProvider.MESSAGE_CONNECTOR)).handler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new MsgEchoClientHandler()});
                }
            });
            ChannelFuture f = boot.connect(HOST, PORT).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            connectGroup.shutdownGracefully();
        }
    }
}

