/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http.upload.HttpUploadServerHandler;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslContext;

public class HttpUploadServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;

    public HttpUploadServerInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        pipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor((CompressionOptions[])null)});
        pipeline.addLast(new ChannelHandler[]{new HttpUploadServerHandler()});
    }
}

