/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.util.collection.IntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class MqttProperties {
    public static final MqttProperties NO_PROPERTIES = new MqttProperties(false);
    private IntObjectHashMap<MqttProperty> props;
    private final boolean canModify;

    static MqttProperties withEmptyDefaults(MqttProperties properties) {
        if (properties == null) {
            return NO_PROPERTIES;
        }
        return properties;
    }

    public MqttProperties() {
        this(true);
    }

    private MqttProperties(boolean canModify) {
        this.canModify = canModify;
    }

    public void add(MqttProperty property) {
        if (!this.canModify) {
            throw new UnsupportedOperationException("adding property isn't allowed");
        }
        IntObjectHashMap props = this.props;
        if (property.propertyId == MqttPropertyType.USER_PROPERTY.value) {
            UserProperties userProps = (UserProperties)(props != null ? (MqttProperty)props.get(property.propertyId) : null);
            if (userProps == null) {
                userProps = new UserProperties();
                if (props == null) {
                    this.props = props = new IntObjectHashMap();
                }
                props.put(property.propertyId, (Object)userProps);
            }
            if (property instanceof UserProperty) {
                userProps.add((StringPair)((UserProperty)property).value);
            } else {
                for (StringPair pair : (List)((UserProperties)property).value) {
                    userProps.add(pair);
                }
            }
        } else {
            if (props == null) {
                this.props = props = new IntObjectHashMap();
            }
            props.put(property.propertyId, (Object)property);
        }
    }

    public Collection<? extends MqttProperty> listAll() {
        IntObjectHashMap<MqttProperty> props = this.props;
        return props == null ? Collections.emptyList() : props.values();
    }

    public boolean isEmpty() {
        IntObjectHashMap<MqttProperty> props = this.props;
        return props == null || props.isEmpty();
    }

    public MqttProperty getProperty(int propertyId) {
        IntObjectHashMap<MqttProperty> props = this.props;
        return props == null ? null : (MqttProperty)props.get(propertyId);
    }

    public static final class BinaryProperty
    extends MqttProperty<byte[]> {
        public BinaryProperty(int propertyId, byte[] value) {
            super(propertyId, value);
        }
    }

    public static final class UserProperty
    extends MqttProperty<StringPair> {
        public UserProperty(String key, String value) {
            super(MqttPropertyType.USER_PROPERTY.value, new StringPair(key, value));
        }
    }

    public static final class UserProperties
    extends MqttProperty<List<StringPair>> {
        public UserProperties() {
            super(MqttPropertyType.USER_PROPERTY.value, new ArrayList());
        }

        public UserProperties(Collection<StringPair> values) {
            this();
            ((List)this.value).addAll(values);
        }

        public void add(StringPair pair) {
            ((List)this.value).add(pair);
        }

        public void add(String key, String value) {
            ((List)this.value).add(new StringPair(key, value));
        }
    }

    public static final class StringPair {
        public final String key;
        public final String value;

        public StringPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return this.key.hashCode() + 31 * this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StringPair that = (StringPair)obj;
            return that.key.equals(this.key) && that.value.equals(this.value);
        }
    }

    public static final class StringProperty
    extends MqttProperty<String> {
        public StringProperty(int propertyId, String value) {
            super(propertyId, value);
        }
    }

    public static final class IntegerProperty
    extends MqttProperty<Integer> {
        public IntegerProperty(int propertyId, Integer value) {
            super(propertyId, value);
        }
    }

    public static abstract class MqttProperty<T> {
        final T value;
        final int propertyId;

        protected MqttProperty(int propertyId, T value) {
            this.propertyId = propertyId;
            this.value = value;
        }
    }

    public static enum MqttPropertyType {
        PAYLOAD_FORMAT_INDICATOR(1),
        REQUEST_PROBLEM_INFORMATION(23),
        REQUEST_RESPONSE_INFORMATION(25),
        MAXIMUM_QOS(36),
        RETAIN_AVAILABLE(37),
        WILDCARD_SUBSCRIPTION_AVAILABLE(40),
        SUBSCRIPTION_IDENTIFIER_AVAILABLE(41),
        SHARED_SUBSCRIPTION_AVAILABLE(42),
        SERVER_KEEP_ALIVE(19),
        RECEIVE_MAXIMUM(33),
        TOPIC_ALIAS_MAXIMUM(34),
        TOPIC_ALIAS(35),
        PUBLICATION_EXPIRY_INTERVAL(2),
        SESSION_EXPIRY_INTERVAL(17),
        WILL_DELAY_INTERVAL(24),
        MAXIMUM_PACKET_SIZE(39),
        SUBSCRIPTION_IDENTIFIER(11),
        CONTENT_TYPE(3),
        RESPONSE_TOPIC(8),
        ASSIGNED_CLIENT_IDENTIFIER(18),
        AUTHENTICATION_METHOD(21),
        RESPONSE_INFORMATION(26),
        SERVER_REFERENCE(28),
        REASON_STRING(31),
        USER_PROPERTY(38),
        CORRELATION_DATA(9),
        AUTHENTICATION_DATA(22);

        private static final MqttPropertyType[] VALUES;
        private final int value;

        private MqttPropertyType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static MqttPropertyType valueOf(int type) {
            MqttPropertyType t = null;
            try {
                t = VALUES[type];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (t == null) {
                throw new IllegalArgumentException("unknown property type: " + type);
            }
            return t;
        }

        static {
            VALUES = new MqttPropertyType[43];
            MqttPropertyType[] mqttPropertyTypeArray = MqttPropertyType.values();
            int n = mqttPropertyTypeArray.length;
            for (int i = 0; i < n; ++i) {
                MqttPropertyType v;
                MqttPropertyType.VALUES[v.value] = v = mqttPropertyTypeArray[i];
            }
        }
    }
}

