/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http2.Http2DataChunkedInput;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Http2DataChunkedInputTest {
    private static final byte[] BYTES = new byte[65536];
    private static final File TMP;
    private static final Http2FrameStream STREAM;

    @Test
    public void testChunkedStream() {
        Http2DataChunkedInputTest.check(new ChunkedInput[]{new Http2DataChunkedInput((ChunkedInput)new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)), STREAM)});
    }

    @Test
    public void testChunkedNioStream() {
        Http2DataChunkedInputTest.check(new ChunkedInput[]{new Http2DataChunkedInput((ChunkedInput)new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))), STREAM)});
    }

    @Test
    public void testChunkedFile() throws IOException {
        Http2DataChunkedInputTest.check(new ChunkedInput[]{new Http2DataChunkedInput((ChunkedInput)new ChunkedFile(TMP), STREAM)});
    }

    @Test
    public void testChunkedNioFile() throws IOException {
        Http2DataChunkedInputTest.check(new ChunkedInput[]{new Http2DataChunkedInput((ChunkedInput)new ChunkedNioFile(TMP), STREAM)});
    }

    @Test
    public void testWrappedReturnNull() throws Exception {
        Http2DataChunkedInput input = new Http2DataChunkedInput((ChunkedInput)new ChunkedInput<ByteBuf>(){

            public boolean isEndOfInput() throws Exception {
                return false;
            }

            public void close() throws Exception {
            }

            public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
                return null;
            }

            public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
                return null;
            }

            public long length() {
                return 0L;
            }

            public long progress() {
                return 0L;
            }
        }, STREAM);
        Assertions.assertNull((Object)input.readChunk(ByteBufAllocator.DEFAULT));
    }

    private static void check(ChunkedInput<?> ... inputs) {
        Http2DataFrame dataFrame;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        for (ChunkedInput<?> input : inputs) {
            ch.writeOutbound(new Object[]{input});
        }
        Assertions.assertTrue((boolean)ch.finish());
        int i = 0;
        int read = 0;
        Http2DataFrame http2DataFrame = null;
        while ((dataFrame = (Http2DataFrame)ch.readOutbound()) != null) {
            ByteBuf buffer = dataFrame.content();
            while (buffer.isReadable()) {
                Assertions.assertEquals((byte)BYTES[i++], (byte)buffer.readByte());
                ++read;
                if (i != BYTES.length) continue;
                i = 0;
            }
            buffer.release();
            http2DataFrame = dataFrame;
        }
        Assertions.assertEquals((int)(BYTES.length * inputs.length), (int)read);
        Assertions.assertNotNull(http2DataFrame);
        Assertions.assertTrue((boolean)http2DataFrame.isEndStream(), (String)"Last chunk must be Http2DataFrame#isEndStream() set to true");
    }

    static {
        STREAM = new Http2FrameStream(){

            public int id() {
                return 1;
            }

            public Http2Stream.State state() {
                return Http2Stream.State.OPEN;
            }
        };
        for (int i = 0; i < BYTES.length; ++i) {
            Http2DataChunkedInputTest.BYTES[i] = (byte)i;
        }
        FileOutputStream out = null;
        try {
            TMP = PlatformDependent.createTempFile((String)"netty-chunk-", (String)".tmp", null);
            TMP.deleteOnExit();
            out = new FileOutputStream(TMP);
            out.write(BYTES);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

