/*
 * Copyright 2013 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

/**
 * Super-class for SPDY header-block encoders.
 *
 * @see SpdyHeaderBlockZlibEncoder
 * @see SpdyHeaderBlockJZlibEncoder
 * @see SpdyHeaderBlockRawEncoder
 */
public abstract class SpdyHeaderBlockEncoder {

    static SpdyHeaderBlockEncoder newInstance(
            SpdyVersion version, int compressionLevel, int windowBits, int memLevel) {
        return new SpdyHeaderBlockZlibEncoder(version, compressionLevel);
    }

    abstract ByteBuf encode(ByteBufAllocator alloc, SpdyHeadersFrame frame) throws Exception;
    abstract void end();
}
