/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.HPKE;
import io.netty.incubator.codec.hpke.HybridPublicKeyEncryption;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpKey;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class OHttpServerKeys {
    private final Map<Byte, OHttpKey.PrivateKey> keyMap = new HashMap<Byte, OHttpKey.PrivateKey>();

    public OHttpServerKeys(OHttpKey.PrivateKey ... keys) {
        this(Arrays.asList(ObjectUtil.checkNonEmpty((Object[])keys, (String)"keys")));
    }

    public OHttpServerKeys(Collection<OHttpKey.PrivateKey> keys) {
        ObjectUtil.checkNonEmpty(keys, (String)"keys");
        for (OHttpKey.PrivateKey key : keys) {
            if (this.keyMap.put(key.id(), key) == null) continue;
            throw new IllegalArgumentException("Duplicate keyID " + key.id());
        }
    }

    public AsymmetricCipherKeyPair getKeyPair(OHttpCiphersuite ciphersuite) {
        OHttpKey.PrivateKey key = this.keyMap.get(ciphersuite.keyId());
        if (key == null) {
            return null;
        }
        for (OHttpKey.Cipher cipher : key.ciphers()) {
            if (cipher.kdf() != ciphersuite.kdf() || cipher.aead() != ciphersuite.aead()) continue;
            return key.keyPair();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OHttpServerKeys that = (OHttpServerKeys)o;
        return this.keyMap.equals(that.keyMap);
    }

    public String toString() {
        return "OHttpServerKeys{keyMap=" + this.keyMap + '}';
    }

    public int hashCode() {
        return this.keyMap.hashCode();
    }

    public void encodePublicKeys(HybridPublicKeyEncryption encryption, ByteBuf output) {
        for (Map.Entry<Byte, OHttpKey.PrivateKey> key : this.keyMap.entrySet()) {
            HybridPublicKeyEncryption.KEM kem = key.getValue().kem();
            AsymmetricCipherKeyPair kp = key.getValue().keyPair();
            output.writeByte((int)key.getKey().byteValue());
            output.writeShort((int)kem.id());
            HPKE hpke = encryption.newHPKE(HybridPublicKeyEncryption.Mode.Base, key.getValue().kem(), HybridPublicKeyEncryption.KDF.HKDF_SHA256, HybridPublicKeyEncryption.AEAD.AES_GCM256);
            output.writeBytes(hpke.serializePublicKey(kp.publicParameters()));
            output.writeShort(key.getValue().ciphers().size() * 4);
            for (OHttpKey.Cipher cipher : key.getValue().ciphers()) {
                output.writeShort((int)cipher.kdf().id());
                output.writeShort((int)cipher.aead().id());
            }
        }
    }
}

