/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.CryptoOperations;
import io.netty.incubator.codec.hpke.HPKE;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.HybridPublicKeyEncryption;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpCrypto;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import io.netty.incubator.codec.ohttp.OHttpServerKeys;
import java.util.Objects;

public final class OHttpCryptoReceiver
extends OHttpCrypto {
    private final OHttpCryptoConfiguration configuration;
    private final HPKEContext context;
    private final byte[] responseNonce;
    private final CryptoOperations aead;

    public static Builder newBuilder() {
        return new Builder();
    }

    private OHttpCryptoReceiver(Builder builder) {
        this.configuration = Objects.requireNonNull(builder.configuration, "configuration");
        Objects.requireNonNull(builder.serverKeys, "serverKeys");
        Objects.requireNonNull(builder.ciphersuite, "ciphersuite");
        Objects.requireNonNull(builder.encapsulatedKey, "encapsulatedKey");
        Objects.requireNonNull(builder.encryption, "encryption");
        AsymmetricCipherKeyPair keyPair = builder.serverKeys.getKeyPair(builder.ciphersuite);
        if (keyPair == null) {
            throw new DecoderException("ciphersuite not supported");
        }
        byte[] enc = builder.encapsulatedKey;
        HPKE hpke = builder.ciphersuite.newHPKE(builder.encryption);
        this.context = hpke.setupBaseR(enc, keyPair, builder.ciphersuite.createInfo(this.configuration));
        this.responseNonce = builder.forcedResponseNonce == null ? builder.ciphersuite.createResponseNonce() : builder.forcedResponseNonce;
        this.aead = builder.ciphersuite.createResponseAead(builder.encryption, this.context, enc, this.responseNonce, this.configuration);
    }

    public void writeResponseNonce(ByteBuf out) {
        out.writeBytes(this.responseNonce);
    }

    @Override
    protected CryptoOperations encryptCrypto() {
        return this.aead;
    }

    @Override
    protected CryptoOperations decryptCrypto() {
        return this.context;
    }

    @Override
    protected OHttpCryptoConfiguration configuration() {
        return this.configuration;
    }

    public static final class Builder {
        private HybridPublicKeyEncryption encryption;
        private OHttpCryptoConfiguration configuration;
        private OHttpServerKeys serverKeys;
        private OHttpCiphersuite ciphersuite;
        private byte[] encapsulatedKey;
        private byte[] forcedResponseNonce;

        public Builder setHybridPublicKeyEncryption(HybridPublicKeyEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder setConfiguration(OHttpCryptoConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setServerKeys(OHttpServerKeys value) {
            this.serverKeys = value;
            return this;
        }

        public Builder setCiphersuite(OHttpCiphersuite value) {
            this.ciphersuite = value;
            return this;
        }

        public Builder setEncapsulatedKey(byte[] value) {
            this.encapsulatedKey = value;
            return this;
        }

        public Builder setForcedResponseNonce(byte[] value) {
            this.forcedResponseNonce = value;
            return this;
        }

        public OHttpCryptoReceiver build() {
            return new OHttpCryptoReceiver(this);
        }

        private Builder() {
        }
    }
}

