/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.CryptoOperations;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import java.nio.charset.StandardCharsets;

public abstract class OHttpCrypto {
    private static final byte[] AAD_FINAL = "final".getBytes(StandardCharsets.US_ASCII);

    OHttpCrypto() {
    }

    private static ByteBuf aad(boolean isFinal) {
        return isFinal ? Unpooled.wrappedBuffer((byte[])AAD_FINAL) : Unpooled.EMPTY_BUFFER;
    }

    protected abstract CryptoOperations encryptCrypto();

    protected abstract CryptoOperations decryptCrypto();

    protected abstract OHttpCryptoConfiguration configuration();

    public final void encrypt(ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        this.encryptCrypto().seal(OHttpCrypto.aad(isFinal && this.configuration().useFinalAad()), message.slice(message.readerIndex(), messageLength), out);
        message.skipBytes(messageLength);
    }

    public final void decrypt(ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        this.decryptCrypto().open(OHttpCrypto.aad(isFinal && this.configuration().useFinalAad()), message.slice(message.readerIndex(), messageLength), out);
        message.skipBytes(messageLength);
    }
}

