/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.hpke.AsymmetricKeyParameter;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpCryptoSender;
import io.netty.incubator.codec.ohttp.OHttpDecoderException;
import io.netty.incubator.codec.ohttp.OHttpEncoderException;
import io.netty.incubator.codec.ohttp.OHttpRequestResponseContext;
import io.netty.incubator.codec.ohttp.OHttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class OHttpClientCodec
extends MessageToMessageCodec<HttpObject, HttpObject> {
    private final Deque<OHttpRequestResponseContextHolder> contextHolders = new ArrayDeque<OHttpRequestResponseContextHolder>();
    private final OHttpCryptoProvider provider;
    private final Function<HttpRequest, EncapsulationParameters> encapsulationFunc;
    private ByteBuf cumulationBuffer = Unpooled.EMPTY_BUFFER;
    private boolean destroyed;
    private boolean decodeCalled;
    private boolean producedMessage;

    public OHttpClientCodec(OHttpCryptoProvider provider, Function<HttpRequest, EncapsulationParameters> encapsulationFunc) {
        this.provider = Objects.requireNonNull(provider, "provider");
        this.encapsulationFunc = Objects.requireNonNull(encapsulationFunc, "encapsulationFunc");
    }

    public boolean isSharable() {
        return false;
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) {
        if (this.destroyed) {
            throw new IllegalStateException("Already destroyed");
        }
        this.decodeCalled = true;
        try {
            assert (!this.contextHolders.isEmpty());
            OHttpRequestResponseContext ohttpContext = this.contextHolders.peekFirst().handler;
            if (msg instanceof HttpResponse) {
                HttpResponse resp = (HttpResponse)msg;
                if (ohttpContext != null) {
                    if (resp.status() != HttpResponseStatus.OK) {
                        throw new DecoderException("OHTTP response status is not OK");
                    }
                    String contentTypeValue = resp.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                    AsciiString expectedContentType = ohttpContext.version().responseContentType();
                    if (!expectedContentType.contentEqualsIgnoreCase((CharSequence)contentTypeValue)) {
                        throw new DecoderException("OHTTP response has unexpected content type");
                    }
                }
            }
            boolean isLast = msg instanceof LastHttpContent;
            if (ohttpContext != null) {
                if (msg instanceof HttpContent) {
                    ByteBuf content = ((HttpContent)msg).content();
                    this.cumulationBuffer = ByteToMessageDecoder.MERGE_CUMULATOR.cumulate(ctx.alloc(), this.cumulationBuffer, content.retain());
                    ohttpContext.parse(ctx.alloc(), this.cumulationBuffer, isLast, out);
                }
            } else {
                out.add(ReferenceCountUtil.retain((Object)msg));
            }
            if (isLast) {
                OHttpRequestResponseContextHolder h = this.contextHolders.pollFirst();
                assert (h != null);
                h.destroy();
            }
            this.producedMessage |= !out.isEmpty();
        }
        catch (CryptoException e) {
            try {
                throw new OHttpDecoderException("failed to decrypt bytes", e);
            }
            catch (Throwable throwable) {
                this.producedMessage |= !out.isEmpty();
                throw throwable;
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.decodeCalled && !this.producedMessage && !ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
        this.decodeCalled = false;
        this.producedMessage = false;
        ctx.fireChannelReadComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) {
        block11: {
            try {
                if (msg instanceof HttpRequest) {
                    HttpRequest innerRequest = (HttpRequest)msg;
                    EncapsulationParameters encapsulation = this.encapsulationFunc.apply(innerRequest);
                    if (encapsulation != null) {
                        OHttpClientRequestResponseContext oHttpContext = new OHttpClientRequestResponseContext(encapsulation, this.provider);
                        HttpHeaders outerHeaders = encapsulation.outerRequestHeaders();
                        DefaultHttpRequest outerRequest = new DefaultHttpRequest(innerRequest.protocolVersion(), HttpMethod.POST, encapsulation.outerRequestUri(), outerHeaders);
                        outerHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)encapsulation.outerRequestAuthority()).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)oHttpContext.version().requestContentType());
                        HttpUtil.setTransferEncodingChunked((HttpMessage)outerRequest, (boolean)true);
                        this.contextHolders.addLast(new OHttpRequestResponseContextHolder(oHttpContext));
                        out.add(outerRequest);
                    } else {
                        this.contextHolders.addLast(OHttpRequestResponseContextHolder.NONE);
                    }
                }
                assert (!this.contextHolders.isEmpty());
                OHttpRequestResponseContext contentHandler = this.contextHolders.peekLast().handler;
                if (contentHandler != null) {
                    ByteBuf contentBytes = ctx.alloc().buffer();
                    try {
                        boolean isLast = msg instanceof LastHttpContent;
                        contentHandler.serialize(ctx.alloc(), msg, contentBytes);
                        DefaultLastHttpContent content = isLast ? new DefaultLastHttpContent(contentBytes) : new DefaultHttpContent(contentBytes);
                        out.add(content);
                        contentBytes = null;
                        break block11;
                    }
                    finally {
                        if (contentBytes != null) {
                            contentBytes.release();
                        }
                    }
                }
                out.add(ReferenceCountUtil.retain((Object)msg));
            }
            catch (CryptoException e) {
                throw new OHttpEncoderException("failed to encrypt bytes", e);
            }
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (!this.destroyed) {
            OHttpRequestResponseContextHolder h;
            this.destroyed = true;
            this.cumulationBuffer.release();
            this.cumulationBuffer = Unpooled.EMPTY_BUFFER;
            while ((h = this.contextHolders.poll()) != null) {
                h.destroy();
            }
        }
        super.handlerRemoved(ctx);
    }

    private static final class OHttpClientRequestResponseContext
    extends OHttpRequestResponseContext {
        private final OHttpCryptoSender sender;

        OHttpClientRequestResponseContext(EncapsulationParameters parameters, OHttpCryptoProvider provider) {
            super(parameters.version());
            this.sender = OHttpCryptoSender.newBuilder().setOHttpCryptoProvider(provider).setConfiguration(parameters.version()).setCiphersuite(Objects.requireNonNull(parameters.ciphersuite(), "ciphersuite")).setReceiverPublicKey(Objects.requireNonNull(parameters.serverPublicKey(), "serverPublicKey")).build();
        }

        @Override
        public boolean decodePrefix(ByteBufAllocator alloc, ByteBuf in) {
            return this.sender.readResponseNonce(in);
        }

        @Override
        protected void decryptChunk(ByteBufAllocator alloc, ByteBuf chunk, int chunkLength, boolean isFinal, ByteBuf out) throws CryptoException {
            this.sender.decrypt(alloc, chunk, chunkLength, isFinal, out);
        }

        @Override
        public void encodePrefix(ByteBufAllocator alloc, ByteBuf out) {
            this.sender.writeHeader(out);
        }

        @Override
        protected void encryptChunk(ByteBufAllocator alloc, ByteBuf chunk, int chunkLength, boolean isFinal, ByteBuf out) throws CryptoException {
            this.sender.encrypt(alloc, chunk, chunkLength, isFinal, out);
        }

        @Override
        void destroyCrypto() {
            this.sender.close();
        }
    }

    public static interface EncapsulationParameters {
        public String outerRequestUri();

        public String outerRequestAuthority();

        default public HttpHeaders outerRequestHeaders() {
            return new DefaultHttpHeaders();
        }

        public OHttpCiphersuite ciphersuite();

        public AsymmetricKeyParameter serverPublicKey();

        public OHttpVersion version();

        public static EncapsulationParameters newInstance(final OHttpVersion version, final OHttpCiphersuite ciphersuite, final AsymmetricKeyParameter serverPublicKey, final String outerRequestUri, final String outerRequestAuthority) {
            Objects.requireNonNull(version, "version");
            Objects.requireNonNull(ciphersuite, "ciphersuite");
            Objects.requireNonNull(serverPublicKey, "serverPublicKey");
            Objects.requireNonNull(outerRequestUri, "outerRequestUri");
            Objects.requireNonNull(outerRequestAuthority, "outerRequestAuthority");
            return new EncapsulationParameters(){

                @Override
                public String outerRequestUri() {
                    return outerRequestUri;
                }

                @Override
                public String outerRequestAuthority() {
                    return outerRequestAuthority;
                }

                @Override
                public OHttpCiphersuite ciphersuite() {
                    return ciphersuite;
                }

                @Override
                public AsymmetricKeyParameter serverPublicKey() {
                    return serverPublicKey;
                }

                @Override
                public OHttpVersion version() {
                    return version;
                }
            };
        }
    }

    private static final class OHttpRequestResponseContextHolder {
        static final OHttpRequestResponseContextHolder NONE = new OHttpRequestResponseContextHolder(null);
        final OHttpRequestResponseContext handler;

        OHttpRequestResponseContextHolder(OHttpRequestResponseContext handler) {
            this.handler = handler;
        }

        void destroy() {
            if (this.handler != null) {
                this.handler.destroy();
            }
        }
    }
}

