/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpConstants;
import io.netty.incubator.codec.ohttp.OHttpCryptoReceiver;
import io.netty.incubator.codec.ohttp.OHttpDecoderException;
import io.netty.incubator.codec.ohttp.OHttpEncoderException;
import io.netty.incubator.codec.ohttp.OHttpRequestResponseContext;
import io.netty.incubator.codec.ohttp.OHttpServerKeys;
import io.netty.incubator.codec.ohttp.OHttpVersion;
import io.netty.incubator.codec.ohttp.OHttpVersionChunkDraft;
import io.netty.incubator.codec.ohttp.OHttpVersionDraft;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Objects;

public class OHttpServerCodec
extends MessageToMessageCodec<HttpObject, HttpObject> {
    private final OHttpCryptoProvider provider;
    private final OHttpServerKeys serverKeys;
    private HttpRequest request;
    private boolean sentResponse;
    private OHttpServerRequestResponseContext oHttpContext;
    private ByteBuf cumulationBuffer = Unpooled.EMPTY_BUFFER;
    private boolean destroyed;

    public OHttpServerCodec(OHttpCryptoProvider provider, OHttpServerKeys serverKeys) {
        this.provider = Objects.requireNonNull(provider, "provider");
        this.serverKeys = Objects.requireNonNull(serverKeys, "serverKeys");
    }

    protected OHttpVersion selectVersion(String contentTypeValue) {
        if (OHttpConstants.REQUEST_CONTENT_TYPE.contentEqualsIgnoreCase((CharSequence)contentTypeValue)) {
            return OHttpVersionDraft.INSTANCE;
        }
        if (OHttpConstants.CHUNKED_REQUEST_CONTENT_TYPE.contentEqualsIgnoreCase((CharSequence)contentTypeValue)) {
            return OHttpVersionChunkDraft.INSTANCE;
        }
        return null;
    }

    protected void onResponse(HttpRequest request, HttpResponse response) {
    }

    public final boolean isSharable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) {
        block12: {
            if (this.destroyed) {
                throw new IllegalStateException("Already destroyed");
            }
            try {
                if (msg instanceof HttpRequest) {
                    HttpRequest req = (HttpRequest)msg;
                    if (this.oHttpContext != null) {
                        this.sentResponse = true;
                        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
                        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
                        this.onResponse(req, (HttpResponse)response);
                        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    OHttpVersion version = null;
                    this.sentResponse = false;
                    if (req.method() == HttpMethod.POST) {
                        String contentTypeValue = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                        version = this.selectVersion(contentTypeValue);
                    }
                    if (version != null) {
                        this.request = new DefaultHttpRequest(req.protocolVersion(), req.method(), req.uri(), req.headers());
                        this.oHttpContext = new OHttpServerRequestResponseContext(version, this.provider, this.serverKeys);
                    } else {
                        this.sentResponse = true;
                        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
                        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
                        this.onResponse(req, (HttpResponse)response);
                        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                }
                if (this.oHttpContext == null || !(msg instanceof HttpContent)) break block12;
                boolean isLast = msg instanceof LastHttpContent;
                try {
                    ByteBuf content = ((HttpContent)msg).content();
                    this.cumulationBuffer = ByteToMessageDecoder.MERGE_CUMULATOR.cumulate(ctx.alloc(), this.cumulationBuffer, content.retain());
                    this.oHttpContext.parse(ctx.alloc(), this.cumulationBuffer, isLast, out);
                }
                finally {
                    if (isLast && this.oHttpContext.receivedLastHttpContent()) {
                        this.destroyContext();
                    }
                }
            }
            catch (Exception e) {
                throw new OHttpServerDecoderException("failed to decode bytes", e);
            }
        }
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.sentResponse && this.request != null) {
            this.sentResponse = true;
            HttpResponseStatus status = cause instanceof OHttpServerDecoderException ? HttpResponseStatus.BAD_REQUEST : HttpResponseStatus.INTERNAL_SERVER_ERROR;
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
            this.onResponse(this.request, (HttpResponse)response);
            ChannelPromise promise = ctx.newPromise().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            if (cause.getCause() instanceof CryptoException) {
                ctx.writeAndFlush((Object)response, promise);
            } else {
                this.write(ctx, response, promise);
                this.flush(ctx);
            }
        } else {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) {
        block9: {
            try {
                if (msg instanceof HttpResponse && this.oHttpContext != null) {
                    assert (this.request != null);
                    this.sentResponse = true;
                    DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.oHttpContext.version().responseContentType());
                    HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
                    HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
                    this.onResponse(this.request, (HttpResponse)response);
                    out.add(response);
                }
                if (this.oHttpContext != null) {
                    boolean isLast = msg instanceof LastHttpContent;
                    try {
                        ByteBuf contentBytes = ctx.alloc().buffer();
                        this.oHttpContext.serialize(ctx.alloc(), msg, contentBytes);
                        DefaultLastHttpContent content = isLast ? new DefaultLastHttpContent(contentBytes) : new DefaultHttpContent(contentBytes);
                        out.add(content);
                        break block9;
                    }
                    finally {
                        if (isLast && this.oHttpContext.sendLastHttpContent()) {
                            this.destroyContext();
                        }
                    }
                }
                out.add(ReferenceCountUtil.retain((Object)msg));
            }
            catch (CryptoException e) {
                throw new OHttpEncoderException("failed to encrypt bytes", e);
            }
        }
    }

    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (!this.destroyed) {
            this.destroyed = true;
            this.cumulationBuffer.release();
            this.cumulationBuffer = Unpooled.EMPTY_BUFFER;
            this.destroyContext();
        }
        super.handlerRemoved(ctx);
    }

    private void destroyContext() {
        if (this.oHttpContext != null) {
            this.oHttpContext.destroy();
            this.oHttpContext = null;
        }
    }

    private static final class OHttpServerRequestResponseContext
    extends OHttpRequestResponseContext {
        private final OHttpCryptoProvider provider;
        private final OHttpServerKeys keys;
        private OHttpCryptoReceiver receiver;
        private boolean receivedLastHttpContent;
        private boolean sendLastHttpContent;

        OHttpServerRequestResponseContext(OHttpVersion version, OHttpCryptoProvider provider, OHttpServerKeys keys) {
            super(version);
            this.provider = provider;
            this.keys = keys;
        }

        private void checkPrefixDecoded() throws CryptoException {
            if (this.receiver == null) {
                throw new CryptoException("Prefix was not decoded yet");
            }
        }

        @Override
        public boolean decodePrefix(ByteBufAllocator alloc, ByteBuf in) throws CryptoException {
            OHttpCiphersuite ciphersuite;
            int initialReaderIndex = in.readerIndex();
            try {
                ciphersuite = OHttpCiphersuite.decode(in);
            }
            catch (IllegalArgumentException e) {
                throw new CryptoException((Throwable)e);
            }
            if (ciphersuite == null) {
                return false;
            }
            int encapsulatedKeyLength = ciphersuite.encapsulatedKeyLength();
            if (in.readableBytes() < encapsulatedKeyLength) {
                in.readerIndex(initialReaderIndex);
                return false;
            }
            AsymmetricCipherKeyPair pair = this.keys.getKeyPair(ciphersuite);
            if (pair == null) {
                throw new CryptoException("Unable to find private key for OHttpCiphersuite: " + ciphersuite);
            }
            byte[] encapsulatedKey = new byte[encapsulatedKeyLength];
            in.readBytes(encapsulatedKey);
            this.receiver = OHttpCryptoReceiver.newBuilder().setOHttpCryptoProvider(this.provider).setConfiguration(this.version()).setPrivateKey(pair).setCiphersuite(ciphersuite).setEncapsulatedKey(encapsulatedKey).build();
            return true;
        }

        @Override
        protected void decryptChunk(ByteBufAllocator alloc, ByteBuf chunk, int chunkSize, boolean isFinal, ByteBuf out) throws CryptoException {
            this.checkPrefixDecoded();
            this.receiver.decrypt(alloc, chunk, chunkSize, isFinal, out);
        }

        @Override
        public void encodePrefix(ByteBufAllocator alloc, ByteBuf out) throws CryptoException {
            this.checkPrefixDecoded();
            this.receiver.writeResponseNonce(out);
        }

        @Override
        protected void encryptChunk(ByteBufAllocator alloc, ByteBuf chunk, int chunkLength, boolean isFinal, ByteBuf out) throws CryptoException {
            this.checkPrefixDecoded();
            this.receiver.encrypt(alloc, chunk, chunkLength, isFinal, out);
        }

        boolean receivedLastHttpContent() {
            this.receivedLastHttpContent = true;
            return this.sendLastHttpContent;
        }

        boolean sendLastHttpContent() {
            this.sendLastHttpContent = true;
            return this.receivedLastHttpContent;
        }

        @Override
        void destroyCrypto() {
            if (this.receiver != null) {
                this.receiver.close();
            }
        }
    }

    private static final class OHttpServerDecoderException
    extends OHttpDecoderException {
        OHttpServerDecoderException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

