/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.incubator.codec.hpke.AEAD;
import io.netty.incubator.codec.hpke.AEADContext;
import io.netty.incubator.codec.hpke.CryptoDecryptContext;
import io.netty.incubator.codec.hpke.CryptoEncryptContext;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import java.nio.charset.StandardCharsets;

public abstract class OHttpCrypto
implements AutoCloseable {
    private static final ByteBuf EMPTY_HEAP = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[0]).asReadOnly());
    private static final ByteBuf EMPTY_DIRECT = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer().asReadOnly());
    private static final ByteBuf AAD_FINAL_HEAP = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])"final".getBytes(StandardCharsets.US_ASCII)).asReadOnly());
    private static final ByteBuf AAD_FINAL_DIRECT = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)5).writeBytes("final".getBytes(StandardCharsets.US_ASCII)).asReadOnly());
    private static final byte[] KEY_INFO = "key".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NONCE_INFO = "nonce".getBytes(StandardCharsets.US_ASCII);

    OHttpCrypto() {
    }

    private static ByteBuf aad(boolean isFinal, boolean preferDirect) {
        if (isFinal) {
            return preferDirect ? AAD_FINAL_DIRECT.duplicate() : AAD_FINAL_HEAP.duplicate();
        }
        return preferDirect ? EMPTY_DIRECT.duplicate() : EMPTY_HEAP.duplicate();
    }

    static AEADContext createResponseAEAD(OHttpCryptoProvider provider, HPKEContext context, AEAD aead, byte[] enc, byte[] responseNonce, byte[] responseExportContext) {
        int secretLength = Math.max(aead.nk(), aead.nn());
        byte[] secret = context.export(responseExportContext, secretLength);
        byte[] salt = new byte[enc.length + responseNonce.length];
        System.arraycopy(enc, 0, salt, 0, enc.length);
        System.arraycopy(responseNonce, 0, salt, enc.length, responseNonce.length);
        byte[] prk = context.extract(salt, secret);
        byte[] aeadKey = context.expand(prk, KEY_INFO, aead.nk());
        byte[] aeadNonce = context.expand(prk, NONCE_INFO, aead.nn());
        return provider.setupAEAD(aead, aeadKey, aeadNonce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] createInfo(OHttpCiphersuite ciphersuite, byte[] requestExportContext) {
        byte[] ret = new byte[requestExportContext.length + 1 + 7];
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])ret);
        try {
            buf.writerIndex(0).writeBytes(requestExportContext).writeByte(0);
            ciphersuite.encode(buf);
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            buf.release();
        }
    }

    protected abstract CryptoEncryptContext encryptCrypto();

    protected abstract CryptoDecryptContext decryptCrypto();

    protected abstract boolean useFinalAad();

    public final void encrypt(ByteBufAllocator alloc, ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        this.encryptCrypto().seal(alloc, OHttpCrypto.aad(isFinal && this.useFinalAad(), this.encryptCrypto().isDirectBufferPreferred()), message.slice(message.readerIndex(), messageLength), out);
        message.skipBytes(messageLength);
    }

    public final void decrypt(ByteBufAllocator alloc, ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        this.decryptCrypto().open(alloc, OHttpCrypto.aad(isFinal && this.useFinalAad(), this.decryptCrypto().isDirectBufferPreferred()), message.slice(message.readerIndex(), messageLength), out);
        message.skipBytes(messageLength);
    }

    @Override
    public void close() {
        CryptoDecryptContext decryptContext;
        CryptoEncryptContext encryptContext = this.encryptCrypto();
        if (encryptContext != null) {
            encryptContext.close();
        }
        if ((decryptContext = this.decryptCrypto()) != null) {
            decryptContext.close();
        }
    }
}

