/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.hpke.bouncycastle;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.incubator.codec.hpke.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;

abstract class BouncyCastleCryptoOperation {
    BouncyCastleCryptoOperation() {
    }

    final void execute(ByteBuf aad, ByteBuf in, ByteBuf out) throws CryptoException {
        int inOffset;
        byte[] inArray;
        int aadLength = aad.readableBytes();
        byte[] aadArray = ByteBufUtil.getBytes((ByteBuf)aad, (int)aad.readerIndex(), (int)aad.readableBytes(), (boolean)false);
        int inLength = in.readableBytes();
        if (in.hasArray()) {
            inArray = in.array();
            inOffset = in.arrayOffset() + in.readerIndex();
        } else {
            inArray = new byte[inLength];
            in.getBytes(in.readerIndex(), inArray);
            inOffset = 0;
        }
        try {
            byte[] result = this.execute(aadArray, inArray, inOffset, inLength);
            aad.skipBytes(aadLength);
            in.skipBytes(inLength);
            out.writeBytes(result);
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException((Throwable)e);
        }
    }

    protected abstract byte[] execute(byte[] var1, byte[] var2, int var3, int var4) throws InvalidCipherTextException;
}

