/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.hpke.bouncycastle;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.incubator.codec.hpke.AEADContext;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleCryptoOperation;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.hpke.AEAD;

final class BouncyCastleAEADCryptoContext
implements AEADContext {
    private final BouncyCastleCryptoOperation open;
    private final BouncyCastleCryptoOperation seal;
    private boolean closed;

    BouncyCastleAEADCryptoContext(final AEAD aead) {
        this.open = new BouncyCastleCryptoOperation(){

            @Override
            protected byte[] execute(byte[] aad, byte[] in, int inOffset, int inLength) throws InvalidCipherTextException {
                return aead.open(aad, in, inOffset, inLength);
            }
        };
        this.seal = new BouncyCastleCryptoOperation(){

            @Override
            protected byte[] execute(byte[] aad, byte[] in, int inOffset, int inLength) throws InvalidCipherTextException {
                return aead.seal(aad, in, inOffset, inLength);
            }
        };
    }

    public void seal(ByteBufAllocator alloc, ByteBuf aad, ByteBuf pt, ByteBuf out) throws CryptoException {
        this.checkClosed();
        this.seal.execute(aad, pt, out);
    }

    public void open(ByteBufAllocator alloc, ByteBuf aad, ByteBuf ct, ByteBuf out) throws CryptoException {
        this.checkClosed();
        this.open.execute(aad, ct, out);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("AEADContext closed");
        }
    }

    public boolean isDirectBufferPreferred() {
        return false;
    }

    public void close() {
        this.closed = true;
    }
}

