/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.hpke.bouncycastle;

import io.netty.incubator.codec.hpke.AEAD;
import io.netty.incubator.codec.hpke.AEADContext;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.AsymmetricKeyParameter;
import io.netty.incubator.codec.hpke.HPKERecipientContext;
import io.netty.incubator.codec.hpke.HPKESenderContext;
import io.netty.incubator.codec.hpke.KDF;
import io.netty.incubator.codec.hpke.KEM;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleAEADCryptoContext;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleAsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleAsymmetricKeyParameter;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleHPKERecipientContext;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleHPKESenderContext;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.crypto.hpke.HPKE;
import org.bouncycastle.crypto.hpke.HPKEContextWithEncapsulation;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public final class BouncyCastleOHttpCryptoProvider
implements OHttpCryptoProvider {
    public static final BouncyCastleOHttpCryptoProvider INSTANCE = new BouncyCastleOHttpCryptoProvider();
    private static final byte MODE_BASE = 0;
    private static final ECDomainParameters P256_PARAMS = new ECDomainParameters(NISTNamedCurves.getByName((String)"P-256"));
    private static final ECDomainParameters P384_PARAMS = new ECDomainParameters(NISTNamedCurves.getByName((String)"P-384"));
    private static final ECDomainParameters P521_PARAMS = new ECDomainParameters(NISTNamedCurves.getByName((String)"P-521"));
    private final SecureRandom random = new SecureRandom();

    private BouncyCastleOHttpCryptoProvider() {
    }

    public AEADContext setupAEAD(AEAD aead, byte[] key, byte[] baseNonce) {
        return new BouncyCastleAEADCryptoContext(new org.bouncycastle.crypto.hpke.AEAD(aead.id(), key, baseNonce));
    }

    private static BouncyCastleAsymmetricKeyParameter castOrThrow(AsymmetricKeyParameter param) {
        if (!(param instanceof BouncyCastleAsymmetricKeyParameter)) {
            throw new IllegalArgumentException("param must be of type " + BouncyCastleAsymmetricKeyParameter.class + ": " + param);
        }
        return (BouncyCastleAsymmetricKeyParameter)param;
    }

    private static BouncyCastleAsymmetricCipherKeyPair castOrThrow(AsymmetricCipherKeyPair pair) {
        if (!(pair instanceof BouncyCastleAsymmetricCipherKeyPair)) {
            throw new IllegalArgumentException("pair must be of type " + BouncyCastleAsymmetricCipherKeyPair.class + ": " + pair);
        }
        return (BouncyCastleAsymmetricCipherKeyPair)pair;
    }

    public HPKESenderContext setupHPKEBaseS(KEM kem, KDF kdf, AEAD aead, AsymmetricKeyParameter pkR, byte[] info, AsymmetricCipherKeyPair kpE) {
        HPKE hpke = new HPKE(0, kem.id(), kdf.id(), aead.id());
        HPKEContextWithEncapsulation ctx = kpE == null ? hpke.setupBaseS(BouncyCastleOHttpCryptoProvider.castOrThrow((AsymmetricKeyParameter)pkR).param, info) : hpke.setupBaseS(BouncyCastleOHttpCryptoProvider.castOrThrow((AsymmetricKeyParameter)pkR).param, info, BouncyCastleOHttpCryptoProvider.castOrThrow((AsymmetricCipherKeyPair)kpE).pair);
        return new BouncyCastleHPKESenderContext(ctx);
    }

    public HPKERecipientContext setupHPKEBaseR(KEM kem, KDF kdf, AEAD aead, byte[] enc, AsymmetricCipherKeyPair skR, byte[] info) {
        HPKE hpke = new HPKE(0, kem.id(), kdf.id(), aead.id());
        return new BouncyCastleHPKERecipientContext(hpke.setupBaseR(enc, BouncyCastleOHttpCryptoProvider.castOrThrow((AsymmetricCipherKeyPair)skR).pair, info));
    }

    public AsymmetricCipherKeyPair deserializePrivateKey(KEM kem, byte[] privateKeyBytes, byte[] publicKeyBytes) {
        return new BouncyCastleAsymmetricCipherKeyPair(BouncyCastleOHttpCryptoProvider.deserializePrivateKeyBouncyCastle(kem, privateKeyBytes, publicKeyBytes));
    }

    private static org.bouncycastle.crypto.AsymmetricCipherKeyPair deserializePrivateKeyBouncyCastle(KEM kem, byte[] privateKeyBytes, byte[] publicKeyBytes) {
        org.bouncycastle.crypto.params.AsymmetricKeyParameter publicKey = BouncyCastleOHttpCryptoProvider.deserializePublicKeyBouncyCastle(kem, publicKeyBytes);
        switch (kem) {
            case P256_SHA256: 
            case P384_SHA348: 
            case P521_SHA512: {
                BigInteger bigInt = new BigInteger(1, privateKeyBytes);
                return new org.bouncycastle.crypto.AsymmetricCipherKeyPair(publicKey, (org.bouncycastle.crypto.params.AsymmetricKeyParameter)new ECPrivateKeyParameters(bigInt, ((ECPublicKeyParameters)publicKey).getParameters()));
            }
            case X25519_SHA256: {
                return new org.bouncycastle.crypto.AsymmetricCipherKeyPair(publicKey, (org.bouncycastle.crypto.params.AsymmetricKeyParameter)new X25519PrivateKeyParameters(privateKeyBytes));
            }
            case X448_SHA512: {
                return new org.bouncycastle.crypto.AsymmetricCipherKeyPair(publicKey, (org.bouncycastle.crypto.params.AsymmetricKeyParameter)new X448PrivateKeyParameters(privateKeyBytes));
            }
        }
        throw new IllegalArgumentException("invalid kem: " + kem);
    }

    public AsymmetricKeyParameter deserializePublicKey(KEM kem, byte[] publicKeyBytes) {
        return new BouncyCastleAsymmetricKeyParameter(BouncyCastleOHttpCryptoProvider.deserializePublicKeyBouncyCastle(kem, publicKeyBytes));
    }

    private static org.bouncycastle.crypto.params.AsymmetricKeyParameter deserializePublicKeyBouncyCastle(KEM kem, byte[] publicKeyBytes) {
        switch (kem) {
            case P256_SHA256: 
            case P384_SHA348: 
            case P521_SHA512: {
                ECDomainParameters parameters = BouncyCastleOHttpCryptoProvider.ecDomainParameters(kem);
                ECPoint decoded = parameters.getCurve().decodePoint(publicKeyBytes);
                return new ECPublicKeyParameters(decoded, parameters);
            }
            case X25519_SHA256: {
                return new X25519PublicKeyParameters(publicKeyBytes);
            }
            case X448_SHA512: {
                return new X448PublicKeyParameters(publicKeyBytes);
            }
        }
        throw new IllegalArgumentException("invalid kem: " + kem);
    }

    private static ECDomainParameters ecDomainParameters(KEM kem) {
        switch (kem) {
            case P256_SHA256: {
                return P256_PARAMS;
            }
            case P384_SHA348: {
                return P384_PARAMS;
            }
            case P521_SHA512: {
                return P521_PARAMS;
            }
        }
        throw new IllegalArgumentException("invalid kem: " + kem);
    }

    public AsymmetricCipherKeyPair newRandomPrivateKey(KEM kem) {
        return new BouncyCastleAsymmetricCipherKeyPair(BouncyCastleOHttpCryptoProvider.newRandomPair(kem, this.random));
    }

    private static org.bouncycastle.crypto.AsymmetricCipherKeyPair newRandomPair(KEM kem, SecureRandom random) {
        switch (kem) {
            case X25519_SHA256: {
                X25519PrivateKeyParameters x25519PrivateKey = new X25519PrivateKeyParameters(random);
                return new org.bouncycastle.crypto.AsymmetricCipherKeyPair((org.bouncycastle.crypto.params.AsymmetricKeyParameter)x25519PrivateKey.generatePublicKey(), (org.bouncycastle.crypto.params.AsymmetricKeyParameter)x25519PrivateKey);
            }
            case X448_SHA512: {
                X448PrivateKeyParameters x448PrivateKey = new X448PrivateKeyParameters(random);
                return new org.bouncycastle.crypto.AsymmetricCipherKeyPair((org.bouncycastle.crypto.params.AsymmetricKeyParameter)x448PrivateKey.generatePublicKey(), (org.bouncycastle.crypto.params.AsymmetricKeyParameter)x448PrivateKey);
            }
        }
        throw new UnsupportedOperationException("Can't generate random key for kem: " + kem);
    }

    public boolean isSupported(AEAD aead) {
        if (aead == null) {
            return false;
        }
        switch (aead) {
            case AES_GCM128: 
            case AES_GCM256: 
            case CHACHA20_POLY1305: {
                return true;
            }
        }
        return false;
    }

    public boolean isSupported(KEM kem) {
        if (kem == null) {
            return false;
        }
        switch (kem) {
            case P256_SHA256: 
            case P384_SHA348: 
            case P521_SHA512: 
            case X25519_SHA256: 
            case X448_SHA512: {
                return true;
            }
        }
        return false;
    }

    public boolean isSupported(KDF kdf) {
        if (kdf == null) {
            return false;
        }
        switch (kdf) {
            case HKDF_SHA256: 
            case HKDF_SHA384: 
            case HKDF_SHA512: {
                return true;
            }
        }
        return false;
    }
}

