/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.hpke.bouncycastle;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.HPKESenderContext;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleCryptoOperation;
import io.netty.incubator.codec.hpke.bouncycastle.BouncyCastleHPKEContext;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.hpke.HPKEContext;
import org.bouncycastle.crypto.hpke.HPKEContextWithEncapsulation;

final class BouncyCastleHPKESenderContext
extends BouncyCastleHPKEContext
implements HPKESenderContext {
    private final BouncyCastleCryptoOperation seal;

    BouncyCastleHPKESenderContext(final HPKEContextWithEncapsulation context) {
        super((HPKEContext)context);
        this.seal = new BouncyCastleCryptoOperation(){

            @Override
            protected byte[] execute(byte[] aad, byte[] in, int inOffset, int inLength) throws InvalidCipherTextException {
                return context.seal(aad, in, inOffset, inLength);
            }
        };
    }

    public byte[] encapsulation() {
        return ((HPKEContextWithEncapsulation)this.context).getEncapsulation();
    }

    public void seal(ByteBufAllocator alloc, ByteBuf aad, ByteBuf pt, ByteBuf out) throws CryptoException {
        this.checkClosed();
        this.seal.execute(aad, pt, out);
    }

    public boolean isDirectBufferPreferred() {
        return false;
    }
}

