/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.buffer.ByteBuf;

public final class VarIntCodecUtils {
    private VarIntCodecUtils() {
    }

    public static int numBytesForVariableLengthInteger(long value) {
        if (value <= 63L) {
            return 1;
        }
        if (value <= 16383L) {
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            return 4;
        }
        if (value <= 0x3FFFFFFFFFFFFFFFL) {
            return 8;
        }
        throw new IllegalArgumentException("Value larger then 4611686018427387903: " + value);
    }

    public static int numBytesForVariableLengthIntegerFromByte(byte value) {
        switch (value & 0xC0) {
            case 0: {
                return 1;
            }
            case 64: {
                return 2;
            }
            case 128: {
                return 4;
            }
            case 192: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Illegal byte value: " + String.format("%02X", value));
    }

    public static long readVariableLengthInteger(ByteBuf in, int len) {
        long variableLength = VarIntCodecUtils.getVariableLengthInteger(in, in.readerIndex(), len);
        in.skipBytes(len);
        return variableLength;
    }

    public static long getVariableLengthInteger(ByteBuf in, int offset, int len) {
        switch (len) {
            case 1: {
                return in.getUnsignedByte(offset);
            }
            case 2: {
                return in.getUnsignedShort(offset) & 0x3FFF;
            }
            case 4: {
                return in.getUnsignedInt(offset) & 0x3FFFFFFFL;
            }
            case 8: {
                return in.getLong(offset) & 0x3FFFFFFFFFFFFFFFL;
            }
        }
        throw new IllegalArgumentException("len must be either 1, 2, 4 or 8, but was " + len);
    }

    public static void writeVariableLengthInteger(ByteBuf out, long value) {
        int numBytes = VarIntCodecUtils.numBytesForVariableLengthInteger(value);
        VarIntCodecUtils.writeVariableLengthInteger(out, value, numBytes);
    }

    private static void writeVariableLengthInteger(ByteBuf out, long value, int numBytes) {
        int writerIndex = out.writerIndex();
        switch (numBytes) {
            case 1: {
                out.writeByte((int)((byte)value));
                break;
            }
            case 2: {
                out.writeShort((int)((short)value));
                VarIntCodecUtils.encodeLengthIntoBuffer(out, writerIndex, (byte)64);
                break;
            }
            case 4: {
                out.writeInt((int)value);
                VarIntCodecUtils.encodeLengthIntoBuffer(out, writerIndex, (byte)-128);
                break;
            }
            case 8: {
                out.writeLong(value);
                VarIntCodecUtils.encodeLengthIntoBuffer(out, writerIndex, (byte)-64);
                break;
            }
            default: {
                throw new IllegalArgumentException("numBytes must be either 1, 2, 4 or 8, but was " + numBytes);
            }
        }
    }

    private static void encodeLengthIntoBuffer(ByteBuf out, int index, byte b) {
        out.setByte(index, out.getByte(index) | b);
    }
}

