/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.incubator.codec.bhttp.PseudoHeaderName;

final class BinaryHttpHeaders
extends DefaultHttpHeaders {
    private static final DefaultHeaders.NameValidator<CharSequence> BINARY_HTTP_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        public void validateName(CharSequence name) {
            if (name != null && name.length() != 0) {
                int index = HttpHeaderValidationUtil.validateToken((CharSequence)name);
                if (index != -1) {
                    if (index != 0 || !PseudoHeaderName.isPseudoHeaderPrefix(name.charAt(index))) {
                        throw new IllegalArgumentException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(name.charAt(index)) + " at index " + index + " of header '" + name + "'.");
                    }
                    if (PseudoHeaderName.isPseudoHeader(name)) {
                        throw new IllegalArgumentException("only custom pseudo-headers are allowed: '" + name + "'.");
                    }
                }
            } else {
                throw new IllegalArgumentException("empty headers are not allowed [" + name + ']');
            }
        }
    };

    static BinaryHttpHeaders newHeaders(boolean validate) {
        return new BinaryHttpHeaders(validate, BINARY_HTTP_VALIDATOR);
    }

    static BinaryHttpHeaders newTrailers(boolean validate) {
        return new BinaryHttpHeaders(validate);
    }

    private BinaryHttpHeaders(boolean validate) {
        super(validate);
    }

    private BinaryHttpHeaders(boolean validate, DefaultHeaders.NameValidator<CharSequence> validator) {
        super(validate, validator);
    }
}

