/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.bhttp.BinaryHttpHeaders;
import io.netty.incubator.codec.bhttp.BinaryHttpRequest;
import io.netty.incubator.codec.bhttp.BinaryHttpResponse;
import io.netty.incubator.codec.bhttp.DefaultBinaryHttpRequest;
import io.netty.incubator.codec.bhttp.DefaultBinaryHttpResponse;
import io.netty.incubator.codec.bhttp.PseudoHeaderName;
import io.netty.incubator.codec.bhttp.VarIntCodecUtils;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import java.nio.charset.StandardCharsets;

public final class BinaryHttpParser {
    private static final boolean[] ALLOWED_TOKEN;
    private static final boolean[] ALLOWED_SCHEME;
    private static final ByteProcessor TOKEN_VALIDATOR;
    private static final ByteProcessor SCHEME_VALIDATOR;
    private static final ByteProcessor PADDING_VALIDATOR;
    private State state = State.READ_FRAME_TYPE;
    private boolean completeBodyReceived;
    private long contentLength = -1L;
    private final int maxFieldSectionSize;

    public BinaryHttpParser(int maxFieldSectionSize) {
        this.maxFieldSectionSize = ObjectUtil.checkPositiveOrZero((int)maxFieldSectionSize, (String)"maxFieldSectionSize");
    }

    public HttpObject parse(ByteBuf in, boolean completeBodyReceived) {
        try {
            if (!completeBodyReceived && this.completeBodyReceived) {
                throw new IllegalStateException("Body was already marked as complete before");
            }
            this.completeBodyReceived = completeBodyReceived;
            block11: while (true) {
                switch (this.state) {
                    case DISCARD: {
                        in.skipBytes(in.readableBytes());
                        return null;
                    }
                    case READ_FRAME_TYPE: {
                        assert (this.contentLength == -1L) : "contentLength should have been reset";
                        this.state = BinaryHttpParser.readFramingIndicator(in);
                        continue block11;
                    }
                    case READ_KNOWN_LENGTH_REQUEST_HEAD: 
                    case READ_INDETERMINATE_LENGTH_REQUEST_HEAD: {
                        assert (this.contentLength == -1L) : "contentLength should have been reset";
                        BinaryHttpRequest request = BinaryHttpParser.readRequestHead(in, this.state.knownLength, this.maxFieldSectionSize);
                        if (request == null) {
                            BinaryHttpParser.throwIfNotReadAllAndBodyReceived(in, completeBodyReceived);
                            return null;
                        }
                        this.state = this.state.knownLength ? State.READ_KNOWN_LENGTH_CONTENT : State.READ_INDETERMINATE_LENGTH_CONTENT;
                        return request;
                    }
                    case READ_KNOWN_LENGTH_RESPONSE_HEAD: 
                    case READ_INDETERMINATE_LENGTH_RESPONSE_HEAD: {
                        boolean informational;
                        assert (this.contentLength == -1L) : "contentLength should have been reset";
                        BinaryHttpResponse response = BinaryHttpParser.readResponseHead(in, this.state.knownLength, this.maxFieldSectionSize);
                        if (response == null) {
                            BinaryHttpParser.throwIfNotReadAllAndBodyReceived(in, completeBodyReceived);
                            return null;
                        }
                        boolean bl = informational = response.status().codeClass() == HttpStatusClass.INFORMATIONAL;
                        if (informational) {
                            return new DefaultFullHttpResponse(response.protocolVersion(), response.status(), Unpooled.EMPTY_BUFFER, response.headers(), (HttpHeaders)new DefaultHttpHeaders());
                        }
                        this.state = this.state.knownLength ? State.READ_KNOWN_LENGTH_CONTENT : State.READ_INDETERMINATE_LENGTH_CONTENT;
                        return response;
                    }
                    case READ_KNOWN_LENGTH_CONTENT: 
                    case READ_INDETERMINATE_LENGTH_CONTENT: {
                        int numBytes;
                        assert (this.contentLength >= -1L);
                        if (this.contentLength == -1L) {
                            if (in.readableBytes() == 0) {
                                if (completeBodyReceived) {
                                    if (this.state.knownLength) {
                                        this.state = State.READ_KNOWN_LENGTH_FIELD_SECTION_TRAILERS;
                                        continue block11;
                                    }
                                    this.state = State.READ_INDETERMINATE_LENGTH_FIELD_SECTION_TRAILERS;
                                    continue block11;
                                }
                                return null;
                            }
                            numBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(in.readerIndex()));
                            if (in.readableBytes() < numBytes) {
                                BinaryHttpParser.throwIfNotReadAllAndBodyReceived(in, completeBodyReceived);
                                return null;
                            }
                            this.contentLength = VarIntCodecUtils.readVariableLengthInteger(in, numBytes);
                            if (this.contentLength == 0L) {
                                this.state = this.state.knownLength ? State.READ_KNOWN_LENGTH_FIELD_SECTION_TRAILERS : State.READ_INDETERMINATE_LENGTH_FIELD_SECTION_TRAILERS;
                                this.contentLength = -1L;
                                continue block11;
                            }
                        }
                        numBytes = (int)Math.min(this.contentLength, (long)in.readableBytes());
                        this.contentLength -= (long)numBytes;
                        if (this.contentLength == 0L) {
                            this.contentLength = -1L;
                            if (this.state.knownLength) {
                                this.state = State.READ_KNOWN_LENGTH_FIELD_SECTION_TRAILERS;
                            }
                        } else {
                            if (completeBodyReceived) {
                                throw new CorruptedFrameException("Closed input while still decoding the content");
                            }
                            if (numBytes == 0) {
                                return null;
                            }
                        }
                        return new DefaultHttpContent(in.readRetainedSlice(numBytes));
                    }
                    case READ_KNOWN_LENGTH_FIELD_SECTION_TRAILERS: 
                    case READ_INDETERMINATE_LENGTH_FIELD_SECTION_TRAILERS: {
                        assert (this.contentLength == -1L) : "contentLength should have been reset";
                        BinaryHttpHeaders trailers = BinaryHttpParser.readFieldSection(in, true, this.state.knownLength, this.maxFieldSectionSize);
                        if (trailers == null) {
                            if (completeBodyReceived) {
                                BinaryHttpParser.throwIfNotReadAllAndBodyReceived(in, true);
                                this.state = State.READ_PADDING;
                                return LastHttpContent.EMPTY_LAST_CONTENT;
                            }
                            return null;
                        }
                        this.state = State.READ_PADDING;
                        return new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, (HttpHeaders)trailers);
                    }
                    case READ_PADDING: {
                        assert (this.contentLength == -1L) : "contentLength should have been reset";
                        BinaryHttpParser.readPadding(in);
                        return null;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            this.state = State.DISCARD;
            throw e;
        }
    }

    private static void throwIfNotReadAllAndBodyReceived(ByteBuf in, boolean completeBodyReceived) {
        if (in.isReadable() && completeBodyReceived) {
            throw new CorruptedFrameException("Closed input while still decoding");
        }
    }

    private static void readPadding(ByteBuf in) {
        in.forEachByte(PADDING_VALIDATOR);
        in.skipBytes(in.readableBytes());
    }

    private static State readFramingIndicator(ByteBuf in) {
        if (!in.isReadable()) {
            return State.READ_FRAME_TYPE;
        }
        int bytesNeeded = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(in.readerIndex()));
        if (bytesNeeded > in.readableBytes()) {
            return State.READ_FRAME_TYPE;
        }
        int framingIndicator = (int)VarIntCodecUtils.readVariableLengthInteger(in, bytesNeeded);
        switch (framingIndicator) {
            case 0: {
                return State.READ_KNOWN_LENGTH_REQUEST_HEAD;
            }
            case 1: {
                return State.READ_KNOWN_LENGTH_RESPONSE_HEAD;
            }
            case 2: {
                return State.READ_INDETERMINATE_LENGTH_REQUEST_HEAD;
            }
            case 3: {
                return State.READ_INDETERMINATE_LENGTH_RESPONSE_HEAD;
            }
        }
        throw new IllegalArgumentException("Unknown value for a FrameIndicator: " + framingIndicator);
    }

    private static BinaryHttpRequest readRequestHead(ByteBuf in, boolean knownLength, int maxFieldSectionSize) {
        int pathLengthIdx;
        int pathLengthBytes;
        int authorityLengthIdx;
        int authorityLengthBytes;
        int schemeLengthIdx;
        int schemeLengthBytes;
        int methodLengthIdx;
        int methodLengthBytes;
        if (!in.isReadable()) {
            return null;
        }
        int sumBytes = 0;
        if ((sumBytes += (methodLengthBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(methodLengthIdx = in.readerIndex() + sumBytes)))) >= in.readableBytes()) {
            return null;
        }
        long methodLength = VarIntCodecUtils.getVariableLengthInteger(in, methodLengthIdx, methodLengthBytes);
        if ((sumBytes = (int)((long)sumBytes + methodLength)) >= in.readableBytes()) {
            return null;
        }
        int methodIdx = methodLengthIdx + methodLengthBytes;
        if ((sumBytes += (schemeLengthBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(schemeLengthIdx = in.readerIndex() + sumBytes)))) >= in.readableBytes()) {
            return null;
        }
        long schemeLength = VarIntCodecUtils.getVariableLengthInteger(in, schemeLengthIdx, schemeLengthBytes);
        if ((sumBytes = (int)((long)sumBytes + schemeLength)) >= in.readableBytes()) {
            return null;
        }
        int schemeIdx = schemeLengthIdx + schemeLengthBytes;
        if ((sumBytes += (authorityLengthBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(authorityLengthIdx = in.readerIndex() + sumBytes)))) >= in.readableBytes()) {
            return null;
        }
        long authorityLength = VarIntCodecUtils.getVariableLengthInteger(in, authorityLengthIdx, authorityLengthBytes);
        if ((sumBytes = (int)((long)sumBytes + authorityLength)) >= in.readableBytes()) {
            return null;
        }
        int authorityIdx = authorityLengthIdx + authorityLengthBytes;
        if ((sumBytes += (pathLengthBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(pathLengthIdx = in.readerIndex() + sumBytes)))) >= in.readableBytes()) {
            return null;
        }
        long pathLength = VarIntCodecUtils.getVariableLengthInteger(in, pathLengthIdx, pathLengthBytes);
        if ((sumBytes = (int)((long)sumBytes + pathLength)) >= in.readableBytes()) {
            return null;
        }
        int pathIdx = pathLengthIdx + pathLengthBytes;
        int fieldSectionIdx = in.readerIndex() + sumBytes;
        int fieldSectionLength = in.readableBytes() - sumBytes;
        ByteBuf fieldSectionSlice = in.slice(fieldSectionIdx, fieldSectionLength);
        int fieldSectionReadableBytes = fieldSectionSlice.readableBytes();
        BinaryHttpHeaders headers = BinaryHttpParser.readFieldSection(fieldSectionSlice, false, knownLength, maxFieldSectionSize);
        if (headers == null) {
            return null;
        }
        sumBytes += fieldSectionReadableBytes - fieldSectionSlice.readableBytes();
        in.forEachByte(methodIdx, (int)methodLength, TOKEN_VALIDATOR);
        in.forEachByte(schemeIdx, (int)schemeLength, SCHEME_VALIDATOR);
        in.forEachByte(authorityIdx, (int)authorityLength, TOKEN_VALIDATOR);
        in.forEachByte(pathIdx, (int)pathLength, TOKEN_VALIDATOR);
        String method = in.toString(methodIdx, (int)methodLength, StandardCharsets.US_ASCII);
        String scheme = in.toString(schemeIdx, (int)schemeLength, StandardCharsets.US_ASCII);
        String authority = in.toString(authorityIdx, (int)authorityLength, StandardCharsets.US_ASCII);
        String path = in.toString(pathIdx, (int)pathLength, StandardCharsets.US_ASCII);
        DefaultBinaryHttpRequest request = new DefaultBinaryHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method), scheme, authority, path, headers);
        in.skipBytes(sumBytes);
        return request;
    }

    private static BinaryHttpResponse readResponseHead(ByteBuf in, boolean knownLength, int maxFieldSectionSize) {
        if (!in.isReadable()) {
            return null;
        }
        int sumBytes = 0;
        int statusLengthIdx = in.readerIndex();
        int statusLengthBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(statusLengthIdx));
        if ((sumBytes += statusLengthBytes) >= in.readableBytes()) {
            return null;
        }
        long status = VarIntCodecUtils.getVariableLengthInteger(in, statusLengthIdx, statusLengthBytes);
        int fieldSectionIdx = in.readerIndex() + sumBytes;
        int fieldSectionLength = in.readableBytes() - sumBytes;
        ByteBuf fieldSectionSlice = in.slice(fieldSectionIdx, fieldSectionLength);
        int fieldSectionReadableBytes = fieldSectionSlice.readableBytes();
        BinaryHttpHeaders headers = BinaryHttpParser.readFieldSection(fieldSectionSlice, false, knownLength, maxFieldSectionSize);
        if (headers == null) {
            return null;
        }
        in.skipBytes(sumBytes += fieldSectionReadableBytes - fieldSectionSlice.readableBytes());
        if (status < 100L || status > 599L) {
            throw new IllegalArgumentException("Invalid status: " + status);
        }
        HttpResponseStatus responseStatus = HttpResponseStatus.valueOf((int)((int)status));
        return new DefaultBinaryHttpResponse(HttpVersion.HTTP_1_1, responseStatus, headers);
    }

    private static int getIndeterminateLength(ByteBuf in) {
        if (!in.isReadable()) {
            return -1;
        }
        boolean name = true;
        int sumBytes = 0;
        while (sumBytes < in.readableBytes()) {
            int idx = in.readerIndex() + sumBytes;
            int possibleTerminatorBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(idx));
            if (in.readableBytes() < (sumBytes += possibleTerminatorBytes)) {
                return -1;
            }
            long possibleTerminator = VarIntCodecUtils.getVariableLengthInteger(in, idx, possibleTerminatorBytes);
            sumBytes = (int)((long)sumBytes + possibleTerminator);
            if (in.readableBytes() < sumBytes) {
                return -1;
            }
            if (name && possibleTerminator == 0L) {
                return sumBytes - possibleTerminatorBytes;
            }
            name = !name;
        }
        return -1;
    }

    private static BinaryHttpHeaders readFieldSection(ByteBuf in, boolean trailers, boolean knownLength, int maxFieldSectionSize) {
        long fieldSectionLength;
        int fieldSectionBytes;
        if (!in.isReadable()) {
            return null;
        }
        int sumBytes = 0;
        if (knownLength) {
            fieldSectionBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(in.readerIndex()));
            if (in.readableBytes() < (sumBytes += fieldSectionBytes)) {
                BinaryHttpParser.checkFieldSectionTooLarge(in.readableBytes(), maxFieldSectionSize);
                return null;
            }
            fieldSectionLength = VarIntCodecUtils.getVariableLengthInteger(in, in.readerIndex(), fieldSectionBytes);
            sumBytes = (int)((long)sumBytes + fieldSectionLength);
        } else {
            int indeterminateLength = BinaryHttpParser.getIndeterminateLength(in);
            assert (indeterminateLength >= -1);
            if (indeterminateLength == -1) {
                BinaryHttpParser.checkFieldSectionTooLarge(in.readableBytes(), maxFieldSectionSize);
                return null;
            }
            fieldSectionBytes = 0;
            fieldSectionLength = indeterminateLength;
            sumBytes = (int)fieldSectionLength + 1;
        }
        BinaryHttpParser.checkFieldSectionTooLarge(fieldSectionLength, maxFieldSectionSize);
        if (in.readableBytes() < sumBytes) {
            return null;
        }
        in.skipBytes(fieldSectionBytes);
        BinaryHttpHeaders headers = trailers ? BinaryHttpHeaders.newTrailers(true) : BinaryHttpHeaders.newHeaders(true);
        HeaderType lastType = HeaderType.PSEUDO_HEADER;
        while (fieldSectionLength != 0L) {
            int readableBytes = in.readableBytes();
            lastType = BinaryHttpParser.readFieldLine(in, (HttpHeaders)headers, lastType, trailers);
            assert (lastType != null);
            int read = readableBytes - in.readableBytes();
            assert (read > 0);
            fieldSectionLength -= (long)read;
        }
        if (!knownLength) {
            byte terminator = in.readByte();
            assert (terminator == 0);
        }
        return headers;
    }

    private static void checkFieldSectionTooLarge(long fieldSectionSize, int maxFieldSectionSize) {
        if (fieldSectionSize > (long)maxFieldSectionSize) {
            throw new TooLongFrameException("field-section length exceeds configured maximum: " + fieldSectionSize + " > " + maxFieldSectionSize);
        }
    }

    private static HeaderType readFieldLine(ByteBuf in, HttpHeaders headers, HeaderType lastType, boolean trailers) {
        if (!in.isReadable()) {
            return null;
        }
        int sumBytes = 0;
        int nameLengthIdx = in.readerIndex();
        int nameLengthBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(in.readerIndex()));
        if ((sumBytes += nameLengthBytes) >= in.readableBytes()) {
            return null;
        }
        long nameLength = VarIntCodecUtils.getVariableLengthInteger(in, in.readerIndex(), nameLengthBytes);
        if ((sumBytes = (int)((long)sumBytes + nameLength)) >= in.readableBytes()) {
            return null;
        }
        int nameIdx = nameLengthIdx + nameLengthBytes;
        int valueLengthIdx = nameIdx + (int)nameLength;
        int valueLengthBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte(in.getByte(valueLengthIdx));
        sumBytes += valueLengthBytes;
        long valueLength = VarIntCodecUtils.getVariableLengthInteger(in, valueLengthIdx, valueLengthBytes);
        if ((sumBytes = (int)((long)sumBytes + valueLength)) >= in.readableBytes()) {
            return null;
        }
        int valueIdx = valueLengthIdx + valueLengthBytes;
        CharSequence name = in.getCharSequence(nameIdx, (int)nameLength, StandardCharsets.US_ASCII);
        boolean pseudo = PseudoHeaderName.hasPseudoHeaderFormat(name);
        if (pseudo) {
            if (trailers) {
                throw new DecoderException("pseudo-fields are not allowed in trailers: " + name);
            }
            if (PseudoHeaderName.isPseudoHeader(name)) {
                throw new DecoderException("pseudo-field not allowed in headers: " + name);
            }
            if (lastType == HeaderType.REGULAR_HEADER) {
                throw new DecoderException("pseudo-field must not follow non pseudo-field");
            }
        }
        CharSequence value = in.getCharSequence(valueIdx, (int)valueLength, StandardCharsets.US_ASCII);
        headers.add(name, (Object)value);
        in.skipBytes(sumBytes);
        return pseudo ? HeaderType.PSEUDO_HEADER : HeaderType.REGULAR_HEADER;
    }

    static {
        int b2;
        ALLOWED_TOKEN = new boolean[256];
        for (b2 = -128; b2 < 127; b2 = (int)((byte)(b2 + 1))) {
            BinaryHttpParser.ALLOWED_TOKEN[128 + b2] = !Character.isWhitespace(b2);
        }
        ALLOWED_SCHEME = new boolean[256];
        for (b2 = -128; b2 < 127; b2 = (int)((byte)(b2 + 1))) {
            BinaryHttpParser.ALLOWED_SCHEME[128 + b2] = Character.isAlphabetic(b2) || Character.isDigit(b2) || b2 == 43 || b2 == 45 || b2 == 46;
        }
        TOKEN_VALIDATOR = b -> {
            if (ALLOWED_TOKEN[b + 128]) {
                return true;
            }
            throw new IllegalArgumentException("Invalid char in token received: '" + b + "' (0x" + Integer.toHexString(b) + ")");
        };
        SCHEME_VALIDATOR = b -> {
            if (ALLOWED_SCHEME[b + 128]) {
                return true;
            }
            throw new IllegalArgumentException("Invalid char in scheme received : '" + b + "' (0x" + Integer.toHexString(b) + ")");
        };
        PADDING_VALIDATOR = b -> {
            if (b != 0) {
                throw new CorruptedFrameException("Invalid byte used for padding: '" + b + "' (0x" + Integer.toHexString(b) + ")");
            }
            return true;
        };
    }

    private static enum HeaderType {
        REGULAR_HEADER,
        PSEUDO_HEADER;

    }

    private static enum State {
        READ_FRAME_TYPE(true),
        READ_KNOWN_LENGTH_REQUEST_HEAD(true),
        READ_KNOWN_LENGTH_RESPONSE_HEAD(true),
        READ_KNOWN_LENGTH_FIELD_SECTION_TRAILERS(true),
        READ_KNOWN_LENGTH_CONTENT(true),
        READ_INDETERMINATE_LENGTH_REQUEST_HEAD(false),
        READ_INDETERMINATE_LENGTH_RESPONSE_HEAD(false),
        READ_INDETERMINATE_LENGTH_CONTENT(false),
        READ_INDETERMINATE_LENGTH_FIELD_SECTION_TRAILERS(false),
        READ_PADDING(true),
        DISCARD(true);

        final boolean knownLength;

        private State(boolean knownLength) {
            this.knownLength = knownLength;
        }
    }
}

