/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.bhttp.BinaryHttpHeaders;
import io.netty.incubator.codec.bhttp.BinaryHttpRequest;
import io.netty.incubator.codec.bhttp.BinaryHttpResponse;
import io.netty.incubator.codec.bhttp.DefaultBinaryHttpRequest;
import io.netty.incubator.codec.bhttp.DefaultBinaryHttpResponse;
import io.netty.incubator.codec.bhttp.DefaultFullBinaryHttpRequest;
import io.netty.incubator.codec.bhttp.DefaultFullBinaryHttpResponse;
import io.netty.incubator.codec.bhttp.FullBinaryHttpRequest;
import io.netty.incubator.codec.bhttp.FullBinaryHttpResponse;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class BinaryHttpConverter {
    private BinaryHttpConverter() {
    }

    public static BinaryHttpRequest convert(HttpRequest request, String scheme, String authority) {
        BinaryHttpHeaders headers = BinaryHttpHeaders.newHeaders(true);
        BinaryHttpConverter.copyAndSanitize(request.headers(), (HttpHeaders)headers);
        DefaultBinaryHttpRequest binaryHttpRequest = new DefaultBinaryHttpRequest(request.protocolVersion(), request.method(), scheme, authority, request.uri(), headers);
        binaryHttpRequest.setDecoderResult(request.decoderResult());
        return binaryHttpRequest;
    }

    public static FullBinaryHttpRequest convert(FullHttpRequest request, String scheme, String authority) {
        BinaryHttpHeaders headers = BinaryHttpHeaders.newHeaders(true);
        BinaryHttpConverter.copyAndSanitize(request.headers(), (HttpHeaders)headers);
        BinaryHttpHeaders trailers = BinaryHttpHeaders.newTrailers(true);
        BinaryHttpConverter.copyAndSanitize(request.trailingHeaders(), (HttpHeaders)trailers);
        DefaultFullBinaryHttpRequest binaryHttpRequest = new DefaultFullBinaryHttpRequest(request.protocolVersion(), request.method(), scheme, authority, request.uri(), request.content().retain(), headers, trailers);
        binaryHttpRequest.setDecoderResult(request.decoderResult());
        request.release();
        return binaryHttpRequest;
    }

    public static BinaryHttpResponse convert(HttpResponse response) {
        BinaryHttpHeaders headers = BinaryHttpHeaders.newHeaders(true);
        BinaryHttpConverter.copyAndSanitize(response.headers(), (HttpHeaders)headers);
        DefaultBinaryHttpResponse binaryHttpResponse = new DefaultBinaryHttpResponse(response.protocolVersion(), response.status(), headers);
        binaryHttpResponse.setDecoderResult(response.decoderResult());
        return binaryHttpResponse;
    }

    public static FullBinaryHttpResponse convert(FullHttpResponse response) {
        BinaryHttpHeaders headers = BinaryHttpHeaders.newHeaders(true);
        BinaryHttpConverter.copyAndSanitize(response.headers(), (HttpHeaders)headers);
        BinaryHttpHeaders trailers = BinaryHttpHeaders.newTrailers(true);
        BinaryHttpConverter.copyAndSanitize(response.trailingHeaders(), (HttpHeaders)trailers);
        DefaultFullBinaryHttpResponse binaryHttpResponse = new DefaultFullBinaryHttpResponse(response.protocolVersion(), response.status(), response.content().retain(), (HttpHeaders)headers, (HttpHeaders)trailers);
        binaryHttpResponse.setDecoderResult(response.decoderResult());
        response.release();
        return binaryHttpResponse;
    }

    public static LastHttpContent convert(LastHttpContent content) {
        BinaryHttpHeaders trailers = BinaryHttpHeaders.newTrailers(true);
        BinaryHttpConverter.copyAndSanitize(content.trailingHeaders(), (HttpHeaders)trailers);
        DefaultLastHttpContent binaryContent = new DefaultLastHttpContent(content.content().retain(), (HttpHeaders)trailers);
        content.release();
        return binaryContent;
    }

    public static void copyAndSanitize(HttpHeaders in, HttpHeaders out) {
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(out, "out");
        Iterator it = in.iteratorCharSequence();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            CharSequence name = (CharSequence)entry.getKey();
            if (name instanceof AsciiString) {
                out.add((CharSequence)((AsciiString)name).toLowerCase(), entry.getValue());
                continue;
            }
            if (name instanceof String) {
                out.add(((String)name).toLowerCase(), entry.getValue());
                continue;
            }
            if (BinaryHttpConverter.isAnyUpperCase(name)) {
                out.add((CharSequence)new AsciiString(name).toLowerCase(), entry.getValue());
                continue;
            }
            out.add(name, entry.getValue());
        }
    }

    private static boolean isAnyUpperCase(CharSequence name) {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if (!AsciiString.isUpperCase((char)name.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

