/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.example.socksproxy;

import io.netty.contrib.handler.codec.example.socksproxy.SocksServerConnectHandler;
import io.netty.contrib.handler.codec.example.socksproxy.SocksServerUtils;
import io.netty.contrib.handler.codec.socksx.SocksMessage;
import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandRequest;
import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandType;
import io.netty.contrib.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.contrib.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.contrib.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.contrib.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.contrib.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.contrib.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.contrib.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.contrib.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty.contrib.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.SimpleChannelInboundHandler;

public final class SocksServerHandler
extends SimpleChannelInboundHandler<SocksMessage> {
    public static final SocksServerHandler INSTANCE = new SocksServerHandler();

    private SocksServerHandler() {
    }

    public void messageReceived(ChannelHandlerContext ctx, SocksMessage socksRequest) throws Exception {
        switch (socksRequest.version()) {
            case SOCKS4a: {
                Socks4CommandRequest socksV4CmdRequest = (Socks4CommandRequest)socksRequest;
                if (socksV4CmdRequest.type() == Socks4CommandType.CONNECT) {
                    ctx.pipeline().addLast(new ChannelHandler[]{new SocksServerConnectHandler()});
                    ctx.fireChannelRead((Object)socksRequest);
                    ctx.pipeline().remove((ChannelHandler)this);
                    break;
                }
                ctx.close();
                break;
            }
            case SOCKS5: {
                if (socksRequest instanceof Socks5InitialRequest) {
                    ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                    ctx.write((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.NO_AUTH));
                    break;
                }
                if (socksRequest instanceof Socks5PasswordAuthRequest) {
                    ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                    ctx.write((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS));
                    break;
                }
                if (socksRequest instanceof Socks5CommandRequest) {
                    Socks5CommandRequest socks5CmdRequest = (Socks5CommandRequest)socksRequest;
                    if (socks5CmdRequest.type() == Socks5CommandType.CONNECT) {
                        ctx.pipeline().addLast(new ChannelHandler[]{new SocksServerConnectHandler()});
                        ctx.fireChannelRead((Object)socksRequest);
                        ctx.pipeline().remove((ChannelHandler)this);
                        break;
                    }
                    ctx.close();
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        throwable.printStackTrace();
        SocksServerUtils.closeOnFlush(ctx.channel());
    }

    public boolean isSharable() {
        return true;
    }
}

