/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.proxy;

import io.netty5.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.Objects;

public final class ProxyConnectionEvent {
    private final String protocol;
    private final String authScheme;
    private final SocketAddress proxyAddress;
    private final SocketAddress destinationAddress;
    private String strVal;

    public ProxyConnectionEvent(String protocol, String authScheme, SocketAddress proxyAddress, SocketAddress destinationAddress) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(authScheme, "authScheme");
        Objects.requireNonNull(proxyAddress, "proxyAddress");
        Objects.requireNonNull(destinationAddress, "destinationAddress");
        this.protocol = protocol;
        this.authScheme = authScheme;
        this.proxyAddress = proxyAddress;
        this.destinationAddress = destinationAddress;
    }

    public String protocol() {
        return this.protocol;
    }

    public String authScheme() {
        return this.authScheme;
    }

    public <T extends SocketAddress> T proxyAddress() {
        return (T)this.proxyAddress;
    }

    public <T extends SocketAddress> T destinationAddress() {
        return (T)this.destinationAddress;
    }

    public String toString() {
        if (this.strVal != null) {
            return this.strVal;
        }
        StringBuilder buf = new StringBuilder(128).append(StringUtil.simpleClassName((Object)this)).append('(').append(this.protocol).append(", ").append(this.authScheme).append(", ").append(this.proxyAddress).append(" => ").append(this.destinationAddress).append(')');
        this.strVal = buf.toString();
        return this.strVal;
    }
}

