/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v5;

import io.netty.contrib.handler.codec.socksx.SocksVersion;
import io.netty.contrib.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.contrib.handler.codec.socksx.v5.Socks5AddressDecoder;
import io.netty.contrib.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.contrib.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.codec.DecoderResult;
import java.util.Objects;

public class Socks5CommandResponseDecoder
extends ByteToMessageDecoder {
    private final Socks5AddressDecoder addressDecoder;
    private State state = State.INIT;

    public Socks5CommandResponseDecoder() {
        this(Socks5AddressDecoder.DEFAULT);
    }

    public Socks5CommandResponseDecoder(Socks5AddressDecoder addressDecoder) {
        this.addressDecoder = Objects.requireNonNull(addressDecoder, "addressDecoder");
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        try {
            switch (this.state) {
                case INIT: {
                    if (in.readableBytes() < 6) {
                        return;
                    }
                    int readerIndex = in.readerOffset();
                    byte version = in.readByte();
                    if (version != SocksVersion.SOCKS5.byteValue()) {
                        throw new DecoderException("unsupported version: " + version + " (expected: " + SocksVersion.SOCKS5.byteValue() + ")");
                    }
                    Socks5CommandStatus status = Socks5CommandStatus.valueOf(in.readByte());
                    in.skipReadableBytes(1);
                    Socks5AddressType addrType = Socks5AddressType.valueOf(in.readByte());
                    String addr = this.addressDecoder.decodeAddress(addrType, in);
                    if (addr == null || in.readableBytes() < 2) {
                        in.readerOffset(readerIndex);
                        return;
                    }
                    int port = in.readUnsignedShort();
                    ctx.fireChannelRead((Object)new DefaultSocks5CommandResponse(status, addrType, addr, port));
                    this.state = State.SUCCESS;
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    ctx.fireChannelRead((Object)in.readSplit(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipReadableBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(ctx, e);
        }
    }

    private void fail(ChannelHandlerContext ctx, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException((Throwable)cause);
        }
        this.state = State.FAILURE;
        DefaultSocks5CommandResponse m = new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, Socks5AddressType.IPv4, null, 0);
        m.setDecoderResult(DecoderResult.failure((Throwable)cause));
        ctx.fireChannelRead((Object)m);
    }

    private static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

