/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v5;

import io.netty.contrib.handler.codec.socksx.v5.Socks5AddressType;
import io.netty5.buffer.Buffer;
import io.netty5.handler.codec.EncoderException;
import io.netty5.util.NetUtil;
import java.nio.charset.StandardCharsets;

public interface Socks5AddressEncoder {
    public static final Socks5AddressEncoder DEFAULT = (addrType, addrValue, out) -> {
        byte typeVal = addrType.byteValue();
        if (typeVal == Socks5AddressType.IPv4.byteValue()) {
            if (addrValue != null) {
                out.writeBytes(NetUtil.createByteArrayFromIpAddressString((String)addrValue));
            } else {
                out.writeInt(0);
            }
        } else if (typeVal == Socks5AddressType.DOMAIN.byteValue()) {
            if (addrValue != null) {
                out.writeByte((byte)addrValue.length());
                out.writeCharSequence((CharSequence)addrValue, StandardCharsets.US_ASCII);
            } else {
                out.writeByte((byte)0);
            }
        } else if (typeVal == Socks5AddressType.IPv6.byteValue()) {
            if (addrValue != null) {
                out.writeBytes(NetUtil.createByteArrayFromIpAddressString((String)addrValue));
            } else {
                out.writeLong(0L);
                out.writeLong(0L);
            }
        } else {
            throw new EncoderException("unsupported addrType: " + (addrType.byteValue() & 0xFF));
        }
    };

    public void encodeAddress(Socks5AddressType var1, String var2, Buffer var3) throws Exception;
}

