/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v4;

import io.netty.contrib.handler.codec.socksx.SocksVersion;
import io.netty.contrib.handler.codec.socksx.v4.DefaultSocks4CommandRequest;
import io.netty.contrib.handler.codec.socksx.v4.Socks4CommandType;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.codec.DecoderResult;
import io.netty5.util.NetUtil;
import java.nio.charset.StandardCharsets;

public class Socks4ServerDecoder
extends ByteToMessageDecoder {
    private static final int MAX_FIELD_LENGTH = 255;
    private State state = State.START;
    private Socks4CommandType type;
    private String dstAddr;
    private int dstPort;
    private String userId;

    public Socks4ServerDecoder() {
        this.setSingleDecode(true);
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        try {
            switch (this.state) {
                case START: {
                    if (in.readableBytes() < 8) {
                        return;
                    }
                    int version = in.readUnsignedByte();
                    if (version != SocksVersion.SOCKS4a.byteValue()) {
                        throw new DecoderException("unsupported protocol version: " + version);
                    }
                    this.type = Socks4CommandType.valueOf(in.readByte());
                    this.dstPort = in.readUnsignedShort();
                    this.dstAddr = NetUtil.intToIpAddress((int)in.readInt());
                    this.state = State.READ_USERID;
                }
                case READ_USERID: {
                    String id = Socks4ServerDecoder.readString("userid", in);
                    if (id == null) {
                        return;
                    }
                    this.userId = id;
                    this.state = State.READ_DOMAIN;
                }
                case READ_DOMAIN: {
                    if (!"0.0.0.0".equals(this.dstAddr) && this.dstAddr.startsWith("0.0.0.")) {
                        String addr = Socks4ServerDecoder.readString("dstAddr", in);
                        if (addr == null) {
                            return;
                        }
                        this.dstAddr = addr;
                    }
                    ctx.fireChannelRead((Object)new DefaultSocks4CommandRequest(this.type, this.dstAddr, this.dstPort, this.userId));
                    this.state = State.SUCCESS;
                }
                case SUCCESS: {
                    int readableBytes = this.actualReadableBytes();
                    if (readableBytes <= 0) break;
                    ctx.fireChannelRead((Object)in.readSplit(readableBytes));
                    break;
                }
                case FAILURE: {
                    in.skipReadableBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception e) {
            this.fail(ctx, e);
        }
    }

    private void fail(ChannelHandlerContext ctx, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException((Throwable)cause);
        }
        DefaultSocks4CommandRequest m = new DefaultSocks4CommandRequest(this.type != null ? this.type : Socks4CommandType.CONNECT, this.dstAddr != null ? this.dstAddr : "", this.dstPort != 0 ? this.dstPort : 65535, this.userId != null ? this.userId : "");
        m.setDecoderResult(DecoderResult.failure((Throwable)cause));
        ctx.fireChannelRead((Object)m);
        this.state = State.FAILURE;
    }

    private static String readString(String fieldName, Buffer in) {
        int length = in.bytesBefore((byte)0);
        if (length >= 0 && length < 255) {
            if (in.readableBytes() < length + 1) {
                return null;
            }
            String value = in.readCharSequence(length, StandardCharsets.US_ASCII).toString();
            in.skipReadableBytes(1);
            return value;
        }
        if (in.readableBytes() > 256) {
            throw new DecoderException("field '" + fieldName + "' longer than 255 chars");
        }
        return null;
    }

    private static enum State {
        START,
        READ_USERID,
        READ_DOMAIN,
        SUCCESS,
        FAILURE;

    }
}

