/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAddressType;
import io.netty.contrib.handler.codec.socks.SocksCmdType;
import io.netty.contrib.handler.codec.socks.SocksRequest;
import io.netty.contrib.handler.codec.socks.SocksRequestType;
import io.netty5.buffer.Buffer;
import io.netty5.util.NetUtil;
import java.net.IDN;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class SocksCmdRequest
extends SocksRequest {
    private final SocksCmdType cmdType;
    private final SocksAddressType addressType;
    private final String host;
    private final int port;

    public SocksCmdRequest(SocksCmdType cmdType, SocksAddressType addressType, String host, int port) {
        super(SocksRequestType.CMD);
        Objects.requireNonNull(cmdType, "cmdType");
        Objects.requireNonNull(addressType, "addressType");
        Objects.requireNonNull(host, "host");
        switch (addressType) {
            case IPv4: {
                if (NetUtil.isValidIpV4Address((String)host)) break;
                throw new IllegalArgumentException(host + " is not a valid IPv4 address");
            }
            case DOMAIN: {
                String asciiHost = IDN.toASCII(host);
                if (asciiHost.length() > 255) {
                    throw new IllegalArgumentException(host + " IDN: " + asciiHost + " exceeds 255 char limit");
                }
                host = asciiHost;
                break;
            }
            case IPv6: {
                if (NetUtil.isValidIpV6Address((String)host)) break;
                throw new IllegalArgumentException(host + " is not a valid IPv6 address");
            }
        }
        if (port <= 0 || port >= 65536) {
            throw new IllegalArgumentException(port + " is not in bounds 0 < x < 65536");
        }
        this.cmdType = cmdType;
        this.addressType = addressType;
        this.host = host;
        this.port = port;
    }

    public SocksCmdType cmdType() {
        return this.cmdType;
    }

    public SocksAddressType addressType() {
        return this.addressType;
    }

    public String host() {
        return this.addressType == SocksAddressType.DOMAIN ? IDN.toUnicode(this.host) : this.host;
    }

    public int port() {
        return this.port;
    }

    @Override
    public void encodeAsBuffer(Buffer buffer) {
        buffer.writeByte(this.protocolVersion().byteValue());
        buffer.writeByte(this.cmdType.byteValue());
        buffer.writeByte((byte)0);
        buffer.writeByte(this.addressType.byteValue());
        switch (this.addressType) {
            case IPv4: 
            case IPv6: {
                buffer.writeBytes(NetUtil.createByteArrayFromIpAddressString((String)this.host));
                buffer.writeShort((short)this.port);
                break;
            }
            case DOMAIN: {
                buffer.writeByte((byte)this.host.length());
                buffer.writeCharSequence((CharSequence)this.host, StandardCharsets.US_ASCII);
                buffer.writeShort((short)this.port);
            }
        }
    }
}

