/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.AbstractHttpData;
import io.netty.contrib.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.contrib.handler.codec.http.multipart.FileUpload;
import io.netty.contrib.handler.codec.http.multipart.FileUploadUtil;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpData;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.Owned;
import io.netty5.channel.ChannelException;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.util.Send;
import io.netty5.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;

public class MemoryFileUpload
extends AbstractMemoryHttpData
implements FileUpload {
    private String filename;
    private String contentType;
    private String contentTransferEncoding;

    public MemoryFileUpload(String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        super(name, charset, size);
        this.setFilename(filename);
        this.setContentType(contentType);
        this.setContentTransferEncoding(contentTransferEncoding);
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.FileUpload;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = (String)ObjectUtil.checkNotNullWithIAE((Object)filename, (String)"filename");
    }

    public int hashCode() {
        return FileUploadUtil.hashCode(this);
    }

    public boolean equals(Object o) {
        return o instanceof FileUpload && FileUploadUtil.equals(this, (FileUpload)o);
    }

    @Override
    public int compareTo(InterfaceHttpData o) {
        if (!(o instanceof FileUpload)) {
            throw new ClassCastException("Cannot compare " + this.getHttpDataType() + " with " + o.getHttpDataType());
        }
        return this.compareTo((FileUpload)o);
    }

    @Override
    public int compareTo(FileUpload o) {
        return FileUploadUtil.compareTo(this, o);
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = (String)ObjectUtil.checkNotNullWithIAE((Object)contentType, (String)"contentType");
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    public String toString() {
        return HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + this.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + this.filename + "\"\r\n" + HttpHeaderNames.CONTENT_TYPE + ": " + this.contentType + (String)(this.getCharset() != null ? "; " + HttpHeaderValues.CHARSET + "=" + this.getCharset().name() + "\r\n" : "\r\n") + HttpHeaderNames.CONTENT_LENGTH + ": " + this.length() + "\r\nCompleted: " + this.isCompleted() + "\r\nIsInMemory: " + this.isInMemory();
    }

    @Override
    public FileUpload copy() {
        return this.replace(this.byteBuf != null ? this.byteBuf.copy() : this.byteBuf);
    }

    @Override
    public FileUpload replace(Buffer content) {
        this.checkAccessible(content);
        MemoryFileUpload upload = new MemoryFileUpload(this.getName(), this.getFilename(), this.getContentType(), this.getContentTransferEncoding(), this.getCharset(), this.size);
        if (content != null) {
            try {
                upload.setContent(content);
            }
            catch (IOException e) {
                throw new ChannelException((Throwable)e);
            }
        }
        upload.setCompleted(this.isCompleted());
        return upload;
    }

    protected Owned<AbstractHttpData> prepareSend() {
        Send send = this.byteBuf.send();
        return drop -> {
            Buffer received = (Buffer)send.receive();
            MemoryFileUpload upload = new MemoryFileUpload(this.getName(), this.getFilename(), this.getContentType(), this.getContentTransferEncoding(), this.getCharset(), this.size);
            upload.setContentInternal(received, received.readableBytes());
            upload.setCompleted(this.isCompleted());
            upload.definedSize = this.definedLength();
            upload.setMaxSize(this.getMaxSize());
            return upload;
        };
    }
}

