/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.Attribute;
import io.netty.contrib.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.contrib.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.contrib.handler.codec.http.multipart.FileUpload;
import io.netty.contrib.handler.codec.http.multipart.HttpData;
import io.netty.contrib.handler.codec.http.multipart.HttpDataFactory;
import io.netty.contrib.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.contrib.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.ByteCursor;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.http.HttpConstants;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.QueryStringDecoder;
import io.netty5.util.ByteProcessor;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostMultipartRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private Buffer undecodedChunk;
    private int bodyListHttpDataRank;
    private final String multipartDataBoundary;
    private String multipartMixedBoundary;
    private HttpPostRequestDecoder.MultiPartStatus currentStatus = HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED;
    private Map<CharSequence, Attribute> currentFieldAttributes;
    private FileUpload currentFileUpload;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;
    private static final ByteProcessor CTRLSPACE_PROCESSOR = value -> Character.isISOControl(value) || Character.isWhitespace(value);
    private static final String FILENAME_ENCODED = HttpHeaderValues.FILENAME.toString() + "*";

    public HttpPostMultipartRequestDecoder(HttpRequest request) {
        this(new DefaultHttpDataFactory(16384L), request, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory factory, HttpRequest request) {
        this(factory, request, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset) {
        this.request = (HttpRequest)ObjectUtil.checkNotNullWithIAE((Object)request, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNullWithIAE((Object)charset, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNullWithIAE((Object)factory, (String)"factory");
        CharSequence contentTypeValue = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue == null) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException("No '" + HttpHeaderNames.CONTENT_TYPE + "' header present.");
        }
        String[] dataBoundary = HttpPostRequestDecoder.getMultipartDataBoundary(contentTypeValue.toString());
        if (dataBoundary != null) {
            this.multipartDataBoundary = dataBoundary[0];
            if (dataBoundary.length > 1 && dataBoundary[1] != null) {
                try {
                    this.charset = Charset.forName(dataBoundary[1]);
                }
                catch (IllegalCharsetNameException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
            }
        } else {
            this.multipartDataBoundary = null;
        }
        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
        try {
            if (request instanceof HttpContent) {
                this.offer((HttpContent)request);
            } else {
                this.parseBody();
            }
        }
        catch (Throwable e) {
            this.destroy();
            PlatformDependent.throwException((Throwable)e);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostMultipartRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return true;
    }

    @Override
    public void setDiscardThreshold(int discardThreshold) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero((int)discardThreshold, (String)"discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String name) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(name);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String name) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(name);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public HttpPostMultipartRequestDecoder offer(HttpContent<?> content) {
        this.checkDestroyed();
        if (content instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        Buffer buf = content.payload();
        if (this.undecodedChunk == null) {
            BufferAllocator alloc = buf.isDirect() ? DefaultBufferAllocators.offHeapAllocator() : DefaultBufferAllocators.onHeapAllocator();
            this.undecodedChunk = alloc.allocate(buf.readableBytes()).writeBytes(buf);
        } else {
            this.undecodedChunk.writeBytes(buf);
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerOffset() > this.discardThreshold) {
            this.undecodedChunk.compact();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder.EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        if (this.currentFileUpload != null) {
            return this.currentFileUpload;
        }
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyMultipart();
    }

    protected void addHttpData(InterfaceHttpData data) {
        if (data == null) {
            return;
        }
        List<InterfaceHttpData> datas = this.bodyMapHttpData.get(data.getName());
        if (datas == null) {
            datas = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(data.getName(), datas);
        }
        datas.add(data);
        this.bodyListHttpData.add(data);
    }

    private void parseBodyMultipart() {
        if (this.undecodedChunk == null || this.undecodedChunk.readableBytes() == 0) {
            return;
        }
        InterfaceHttpData data = this.decodeMultipart(this.currentStatus);
        while (data != null) {
            this.addHttpData(data);
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) break;
            data = this.decodeMultipart(this.currentStatus);
        }
    }

    private InterfaceHttpData decodeMultipart(HttpPostRequestDecoder.MultiPartStatus state) {
        switch (state) {
            case NOTSTARTED: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case PREAMBLE: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case HEADERDELIMITER: {
                return this.findMultipartDelimiter(this.multipartDataBoundary, HttpPostRequestDecoder.MultiPartStatus.DISPOSITION, HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE);
            }
            case DISPOSITION: {
                return this.findMultipartDisposition();
            }
            case FIELD: {
                Charset localCharset = null;
                Attribute charsetAttribute = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET);
                if (charsetAttribute != null) {
                    try {
                        localCharset = Charset.forName(charsetAttribute.getValue());
                    }
                    catch (IOException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                }
                Attribute nameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
                if (this.currentAttribute == null) {
                    long size;
                    Attribute lengthAttribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
                    try {
                        size = lengthAttribute != null ? Long.parseLong(lengthAttribute.getValue()) : 0L;
                    }
                    catch (IOException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (NumberFormatException ignored) {
                        size = 0L;
                    }
                    try {
                        this.currentAttribute = size > 0L ? this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(nameAttribute.getValue()), size) : this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(nameAttribute.getValue()));
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IOException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    if (localCharset != null) {
                        this.currentAttribute.setCharset(localCharset);
                    }
                }
                if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, this.multipartDataBoundary, this.currentAttribute)) {
                    return null;
                }
                Attribute finalAttribute = this.currentAttribute;
                this.currentAttribute = null;
                this.clearCurrentFieldAttributes();
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                return finalAttribute;
            }
            case FILEUPLOAD: {
                return this.getFileUpload(this.multipartDataBoundary);
            }
            case MIXEDDELIMITER: {
                return this.findMultipartDelimiter(this.multipartMixedBoundary, HttpPostRequestDecoder.MultiPartStatus.MIXEDDISPOSITION, HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            case MIXEDDISPOSITION: {
                return this.findMultipartDisposition();
            }
            case MIXEDFILEUPLOAD: {
                return this.getFileUpload(this.multipartMixedBoundary);
            }
            case PREEPILOGUE: {
                return null;
            }
            case EPILOGUE: {
                return null;
            }
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Shouldn't reach here.");
    }

    private static void skipControlCharacters(Buffer undecodedChunk) {
        try {
            HttpPostMultipartRequestDecoder.skipControlCharactersStandard(undecodedChunk);
        }
        catch (IndexOutOfBoundsException e1) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(e1);
        }
    }

    private static void skipControlCharactersStandard(Buffer undecodedChunk) {
        ByteCursor cursor = undecodedChunk.openCursor();
        int processed = cursor.process(CTRLSPACE_PROCESSOR);
        if (processed > 0) {
            undecodedChunk.readerOffset(undecodedChunk.readerOffset() + processed);
        }
    }

    private InterfaceHttpData findMultipartDelimiter(String delimiter, HttpPostRequestDecoder.MultiPartStatus dispositionStatus, HttpPostRequestDecoder.MultiPartStatus closeDelimiterStatus) {
        String newline;
        int readerIndex = this.undecodedChunk.readerOffset();
        try {
            HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException ignored) {
            this.undecodedChunk.readerOffset(readerIndex);
            return null;
        }
        this.skipOneLine();
        try {
            newline = HttpPostMultipartRequestDecoder.readDelimiterOptimized(this.undecodedChunk, delimiter, this.charset);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException ignored) {
            this.undecodedChunk.readerOffset(readerIndex);
            return null;
        }
        if (newline.equals(delimiter)) {
            this.currentStatus = dispositionStatus;
            return this.decodeMultipart(dispositionStatus);
        }
        if (newline.equals(delimiter + "--")) {
            this.currentStatus = closeDelimiterStatus;
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER) {
                this.clearCurrentFieldAttributes();
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            return null;
        }
        this.undecodedChunk.readerOffset(readerIndex);
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("No Multipart delimiter found");
    }

    private InterfaceHttpData findMultipartDisposition() {
        int readerIndex = this.undecodedChunk.readerOffset();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            this.cleanMixedAttributes();
            this.currentFieldAttributes = new TreeMap<CharSequence, Attribute>(CaseIgnoringComparator.INSTANCE);
        }
        while (!this.skipOneLine()) {
            Attribute attribute;
            Object values;
            String newline;
            try {
                HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
                newline = HttpPostMultipartRequestDecoder.readLineOptimized(this.undecodedChunk, this.charset);
            }
            catch (HttpPostRequestDecoder.NotEnoughDataDecoderException ignored) {
                this.undecodedChunk.readerOffset(readerIndex);
                return null;
            }
            String[] contents = HttpPostMultipartRequestDecoder.splitMultipartHeader(newline);
            if (HttpHeaderNames.CONTENT_DISPOSITION.contentEqualsIgnoreCase((CharSequence)contents[0])) {
                boolean checkSecondArg;
                if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
                    checkSecondArg = HttpHeaderValues.FORM_DATA.contentEqualsIgnoreCase((CharSequence)contents[1]);
                } else {
                    boolean bl = checkSecondArg = HttpHeaderValues.ATTACHMENT.contentEqualsIgnoreCase((CharSequence)contents[1]) || HttpHeaderValues.FILE.contentEqualsIgnoreCase((CharSequence)contents[1]);
                }
                if (!checkSecondArg) continue;
                for (int i = 2; i < contents.length; ++i) {
                    values = contents[i].split("=", 2);
                    try {
                        attribute = this.getContentDispositionAttribute((String)values);
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    this.putCurrentFieldAttribute(attribute.getName(), attribute);
                }
                continue;
            }
            if (HttpHeaderNames.CONTENT_TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)contents[0])) {
                Attribute attribute2;
                try {
                    attribute2 = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_TRANSFER_ENCODING.toString(), HttpPostMultipartRequestDecoder.cleanString(contents[1]));
                }
                catch (NullPointerException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                this.putCurrentFieldAttribute((CharSequence)HttpHeaderNames.CONTENT_TRANSFER_ENCODING, attribute2);
                continue;
            }
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)contents[0])) {
                Attribute attribute3;
                try {
                    attribute3 = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_LENGTH.toString(), HttpPostMultipartRequestDecoder.cleanString(contents[1]));
                }
                catch (NullPointerException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                this.putCurrentFieldAttribute((CharSequence)HttpHeaderNames.CONTENT_LENGTH, attribute3);
                continue;
            }
            if (!HttpHeaderNames.CONTENT_TYPE.contentEqualsIgnoreCase((CharSequence)contents[0])) continue;
            if (HttpHeaderValues.MULTIPART_MIXED.contentEqualsIgnoreCase((CharSequence)contents[1])) {
                if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
                    String values2 = StringUtil.substringAfter((String)contents[2], (char)'=');
                    this.multipartMixedBoundary = "--" + values2;
                    this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                    return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER);
                }
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Mixed Multipart found in a previous Mixed Multipart");
            }
            for (int i = 1; i < contents.length; ++i) {
                Attribute attribute4;
                String charsetHeader = HttpHeaderValues.CHARSET.toString();
                if (contents[i].regionMatches(true, 0, charsetHeader, 0, charsetHeader.length())) {
                    values = StringUtil.substringAfter((String)contents[i], (char)'=');
                    try {
                        attribute = this.factory.createAttribute(this.request, charsetHeader, HttpPostMultipartRequestDecoder.cleanString((String)values));
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    this.putCurrentFieldAttribute((CharSequence)HttpHeaderValues.CHARSET, attribute);
                    continue;
                }
                if (contents[i].contains("=")) {
                    Attribute attribute5;
                    String name = StringUtil.substringBefore((String)contents[i], (char)'=');
                    String values3 = StringUtil.substringAfter((String)contents[i], (char)'=');
                    try {
                        attribute5 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(name), values3);
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    this.putCurrentFieldAttribute(name, attribute5);
                    continue;
                }
                try {
                    attribute4 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(contents[0]), contents[i]);
                }
                catch (NullPointerException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                this.putCurrentFieldAttribute(attribute4.getName(), attribute4);
            }
        }
        Attribute filenameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            if (filenameAttribute != null) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD;
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD);
            }
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FIELD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FIELD);
        }
        if (filenameAttribute != null) {
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD);
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Filename not found");
    }

    private void putCurrentFieldAttribute(CharSequence name, Attribute attribute) {
        this.currentFieldAttributes.compute(attribute.getName(), (key, old) -> {
            if (old != null) {
                old.close();
            }
            return attribute;
        });
    }

    private Attribute getContentDispositionAttribute(String ... values) {
        String name = HttpPostMultipartRequestDecoder.cleanString(values[0]);
        String value = values[1];
        if (HttpHeaderValues.FILENAME.contentEquals((CharSequence)name)) {
            int last = value.length() - 1;
            if (last > 0 && value.charAt(0) == '\"' && value.charAt(last) == '\"') {
                value = value.substring(1, last);
            }
        } else if (FILENAME_ENCODED.equals(name)) {
            try {
                name = HttpHeaderValues.FILENAME.toString();
                String[] split = HttpPostMultipartRequestDecoder.cleanString(value).split("'", 3);
                value = QueryStringDecoder.decodeComponent((String)split[2], (Charset)Charset.forName(split[0]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (UnsupportedCharsetException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
        } else {
            value = HttpPostMultipartRequestDecoder.cleanString(value);
        }
        return this.factory.createAttribute(this.request, name, value);
    }

    protected InterfaceHttpData getFileUpload(String delimiter) {
        Attribute charsetAttribute;
        Attribute encoding = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        Charset localCharset = this.charset;
        HttpPostBodyUtil.TransferEncodingMechanism mechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT7;
        if (encoding != null) {
            String code;
            try {
                code = encoding.getValue().toLowerCase();
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            if (code.equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT7.value())) {
                localCharset = StandardCharsets.US_ASCII;
            } else if (code.equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT8.value())) {
                localCharset = StandardCharsets.ISO_8859_1;
                mechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT8;
            } else if (code.equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value())) {
                mechanism = HttpPostBodyUtil.TransferEncodingMechanism.BINARY;
            } else {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("TransferEncoding Unknown: " + code);
            }
        }
        if ((charsetAttribute = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET)) != null) {
            try {
                localCharset = Charset.forName(charsetAttribute.getValue());
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (UnsupportedCharsetException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
        }
        if (this.currentFileUpload == null) {
            long size;
            Attribute filenameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
            Attribute nameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
            Attribute contentTypeAttribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TYPE);
            Attribute lengthAttribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
            try {
                size = lengthAttribute != null ? Long.parseLong(lengthAttribute.getValue()) : 0L;
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (NumberFormatException ignored) {
                size = 0L;
            }
            try {
                String contentType = contentTypeAttribute != null ? contentTypeAttribute.getValue() : "application/octet-stream";
                this.currentFileUpload = this.factory.createFileUpload(this.request, HttpPostMultipartRequestDecoder.cleanString(nameAttribute.getValue()), HttpPostMultipartRequestDecoder.cleanString(filenameAttribute.getValue()), contentType, mechanism.value(), localCharset, size);
            }
            catch (NullPointerException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (IllegalArgumentException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
        }
        if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, delimiter, this.currentFileUpload)) {
            return null;
        }
        if (this.currentFileUpload.isCompleted()) {
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                this.clearCurrentFieldAttributes();
            } else {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                this.cleanMixedAttributes();
            }
            FileUpload fileUpload = this.currentFileUpload;
            this.currentFileUpload = null;
            return fileUpload;
        }
        return null;
    }

    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData httpData : this.bodyListHttpData) {
            if (!httpData.isAccessible()) continue;
            httpData.close();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null) {
            if (this.undecodedChunk.isAccessible()) {
                this.undecodedChunk.close();
            }
            this.undecodedChunk = null;
        }
        this.clearCurrentFieldAttributes();
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData data) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, data);
    }

    private void cleanMixedAttributes() {
        if (this.currentFieldAttributes != null) {
            try (Attribute charset = this.currentFieldAttributes.remove(HttpHeaderValues.CHARSET);
                 Attribute clen = this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_LENGTH);
                 Attribute transferEncoding = this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
                 Attribute ctype = this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TYPE);){
                Attribute fname = this.currentFieldAttributes.remove(HttpHeaderValues.FILENAME);
                if (fname != null) {
                    fname.close();
                }
            }
        }
    }

    private void clearCurrentFieldAttributes() {
        if (this.currentFieldAttributes != null) {
            this.currentFieldAttributes.forEach((charSequence, attribute) -> {
                if (attribute.isAccessible()) {
                    attribute.close();
                }
            });
            this.currentFieldAttributes = null;
        }
    }

    private static String readLineOptimized(Buffer undecodedChunk, Charset charset) {
        int readerIndex = undecodedChunk.readerOffset();
        try {
            if (undecodedChunk.readableBytes() > 0) {
                int posLfOrCrLf = HttpPostBodyUtil.findLineBreak(undecodedChunk, undecodedChunk.readerOffset());
                if (posLfOrCrLf <= 0) {
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                }
                CharSequence lineCharSeq = undecodedChunk.readCharSequence(posLfOrCrLf, charset);
                byte nextByte = undecodedChunk.readByte();
                if (nextByte == 13) {
                    undecodedChunk.readByte();
                }
                return lineCharSeq.toString();
            }
        }
        catch (IndexOutOfBoundsException e) {
            undecodedChunk.readerOffset(readerIndex);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(e);
        }
        undecodedChunk.readerOffset(readerIndex);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private static String readDelimiterOptimized(Buffer undecodedChunk, String delimiter, Charset charset) {
        int readerIndex = undecodedChunk.readerOffset();
        byte[] bdelimiter = delimiter.getBytes(charset);
        int delimiterLength = bdelimiter.length;
        try {
            int delimiterPos = HttpPostBodyUtil.findDelimiter(undecodedChunk, readerIndex, bdelimiter, false);
            if (delimiterPos < 0) {
                undecodedChunk.readerOffset(readerIndex);
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            StringBuilder sb = new StringBuilder(delimiter);
            undecodedChunk.readerOffset(readerIndex + delimiterPos + delimiterLength);
            if (undecodedChunk.readableBytes() > 0) {
                byte nextByte = undecodedChunk.readByte();
                if (nextByte == 13) {
                    nextByte = undecodedChunk.readByte();
                    if (nextByte == 10) {
                        return sb.toString();
                    }
                    undecodedChunk.readerOffset(readerIndex);
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                }
                if (nextByte == 10) {
                    return sb.toString();
                }
                if (nextByte == 45) {
                    sb.append('-');
                    nextByte = undecodedChunk.readByte();
                    if (nextByte == 45) {
                        sb.append('-');
                        if (undecodedChunk.readableBytes() > 0) {
                            nextByte = undecodedChunk.readByte();
                            if (nextByte == 13) {
                                nextByte = undecodedChunk.readByte();
                                if (nextByte == 10) {
                                    return sb.toString();
                                }
                                undecodedChunk.readerOffset(readerIndex);
                                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                            }
                            if (nextByte == 10) {
                                return sb.toString();
                            }
                            undecodedChunk.readerOffset(undecodedChunk.readerOffset() - 1);
                            return sb.toString();
                        }
                        return sb.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            undecodedChunk.readerOffset(readerIndex);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(e);
        }
        undecodedChunk.readerOffset(readerIndex);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    private static void rewriteCurrentBuffer(Buffer buffer, int lengthToSkip) {
        if (lengthToSkip == 0) {
            return;
        }
        int readerIndex = buffer.readerOffset();
        int readableBytes = buffer.readableBytes();
        if (readableBytes == lengthToSkip) {
            buffer.readerOffset(readerIndex);
            buffer.writerOffset(readerIndex);
            return;
        }
        buffer.copyInto(readerIndex + lengthToSkip, buffer, readerIndex, readableBytes - lengthToSkip);
        buffer.readerOffset(readerIndex);
        buffer.writerOffset(readerIndex + readableBytes - lengthToSkip);
    }

    private static boolean loadDataMultipartOptimized(Buffer undecodedChunk, String delimiter, HttpData httpData) {
        byte[] bdelimiter;
        if (undecodedChunk.readableBytes() == 0) {
            return false;
        }
        int startReaderIndex = undecodedChunk.readerOffset();
        int posDelimiter = HttpPostBodyUtil.findDelimiter(undecodedChunk, startReaderIndex, bdelimiter = delimiter.getBytes(httpData.getCharset()), true);
        if (posDelimiter < 0) {
            int readableBytes = undecodedChunk.readableBytes();
            int lastPosition = readableBytes - bdelimiter.length - 1;
            if (lastPosition < 0) {
                lastPosition = 0;
            }
            if ((posDelimiter = HttpPostBodyUtil.findLastLineBreak(undecodedChunk, startReaderIndex + lastPosition)) < 0 && httpData.definedLength() == httpData.length() + (long)readableBytes - 1L && undecodedChunk.getByte(readableBytes + startReaderIndex - 1) == 13) {
                lastPosition = 0;
                posDelimiter = readableBytes - 1;
            }
            if (posDelimiter < 0) {
                Buffer content = undecodedChunk.copy();
                try {
                    httpData.addContent(content, false);
                }
                catch (IOException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                undecodedChunk.readerOffset(startReaderIndex);
                undecodedChunk.writerOffset(startReaderIndex);
                return false;
            }
            if ((posDelimiter += lastPosition) == 0) {
                return false;
            }
            Buffer content = undecodedChunk.copy(startReaderIndex, posDelimiter);
            try {
                httpData.addContent(content, false);
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(undecodedChunk, posDelimiter);
            return false;
        }
        Buffer content = undecodedChunk.copy(startReaderIndex, posDelimiter);
        try {
            httpData.addContent(content, true);
        }
        catch (IOException e) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
        }
        HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(undecodedChunk, posDelimiter);
        return true;
    }

    private static String cleanString(String field) {
        int size = field.length();
        StringBuilder sb = new StringBuilder(size);
        block4: for (int i = 0; i < size; ++i) {
            char nextChar = field.charAt(i);
            switch (nextChar) {
                case '\t': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    sb.append(' ');
                    continue block4;
                }
                case '\"': {
                    continue block4;
                }
                default: {
                    sb.append(nextChar);
                }
            }
        }
        return sb.toString().trim();
    }

    private boolean skipOneLine() {
        if (this.undecodedChunk.readableBytes() == 0) {
            return false;
        }
        byte nextByte = this.undecodedChunk.readByte();
        if (nextByte == 13) {
            if (this.undecodedChunk.readableBytes() == 0) {
                this.undecodedChunk.readerOffset(this.undecodedChunk.readerOffset() - 1);
                return false;
            }
            nextByte = this.undecodedChunk.readByte();
            if (nextByte == 10) {
                return true;
            }
            this.undecodedChunk.readerOffset(this.undecodedChunk.readerOffset() - 2);
            return false;
        }
        if (nextByte == 10) {
            return true;
        }
        this.undecodedChunk.readerOffset(this.undecodedChunk.readerOffset() - 1);
        return false;
    }

    private static String[] splitMultipartHeader(String sb) {
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        ArrayList<String> headers = new ArrayList<String>(1);
        for (nameEnd = nameStart = HttpPostBodyUtil.findNonWhitespace(sb, 0); nameEnd < sb.length() && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < sb.length(); ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        int valueStart = HttpPostBodyUtil.findNonWhitespace(sb, colonEnd);
        int valueEnd = HttpPostBodyUtil.findEndOfString(sb);
        headers.add(sb.substring(nameStart, nameEnd));
        String svalue = valueStart >= valueEnd ? "" : sb.substring(valueStart, valueEnd);
        String[] values = svalue.indexOf(59) >= 0 ? HttpPostMultipartRequestDecoder.splitMultipartHeaderValues(svalue) : svalue.split(",");
        for (String value : values) {
            headers.add(value.trim());
        }
        String[] array = new String[headers.size()];
        for (int i = 0; i < headers.size(); ++i) {
            array[i] = (String)headers.get(i);
        }
        return array;
    }

    private static String[] splitMultipartHeaderValues(String svalue) {
        ArrayList<String> values = new ArrayList<String>(1);
        boolean inQuote = false;
        boolean escapeNext = false;
        int start = 0;
        for (int i = 0; i < svalue.length(); ++i) {
            char c = svalue.charAt(i);
            if (inQuote) {
                if (escapeNext) {
                    escapeNext = false;
                    continue;
                }
                if (c == '\\') {
                    escapeNext = true;
                    continue;
                }
                if (c != '\"') continue;
                inQuote = false;
                continue;
            }
            if (c == '\"') {
                inQuote = true;
                continue;
            }
            if (c != ';') continue;
            values.add(svalue.substring(start, i));
            start = i + 1;
        }
        values.add(svalue.substring(start));
        return values.toArray(new String[0]);
    }

    int getCurrentAllocatedCapacity() {
        return this.undecodedChunk.capacity();
    }
}

