/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.contrib.handler.codec.http.multipart.Helpers;
import io.netty.contrib.handler.codec.http.multipart.HttpData;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpData;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.Drop;
import io.netty5.buffer.internal.ResourceSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

abstract class AbstractMixedHttpData<D extends HttpData>
extends ResourceSupport<HttpData, AbstractMixedHttpData<? extends HttpData>>
implements HttpData {
    final String baseDir;
    final boolean deleteOnExit;
    D wrapped;
    protected final long limitSize;
    private static final Drop<AbstractMixedHttpData<? extends HttpData>> drop = new Drop<AbstractMixedHttpData<? extends HttpData>>(){

        public void drop(AbstractMixedHttpData<? extends HttpData> data) {
            data.delete();
        }

        public Drop<AbstractMixedHttpData<? extends HttpData>> fork() {
            return this;
        }

        public void attach(AbstractMixedHttpData<? extends HttpData> mixedFileUpload) {
        }
    };

    AbstractMixedHttpData(long limitSize, String baseDir, boolean deleteOnExit, D initial) {
        super(drop);
        this.limitSize = limitSize;
        this.wrapped = initial;
        this.baseDir = baseDir;
        this.deleteOnExit = deleteOnExit;
    }

    abstract D makeDiskData();

    @Override
    public long getMaxSize() {
        return this.wrapped.getMaxSize();
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.checkAccessible();
        this.wrapped.setMaxSize(maxSize);
    }

    @Override
    public <E extends Exception> void usingContent(Helpers.ThrowingConsumer<Buffer, E> callback) throws E {
        this.wrapped.usingContent(callback);
    }

    @Override
    public void checkSize(long newSize) throws IOException {
        this.checkAccessible();
        this.wrapped.checkSize(newSize);
    }

    @Override
    public long definedLength() {
        return this.wrapped.definedLength();
    }

    @Override
    public Charset getCharset() {
        return this.wrapped.getCharset();
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public void addContent(Buffer buffer, boolean last) throws IOException {
        this.checkAccessible(buffer);
        if (this.wrapped instanceof AbstractMemoryHttpData) {
            try {
                this.checkSize(this.wrapped.length() + (long)buffer.readableBytes());
                if (this.wrapped.length() + (long)buffer.readableBytes() > this.limitSize) {
                    Object diskData = this.makeDiskData();
                    ((AbstractMemoryHttpData)this.wrapped).usingBuffer(data -> {
                        if (data != null && data.readableBytes() > 0) {
                            diskData.addContent((Buffer)data, false);
                        }
                    });
                    this.wrapped.close();
                    this.wrapped = diskData;
                }
            }
            catch (IOException e) {
                buffer.close();
                throw e;
            }
        }
        this.wrapped.addContent(buffer, last);
    }

    @Override
    public void delete() {
        this.wrapped.delete();
    }

    @Override
    public byte[] get() throws IOException {
        return this.wrapped.get();
    }

    @Override
    public <E extends Exception> void usingBuffer(Helpers.ThrowingConsumer<Buffer, E> callback) throws IOException, E {
        this.wrapped.usingBuffer(callback);
    }

    @Override
    public String getString() throws IOException {
        return this.wrapped.getString();
    }

    @Override
    public String getString(Charset encoding) throws IOException {
        return this.wrapped.getString(encoding);
    }

    @Override
    public boolean isInMemory() {
        return this.wrapped.isInMemory();
    }

    @Override
    public long length() {
        return this.wrapped.length();
    }

    @Override
    public boolean renameTo(File dest) throws IOException {
        return this.wrapped.renameTo(dest);
    }

    @Override
    public void setCharset(Charset charset) {
        this.wrapped.setCharset(charset);
    }

    @Override
    public void setContent(Buffer buffer) throws IOException {
        this.checkAccessible(buffer);
        try {
            this.checkSize(buffer.readableBytes());
        }
        catch (IOException e) {
            buffer.close();
            throw e;
        }
        if ((long)buffer.readableBytes() > this.limitSize && this.wrapped instanceof AbstractMemoryHttpData) {
            D oldWrapped;
            try (D d = oldWrapped = this.wrapped;){
                this.wrapped = this.makeDiskData();
            }
        }
        this.wrapped.setContent(buffer);
    }

    @Override
    public void setContent(File file) throws IOException {
        this.checkAccessible();
        this.checkSize(file.length());
        if (file.length() > this.limitSize && this.wrapped instanceof AbstractMemoryHttpData) {
            D oldWrapped;
            try (D d = oldWrapped = this.wrapped;){
                this.wrapped = this.makeDiskData();
            }
        }
        this.wrapped.setContent(file);
    }

    @Override
    public void setContent(InputStream inputStream) throws IOException {
        this.checkAccessible();
        if (this.wrapped instanceof AbstractMemoryHttpData) {
            D oldWrapped;
            try (D d = oldWrapped = this.wrapped;){
                this.wrapped = this.makeDiskData();
            }
        }
        this.wrapped.setContent(inputStream);
    }

    @Override
    public boolean isCompleted() {
        return this.wrapped.isCompleted();
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return this.wrapped.getHttpDataType();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    @Override
    public int compareTo(InterfaceHttpData o) {
        return this.wrapped.compareTo((InterfaceHttpData)o);
    }

    public String toString() {
        return "Mixed: " + this.wrapped;
    }

    @Override
    public Buffer getChunk(int length) throws IOException {
        return this.wrapped.getChunk(length);
    }

    @Override
    public File getFile() throws IOException {
        return this.wrapped.getFile();
    }

    public D copy() {
        return (D)this.wrapped.copy();
    }

    public D replace(Buffer content) {
        return (D)this.wrapped.replace(content);
    }

    protected RuntimeException createResourceClosedException() {
        return new IllegalStateException("Resource is closed");
    }

    protected void checkAccessible() {
        if (!this.isAccessible()) {
            throw this.createResourceClosedException();
        }
    }

    protected void checkAccessible(Buffer cleanup) {
        if (!this.isAccessible()) {
            if (cleanup != null && cleanup.isAccessible()) {
                cleanup.close();
            }
            throw this.createResourceClosedException();
        }
    }
}

