/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.AbstractHttpData;
import io.netty.contrib.handler.codec.http.multipart.Helpers;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.buffer.internal.InternalBufferUtils;
import io.netty5.handler.codec.http.HttpConstants;
import io.netty5.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    protected Buffer byteBuf = DefaultBufferAllocators.preferredAllocator().allocate(0);

    protected AbstractMemoryHttpData(String name, Charset charset, long size) {
        super(name, charset, size);
    }

    @Override
    public void setContent(Buffer buffer) throws IOException {
        this.checkAccessible(buffer);
        ObjectUtil.checkNotNullWithIAE((Object)buffer, (String)"buffer");
        long localsize = buffer.readableBytes();
        try {
            this.checkSize(localsize);
        }
        catch (IOException e) {
            buffer.close();
            throw e;
        }
        if (this.definedSize > 0L && this.definedSize < localsize) {
            buffer.close();
            throw new IOException("Out of size: " + localsize + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.close();
        }
        this.setContentInternal(buffer, localsize);
    }

    protected final void setContentInternal(Buffer buffer, long size) {
        if (this.byteBuf != null && this.byteBuf.isAccessible()) {
            this.byteBuf.close();
        }
        this.byteBuf = buffer;
        this.size = size;
        this.setCompleted();
    }

    @Override
    public void setContent(InputStream inputStream) throws IOException {
        this.checkAccessible();
        ObjectUtil.checkNotNullWithIAE((Object)inputStream, (String)"inputStream");
        byte[] bytes = new byte[16384];
        Buffer buffer = DefaultBufferAllocators.preferredAllocator().allocate(0);
        int written = 0;
        try {
            int read;
            while ((read = inputStream.read(bytes)) > 0) {
                buffer.writeBytes(bytes, 0, read);
                this.checkSize(written += read);
            }
        }
        catch (IOException e) {
            buffer.close();
            throw e;
        }
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            buffer.close();
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.close();
        }
        this.byteBuf = buffer;
        this.setCompleted();
    }

    @Override
    public void addContent(Buffer buffer, boolean last) throws IOException {
        this.checkAccessible(buffer);
        if (buffer != null) {
            long localsize = buffer.readableBytes();
            try {
                this.checkSize(this.size + localsize);
            }
            catch (IOException e) {
                buffer.close();
                throw e;
            }
            if (this.definedSize > 0L && this.definedSize < this.size + localsize) {
                buffer.close();
                throw new IOException("Out of size: " + (this.size + localsize) + " > " + this.definedSize);
            }
            this.size += localsize;
            if (this.byteBuf == null) {
                this.byteBuf = buffer;
            } else if (localsize == 0L) {
                buffer.close();
            } else if (this.byteBuf.readableBytes() == 0) {
                this.byteBuf.close();
                this.byteBuf = buffer;
            } else if (CompositeBuffer.isComposite((Buffer)this.byteBuf)) {
                CompositeBuffer cbb = (CompositeBuffer)this.byteBuf;
                cbb.extendWith(buffer.send());
            } else {
                this.byteBuf = DefaultBufferAllocators.onHeapAllocator().compose(Arrays.asList(this.byteBuf.send(), buffer.send()));
            }
        }
        if (last) {
            this.setCompleted();
        } else {
            ObjectUtil.checkNotNullWithIAE((Object)buffer, (String)"buffer");
        }
    }

    @Override
    public void setContent(File file) throws IOException {
        this.checkAccessible();
        ObjectUtil.checkNotNullWithIAE((Object)file, (String)"file");
        long newsize = file.length();
        if (newsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        this.checkSize(newsize);
        Buffer buf = DefaultBufferAllocators.onHeapAllocator().allocate((int)newsize);
        try (RandomAccessFile accessFile = new RandomAccessFile(file, "r");
             FileChannel fileChannel = accessFile.getChannel();){
            int bytes;
            int bytesRead = 0;
            int remaining = (int)newsize;
            do {
                buf.ensureWritable(remaining);
                bytes = buf.transferFrom((ReadableByteChannel)fileChannel, remaining);
                if (bytes == -1) {
                    break;
                }
                remaining -= bytes;
            } while ((long)(bytesRead += bytes) < newsize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.close();
        }
        this.byteBuf = buf;
        this.size = newsize;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.byteBuf != null) {
            if (this.byteBuf.isAccessible()) {
                this.byteBuf.close();
            }
            this.byteBuf = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.byteBuf == null) {
            return EMPTY_ARRAY;
        }
        byte[] array = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.copyInto(this.byteBuf.readerOffset(), array, 0, this.byteBuf.readableBytes());
        return array;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset encoding) {
        if (this.byteBuf == null) {
            return "";
        }
        if (encoding == null) {
            encoding = HttpConstants.DEFAULT_CHARSET;
        }
        return this.byteBuf.toString(encoding);
    }

    @Override
    public <E extends Exception> void usingBuffer(Helpers.ThrowingConsumer<Buffer, E> callback) throws IOException, E {
        callback.accept(this.byteBuf);
    }

    @Override
    public Buffer getChunk(int length) {
        int readableBytes = this.byteBuf.readableBytes();
        if (this.byteBuf == null || length == 0 || readableBytes == 0) {
            return DefaultBufferAllocators.preferredAllocator().allocate(0);
        }
        return this.byteBuf.readSplit(Math.min(readableBytes, length));
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public boolean renameTo(File dest) throws IOException {
        ObjectUtil.checkNotNullWithIAE((Object)dest, (String)"dest");
        if (this.byteBuf == null) {
            if (!dest.createNewFile()) {
                throw new IOException("file exists already: " + dest);
            }
            return true;
        }
        int length = this.byteBuf.readableBytes();
        try (RandomAccessFile accessFile = new RandomAccessFile(dest, "rw");
             FileChannel fileChannel = accessFile.getChannel();){
            int written;
            while ((written = this.byteBuf.transferTo((WritableByteChannel)fileChannel, length)) != -1 && (length -= written) > 0) {
            }
            fileChannel.force(false);
        }
        return length == 0;
    }

    @Override
    public File getFile() throws IOException {
        throw new IOException("Not represented by a file");
    }

    @Override
    protected RuntimeException createResourceClosedException() {
        return InternalBufferUtils.bufferIsClosed((Buffer)this.byteBuf);
    }
}

