/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.websub.api.filter;

import io.mosip.kernel.websub.api.constants.WebSubClientErrorCode;
import io.mosip.kernel.websub.api.exception.WebSubClientException;
import io.mosip.kernel.websub.api.verifier.IntentVerifier;
import io.swagger.models.HttpMethod;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class IntentVerificationFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntentVerificationFilter.class);
    private IntentVerifier intentVerifier;
    private Map<String, String> mappings = null;

    public IntentVerificationFilter(IntentVerifier intentVerifier) {
        this.intentVerifier = intentVerifier;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String topic = this.matchCallbackURL(request.getRequestURI());
        if (request.getMethod().equals(HttpMethod.GET.name()) && topic != null) {
            String topicReq = request.getParameter("hub.topic");
            String modeReq = request.getParameter("hub.mode");
            String mode = request.getParameter("intentMode");
            if (modeReq.equals("denied")) {
                String reason = request.getParameter("hub.reason");
                reason = reason.replaceAll("[\n\r\t]", " - ");
                LOGGER.error("intent verification failed : {}", (Object)reason);
                response.setStatus(404);
                response.getWriter().flush();
                response.getWriter().close();
            }
            if (this.intentVerifier.isIntentVerified(topic, mode, topicReq, modeReq)) {
                response.setStatus(202);
                try {
                    String challange = request.getParameter("hub.challenge");
                    String encodedChallange = Encode.forHtml((String)challange);
                    response.getWriter().write(encodedChallange);
                    response.getWriter().flush();
                    response.getWriter().close();
                }
                catch (IOException exception) {
                    LOGGER.error("error received while writing challange back" + exception.getMessage());
                    throw new WebSubClientException(WebSubClientErrorCode.IO_ERROR.getErrorCode(), WebSubClientErrorCode.IO_ERROR.getErrorMessage().concat(exception.getMessage()));
                }
            } else {
                topicReq = topicReq.replaceAll("[\n\r\t]", " - ");
                modeReq = modeReq.replaceAll("[\n\r\t]", " - ");
                mode = mode.replaceAll("[\n\r\t]", " - ");
                LOGGER.error("intent verification failed: {} {} {} {}", new Object[]{topic, mode, topicReq, modeReq});
                response.setStatus(404);
                response.getWriter().flush();
                response.getWriter().close();
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String matchCallbackURL(String requestURI) {
        if (this.mappings.containsKey(requestURI)) {
            return this.mappings.get(requestURI);
        }
        Set<String> mappingKeys = this.mappings.keySet();
        for (String keys : mappingKeys) {
            String url;
            int pathParamIndex = keys.indexOf("/{");
            if (pathParamIndex == -1 || !requestURI.contains(url = keys.substring(0, pathParamIndex))) continue;
            int pathParamCount = keys.split("\\/\\{").length - 1;
            if (requestURI.substring(pathParamIndex).split("\\/").length - 1 != pathParamCount) continue;
            return this.mappings.get(keys);
        }
        return null;
    }

    @Generated
    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }
}

