/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.websub.api.config;

import io.mosip.kernel.websub.api.annotation.PreAuthenticateContentAndVerifyIntent;
import io.mosip.kernel.websub.api.filter.IntentVerificationFilter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringValueResolver;

@Component
public class IntentVerificationConfig
implements ApplicationContextAware,
EmbeddedValueResolverAware {
    private Map<String, String> mappings = null;
    private StringValueResolver resolver = null;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mappings = new HashMap<String, String>();
        for (String beanName : applicationContext.getBeanDefinitionNames()) {
            if (((ConfigurableApplicationContext)applicationContext).getBeanFactory().getBeanDefinition(beanName).isLazyInit()) continue;
            Object obj = applicationContext.getBean(beanName);
            Class objClazz = obj.getClass();
            if (AopUtils.isAopProxy((Object)obj)) {
                objClazz = AopUtils.getTargetClass((Object)obj);
            }
            for (Method method : objClazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PreAuthenticateContentAndVerifyIntent.class)) continue;
                PreAuthenticateContentAndVerifyIntent preAuthenticateContent = method.getAnnotation(PreAuthenticateContentAndVerifyIntent.class);
                String topic = preAuthenticateContent.topic();
                String callback = preAuthenticateContent.callback();
                if (topic.startsWith("${") && topic.endsWith("}")) {
                    topic = this.resolver.resolveStringValue(topic);
                }
                if (callback.startsWith("${") && callback.endsWith("}")) {
                    callback = this.resolver.resolveStringValue(callback);
                }
                this.mappings.put(callback, topic);
            }
            IntentVerificationFilter intentVerificationFilter = (IntentVerificationFilter)((Object)applicationContext.getBean(IntentVerificationFilter.class));
            intentVerificationFilter.setMappings(this.mappings);
        }
    }
}

