/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.websub.api.aspects;

import io.mosip.kernel.websub.api.annotation.PreAuthenticateContentAndVerifyIntent;
import io.mosip.kernel.websub.api.constants.WebSubClientErrorCode;
import io.mosip.kernel.websub.api.exception.WebSubClientException;
import io.mosip.kernel.websub.api.verifier.AuthenticatedContentVerifier;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringValueResolver;

@Aspect
public class WebSubClientAspect
implements EmbeddedValueResolverAware {
    private StringValueResolver resolver = null;
    @Autowired
    private AuthenticatedContentVerifier authenticatedContentVerifier;
    @Autowired(required=true)
    private HttpServletRequest request;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    @Before(value="@annotation(preAuthenticateContent)")
    public void preAuthenticateContent(PreAuthenticateContentAndVerifyIntent preAuthenticateContent) {
        if (!(this.request instanceof HttpServletRequest)) {
            throw new WebSubClientException(WebSubClientErrorCode.INSTANCE_ERROR.getErrorCode(), WebSubClientErrorCode.INSTANCE_ERROR.getErrorMessage());
        }
        String secret = null;
        secret = preAuthenticateContent.secret().startsWith("${") && preAuthenticateContent.secret().endsWith("}") ? this.resolver.resolveStringValue(preAuthenticateContent.secret()) : preAuthenticateContent.secret();
        if (!secret.trim().isEmpty()) {
            if (!this.authenticatedContentVerifier.verifyAuthorizedContentVerified(this.request, secret)) {
                throw new WebSubClientException(WebSubClientErrorCode.AUTHENTTICATED_CONTENT_ERROR.getErrorCode(), WebSubClientErrorCode.AUTHENTTICATED_CONTENT_ERROR.getErrorMessage());
            }
        } else {
            throw new WebSubClientException(WebSubClientErrorCode.AUTHENTTICATED_CONTENT_ANNOTATION_SECRET_ERROR.getErrorCode(), WebSubClientErrorCode.AUTHENTTICATED_CONTENT_ANNOTATION_SECRET_ERROR.getErrorMessage());
        }
    }
}

