/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.util.DateUtils;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenHandlerUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(TokenHandlerUtil.class);
    public static ConcurrentMap<String, DecodedJWT> decodedTokens = new ConcurrentHashMap<String, DecodedJWT>();

    private TokenHandlerUtil() {
    }

    public static boolean isValidBearerToken(String accessToken, String issuerUrl, String clientId) {
        try {
            DecodedJWT decodedJWT = (DecodedJWT)decodedTokens.get(accessToken);
            if (decodedJWT == null) {
                decodedJWT = JWT.decode((String)accessToken);
                decodedTokens.put(accessToken, decodedJWT);
            }
            Map claims = decodedJWT.getClaims();
            LocalDateTime expiryTime = DateUtils.convertUTCToLocalDateTime(DateUtils.getUTCTimeFromDate(decodedJWT.getExpiresAt()));
            if (!decodedJWT.getIssuer().equals(issuerUrl)) {
                return false;
            }
            if (!DateUtils.before(DateUtils.getUTCCurrentDateTime(), expiryTime)) {
                return false;
            }
            return ((Claim)claims.get("clientId")).asString().equals(clientId);
        }
        catch (JWTDecodeException e) {
            LOGGER.error("JWT DECODE EXCEPTION ::".concat(e.getMessage()).concat(ExceptionUtils.getStackTrace(e)));
            return false;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage().concat(ExceptionUtils.getStackTrace(e)));
            return false;
        }
    }
}

