/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.util;

import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.core.util.HMACUtils;
import java.util.Arrays;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;

public class CryptoUtil {
    private static Base64.Encoder urlSafeEncoder = Base64.getUrlEncoder().withoutPadding();

    private CryptoUtil() {
    }

    public static byte[] combineByteArray(byte[] data, byte[] key, String keySplitter) {
        byte[] keySplitterBytes = keySplitter.getBytes();
        byte[] combinedArray = new byte[key.length + keySplitterBytes.length + data.length];
        System.arraycopy(key, 0, combinedArray, 0, key.length);
        System.arraycopy(keySplitterBytes, 0, combinedArray, key.length, keySplitterBytes.length);
        System.arraycopy(data, 0, combinedArray, key.length + keySplitterBytes.length, data.length);
        return combinedArray;
    }

    public static int getSplitterIndex(byte[] encryptedData, int keyDemiliterIndex, String keySplitter) {
        String keySplit;
        byte data;
        byte keySplitterFirstByte = keySplitter.getBytes()[0];
        int keySplitterLength = keySplitter.length();
        byte[] byArray = encryptedData;
        int n = byArray.length;
        for (int i = 0; !(i >= n || (data = byArray[i]) == keySplitterFirstByte && keySplitter.equals(keySplit = new String(Arrays.copyOfRange(encryptedData, keyDemiliterIndex, keyDemiliterIndex + keySplitterLength)))); ++i) {
            ++keyDemiliterIndex;
        }
        return keyDemiliterIndex;
    }

    @Deprecated(since="1.1.5", forRemoval=true)
    public static String encodeBase64(byte[] data) {
        return urlSafeEncoder.encodeToString(data);
    }

    @Deprecated(since="1.1.5", forRemoval=true)
    public static String encodeBase64String(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    @Deprecated(since="1.1.5", forRemoval=true)
    public static byte[] decodeBase64(String data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        try {
            return Base64.getUrlDecoder().decode(data);
        }
        catch (IllegalArgumentException exception) {
            return Base64.getDecoder().decode(data);
        }
    }

    public static String encodeToURLSafeBase64(byte[] data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return urlSafeEncoder.encodeToString(data);
    }

    public static byte[] decodeURLSafeBase64(String data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return Base64.getUrlDecoder().decode(data);
    }

    public static String encodeToPlainBase64(byte[] data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decodePlainBase64(String data) {
        if (EmptyCheckUtils.isNullEmpty(data)) {
            return null;
        }
        return Base64.getDecoder().decode(data);
    }

    public static String computeFingerPrint(String data, String metaData) {
        return CryptoUtil.computeFingerPrint(data.getBytes(), metaData);
    }

    public static String computeFingerPrint(byte[] data, String metaData) {
        byte[] combinedPlainTextBytes = null;
        combinedPlainTextBytes = EmptyCheckUtils.isNullEmpty(metaData) ? ArrayUtils.addAll((byte[])data, (byte[])new byte[0]) : ArrayUtils.addAll((byte[])data, (byte[])metaData.getBytes());
        return Hex.encodeHexString((byte[])HMACUtils.generateHash(combinedPlainTextBytes)).replaceAll("..(?!$)", "$0:");
    }
}

