/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.security.processor;

import io.mosip.kernel.core.security.constants.MosipSecurityExceptionCodeConstants;
import io.mosip.kernel.core.security.constants.MosipSecurityMethod;
import io.mosip.kernel.core.security.decryption.MosipDecryptor;
import io.mosip.kernel.core.security.encryption.MosipEncryptor;
import io.mosip.kernel.core.security.exception.MosipInvalidDataException;
import io.mosip.kernel.core.security.exception.MosipInvalidKeyException;
import io.mosip.kernel.core.security.exception.MosipNullDataException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AsymmetricProcessor {
    protected AsymmetricProcessor() {
    }

    protected static byte[] processHybrid(AsymmetricBlockCipher asymmetricBlockCipher, AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        AsymmetricProcessor.init(asymmetricBlockCipher, key, mode);
        int blockSize = asymmetricBlockCipher.getInputBlockSize();
        byte[] symmetricKey = null;
        byte[] output = null;
        if (mode) {
            symmetricKey = blockSize >= 256 ? AsymmetricProcessor.generateSymetricKey(32) : (blockSize >= 192 ? AsymmetricProcessor.generateSymetricKey(24) : AsymmetricProcessor.generateSymetricKey(16));
            byte[] encryptedSymmetricData = MosipEncryptor.symmetricEncrypt(symmetricKey, data, MosipSecurityMethod.AES_WITH_CBC_AND_PKCS7PADDING);
            byte[] encryptedSymmetricKey = AsymmetricProcessor.processData(asymmetricBlockCipher, symmetricKey, 0, symmetricKey.length);
            output = new byte[asymmetricBlockCipher.getOutputBlockSize() + encryptedSymmetricData.length];
            System.arraycopy(encryptedSymmetricKey, 0, output, 0, encryptedSymmetricKey.length);
            System.arraycopy(encryptedSymmetricData, 0, output, encryptedSymmetricKey.length, encryptedSymmetricData.length);
        } else {
            symmetricKey = AsymmetricProcessor.processData(asymmetricBlockCipher, data, 0, blockSize);
            byte[] encrptedData = new byte[data.length - blockSize];
            System.arraycopy(data, blockSize, encrptedData, 0, encrptedData.length);
            output = MosipDecryptor.symmetricDecrypt(symmetricKey, encrptedData, MosipSecurityMethod.AES_WITH_CBC_AND_PKCS7PADDING);
        }
        return output;
    }

    protected static byte[] process(AsymmetricBlockCipher asymmetricBlockCipher, AsymmetricKeyParameter key, byte[] data, boolean mode) throws MosipInvalidDataException, MosipInvalidKeyException {
        AsymmetricProcessor.init(asymmetricBlockCipher, key, mode);
        if (data == null) {
            throw new MosipNullDataException(MosipSecurityExceptionCodeConstants.MOSIP_NULL_DATA_EXCEPTION);
        }
        return AsymmetricProcessor.processData(asymmetricBlockCipher, data, 0, data.length);
    }

    private static void init(AsymmetricBlockCipher asymmetricBlockCipher, AsymmetricKeyParameter key, boolean mode) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        asymmetricBlockCipher.init(mode, (CipherParameters)key);
    }

    private static byte[] processData(AsymmetricBlockCipher asymmetricBlockCipher, byte[] data, int start, int end) throws MosipInvalidDataException, MosipInvalidKeyException {
        try {
            return asymmetricBlockCipher.processBlock(data, start, end);
        }
        catch (InvalidCipherTextException e) {
            throw new MosipInvalidDataException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_ENCRYPTED_DATA_CORRUPT_EXCEPTION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MosipInvalidDataException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_DATA_EXCEPTION);
        }
        catch (DataLengthException e) {
            throw new MosipInvalidDataException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_LENGTH_EXCEPTION);
        }
        catch (NullPointerException e) {
            throw new MosipNullDataException(MosipSecurityExceptionCodeConstants.MOSIP_NULL_DATA_EXCEPTION);
        }
        catch (IllegalArgumentException e) {
            throw new MosipInvalidDataException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_DATA_LENGTH_EXCEPTION);
        }
        catch (ArithmeticException e) {
            throw new MosipInvalidKeyException(MosipSecurityExceptionCodeConstants.MOSIP_INVALID_KEY_CORRUPT_EXCEPTION);
        }
    }

    private static byte[] generateSymetricKey(int length) {
        SecureRandom random = new SecureRandom();
        byte[] keyBytes = new byte[length];
        random.nextBytes(keyBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        return key.getEncoded();
    }
}

