/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.core.exception;

import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.InfoItem;
import java.util.ArrayList;
import java.util.List;

public class BaseCheckedException
extends Exception {
    private static final long serialVersionUID = -924722202100630614L;
    private final List<InfoItem> infoItems = new ArrayList<InfoItem>();

    public BaseCheckedException() {
    }

    public BaseCheckedException(String errorMessage) {
        super(errorMessage);
    }

    public BaseCheckedException(String errorCode, String errorMessage) {
        super(errorCode + " --> " + errorMessage);
        this.addInfo(errorCode, errorMessage);
    }

    public BaseCheckedException(String errorCode, String errorMessage, Throwable rootCause) {
        super(errorCode + " --> " + errorMessage, rootCause);
        this.addInfo(errorCode, errorMessage);
        if (rootCause instanceof BaseCheckedException) {
            BaseCheckedException bce = (BaseCheckedException)rootCause;
            this.infoItems.addAll(bce.infoItems);
        }
    }

    public BaseCheckedException addInfo(String errorCode, String errorText) {
        this.infoItems.add(new InfoItem(errorCode, errorText));
        return this;
    }

    @Override
    public String getMessage() {
        return ExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    public List<String> getCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        for (int i = this.infoItems.size() - 1; i >= 0; --i) {
            codes.add(this.infoItems.get((int)i).errorCode);
        }
        return codes;
    }

    public List<String> getErrorTexts() {
        ArrayList<String> errorTexts = new ArrayList<String>();
        for (int i = this.infoItems.size() - 1; i >= 0; --i) {
            errorTexts.add(this.infoItems.get((int)i).errorText);
        }
        return errorTexts;
    }

    public String getErrorCode() {
        return this.infoItems.get((int)0).errorCode;
    }

    public String getErrorText() {
        return this.infoItems.get((int)0).errorText;
    }
}

