/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v3.config;

import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="mongock.mongo-db")
public class MongoDBConfiguration {
    private WriteConcernLevel writeConcern = WriteConcernLevel.MAJORITY_WITH_JOURNAL;
    private ReadConcernLevel readConcern = ReadConcernLevel.MAJORITY;
    private ReadPreferenceLevel readPreference = ReadPreferenceLevel.PRIMARY;

    public WriteConcernLevel getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(WriteConcernLevel writeConcern) {
        this.writeConcern = writeConcern;
    }

    public ReadConcernLevel getReadConcern() {
        return this.readConcern;
    }

    public void setReadConcern(ReadConcernLevel readConcern) {
        this.readConcern = readConcern;
    }

    public ReadPreferenceLevel getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(ReadPreferenceLevel readPreference) {
        this.readPreference = readPreference;
    }

    protected WriteConcern getBuiltMongoDBWriteConcern() {
        WriteConcern wc = new WriteConcern(this.writeConcern.w).withJournal(this.writeConcern.journal);
        return this.writeConcern.getwTimeoutMs() == null ? wc : wc.withWTimeout(this.writeConcern.getwTimeoutMs().longValue(), TimeUnit.MILLISECONDS);
    }

    public static enum ReadPreferenceLevel {
        PRIMARY(ReadPreference.primary()),
        PRIMARY_PREFERRED(ReadPreference.primaryPreferred()),
        SECONDARY(ReadPreference.secondary()),
        SECONDARY_PREFERRED(ReadPreference.secondaryPreferred()),
        NEAREST(ReadPreference.nearest());

        private ReadPreference value;

        private ReadPreferenceLevel(ReadPreference value) {
            this.value = value;
        }

        public ReadPreference getValue() {
            return this.value;
        }
    }

    public static class WriteConcernLevel {
        private String w;
        private Integer wTimeoutMs;
        private Boolean journal;
        public static final WriteConcernLevel MAJORITY_WITH_JOURNAL = new WriteConcernLevel(WriteConcern.MAJORITY.getWString(), null, true);

        public WriteConcernLevel(String w, Integer wTimeoutMs, Boolean journal) {
            this.w = w;
            this.wTimeoutMs = wTimeoutMs;
            this.journal = journal;
        }

        public String getW() {
            return this.w;
        }

        public void setW(String w) {
            this.w = w;
        }

        public Integer getwTimeoutMs() {
            return this.wTimeoutMs;
        }

        public void setwTimeoutMs(Integer wTimeoutMs) {
            this.wTimeoutMs = wTimeoutMs;
        }

        public Boolean isJournal() {
            return this.journal;
        }

        public void setJournal(Boolean journal) {
            this.journal = journal;
        }
    }
}

