/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.reactive.driver;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.DriverLegaciable;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.core.driver.TransactionalConnectionDriverBase;
import io.mongock.driver.core.lock.LockRepository;
import io.mongock.driver.mongodb.reactive.changelogs.runalways.MongockReactiveLegacyMigrationRunAlwaysChange;
import io.mongock.driver.mongodb.reactive.changelogs.runonce.MongockReactiveLegacyMigrationChange;
import io.mongock.driver.mongodb.reactive.repository.MongoReactiveChangeEntryRepository;
import io.mongock.driver.mongodb.reactive.repository.MongoReactiveLockRepository;
import io.mongock.driver.mongodb.reactive.repository.ReadWriteConfiguration;
import io.mongock.utils.annotation.NotThreadSafe;
import org.bson.Document;

@NotThreadSafe
public abstract class MongoReactiveDriverGeneric
extends TransactionalConnectionDriverBase
implements DriverLegaciable {
    private static final WriteConcern DEFAULT_WRITE_CONCERN = WriteConcern.MAJORITY.withJournal(Boolean.valueOf(true));
    private static final ReadConcern DEFAULT_READ_CONCERN = ReadConcern.MAJORITY;
    private static final ReadPreference DEFAULT_READ_PREFERENCE = ReadPreference.primary();
    protected MongoReactiveChangeEntryRepository changeEntryRepository;
    protected MongoReactiveLockRepository lockRepository;
    private WriteConcern writeConcern;
    private ReadConcern readConcern;
    private ReadPreference readPreference;
    protected TransactionOptions txOptions;
    protected final MongoDatabase mongoDatabase;

    protected MongoReactiveDriverGeneric(MongoDatabase mongoDatabase, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
        this.mongoDatabase = mongoDatabase;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void runValidation() throws MongockException {
        if (this.mongoDatabase == null) {
            throw new MongockException("MongoDatabase cannot be null");
        }
        if (this.getLockManager() == null) {
            throw new MongockException("Internal error: Driver needs to be initialized by the runner");
        }
    }

    protected LockRepository getLockRepository() {
        if (this.lockRepository == null) {
            MongoCollection collection = this.mongoDatabase.getCollection(this.getLockRepositoryName());
            this.lockRepository = new MongoReactiveLockRepository((MongoCollection<Document>)collection, this.getReadWriteConfiguration());
            this.lockRepository.setIndexCreation(this.isIndexCreation());
        }
        return this.lockRepository;
    }

    public ChangeEntryService getChangeEntryService() {
        if (this.changeEntryRepository == null) {
            this.changeEntryRepository = new MongoReactiveChangeEntryRepository((MongoCollection<Document>)this.mongoDatabase.getCollection(this.getMigrationRepositoryName()), this.getReadWriteConfiguration());
            this.changeEntryRepository.setIndexCreation(this.isIndexCreation());
        }
        return this.changeEntryRepository;
    }

    public Class getLegacyMigrationChangeLogClass(boolean runAlways) {
        return runAlways ? MongockReactiveLegacyMigrationRunAlwaysChange.class : MongockReactiveLegacyMigrationChange.class;
    }

    public void specificInitialization() {
        this.dependencies.add(new ChangeSetDependency(MongoDatabase.class, (Object)this.mongoDatabase, true));
        this.dependencies.add(new ChangeSetDependency(ChangeEntryService.class, (Object)this.getChangeEntryService(), false));
        this.txOptions = TransactionOptions.builder().writeConcern(this.getWriteConcern()).readConcern(this.getReadConcern()).readPreference(this.getReadPreference()).build();
    }

    protected ReadWriteConfiguration getReadWriteConfiguration() {
        return new ReadWriteConfiguration(this.getWriteConcern(), this.getReadConcern(), this.getReadPreference());
    }

    protected ReadPreference getReadPreference() {
        return this.readPreference != null ? this.readPreference : DEFAULT_READ_PREFERENCE;
    }

    protected ReadConcern getReadConcern() {
        return this.readConcern != null ? this.readConcern : DEFAULT_READ_CONCERN;
    }

    protected WriteConcern getWriteConcern() {
        return this.writeConcern != null ? this.writeConcern : DEFAULT_WRITE_CONCERN;
    }

    @Deprecated
    public void setTransactionOptions(TransactionOptions txOptions) {
        if (this.writeConcern == null) {
            this.setWriteConcern(txOptions.getWriteConcern());
        }
        if (this.readConcern == null) {
            this.setReadConcern(txOptions.getReadConcern());
        }
        if (this.readPreference == null) {
            this.setReadPreference(txOptions.getReadPreference());
        }
    }
}

