/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.java.spring.boot3;

import java.util.Comparator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class AddValidToConfigurationPropertiesFields
extends Recipe {
    private static final AnnotationMatcher CONFIGURATION_PROPERTIES_MATCHER = new AnnotationMatcher("org.springframework.boot.context.properties.ConfigurationProperties");
    private static final AnnotationMatcher VALIDATED_MATCHER = new AnnotationMatcher("@org.springframework.validation.annotation.Validated");
    private static final AnnotationMatcher VALID_MATCHER = new AnnotationMatcher("@jakarta.validation.Valid");
    private static final TypeMatcher JAKARTA_CONSTRAINS = new TypeMatcher("jakarta.validation.constraints.*");

    public String getDisplayName() {
        return "Add `@Valid` annotation to fields";
    }

    public String getDescription() {
        return "In Spring Boot 3.4, validation of `@ConfigurationProperties` classes annotated with `@Validated` now follows the Bean Validation specification, only cascading to nested properties if the corresponding field is annotated with `@Valid`. The recipe will add a `@Valid` annotation to each field which has a type that has a field which is annotated with a `jakarta.validation.constraints.*` annotation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> addValidAnnotationVisitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                AnnotationService as = (AnnotationService)this.service(AnnotationService.class);
                if (!as.matches(this.getCursor(), CONFIGURATION_PROPERTIES_MATCHER) || as.matches(this.getCursor(), VALIDATED_MATCHER)) {
                    return super.visitClassDeclaration(classDecl, (Object)ctx);
                }
                return classDecl;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (this.requiresAnnotation(multiVariable.getType())) {
                    this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)mv));
                    return (J.VariableDeclarations)JavaTemplate.builder((String)"@jakarta.validation.Valid").javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package jakarta.validation;public @interface Valid {}"})).build().apply(this.getCursor(), mv.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
                return mv;
            }

            private boolean requiresAnnotation(@Nullable JavaType type) {
                if (type instanceof JavaType.Class) {
                    if (!((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), VALID_MATCHER)) {
                        for (JavaType.Variable member : ((JavaType.Class)type).getMembers()) {
                            for (JavaType.FullyQualified fullyQualified : member.getAnnotations()) {
                                if (!JAKARTA_CONSTRAINS.matches((JavaType)fullyQualified)) continue;
                                return true;
                            }
                        }
                    }
                    return this.requiresAnnotation((JavaType)((JavaType.Class)type).getSupertype());
                }
                return false;
            }
        };
        return new Preconditions.Check(Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.validation.annotation.Validated", Boolean.valueOf(true)), new UsesType("org.springframework.boot.context.properties.ConfigurationProperties", Boolean.valueOf(true))}), (TreeVisitor)addValidAnnotationVisitor);
    }
}

