/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.test.StepVerifier;

public abstract class AbstractMcpSyncClientTests {
    private static final String TEST_MESSAGE = "Hello MCP Spring AI!";
    static final Object DUMMY_RETURN_VALUE = new Object();

    protected abstract McpClientTransport createMcpTransport();

    protected void onStart() {
    }

    protected void onClose() {
    }

    protected Duration getRequestTimeout() {
        return Duration.ofSeconds(14L);
    }

    protected Duration getInitializationTimeout() {
        return Duration.ofSeconds(2L);
    }

    McpSyncClient client(McpClientTransport transport) {
        return this.client(transport, Function.identity());
    }

    McpSyncClient client(McpClientTransport transport, Function<McpClient.SyncSpec, McpClient.SyncSpec> customizer) {
        AtomicReference client = new AtomicReference();
        Assertions.assertThatCode(() -> {
            McpClient.SyncSpec builder = McpClient.sync((McpClientTransport)transport).requestTimeout(this.getRequestTimeout()).initializationTimeout(this.getInitializationTimeout()).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build());
            builder = (McpClient.SyncSpec)customizer.apply(builder);
            client.set(builder.build());
        }).doesNotThrowAnyException();
        return (McpSyncClient)client.get();
    }

    void withClient(McpClientTransport transport, Consumer<McpSyncClient> c) {
        this.withClient(transport, Function.identity(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withClient(McpClientTransport transport, Function<McpClient.SyncSpec, McpClient.SyncSpec> customizer, Consumer<McpSyncClient> c) {
        McpSyncClient client = this.client(transport, customizer);
        try {
            c.accept(client);
        }
        finally {
            Assertions.assertThat((boolean)client.closeGracefully()).isTrue();
        }
    }

    @BeforeEach
    void setUp() {
        this.onStart();
    }

    @AfterEach
    void tearDown() {
        this.onClose();
    }

    <T> void verifyNotificationTimesOut(Consumer<McpSyncClient> operation, String action) {
        this.verifyCallTimesOut(client -> {
            operation.accept((McpSyncClient)client);
            return DUMMY_RETURN_VALUE;
        }, action);
    }

    <T> void verifyCallTimesOut(Function<McpSyncClient, T> blockingOperation, String action) {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            Scheduler customScheduler = Schedulers.newBoundedElastic((int)1, (int)1, (String)"actualBoundedElastic");
            StepVerifier.withVirtualTime(() -> Mono.fromSupplier(() -> blockingOperation.apply((McpSyncClient)mcpSyncClient)).subscribeOn(customScheduler)).expectSubscription().thenAwait(this.getInitializationTimeout()).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Client must be initialized before " + action)).verify();
            customScheduler.dispose();
        });
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync((McpClientTransport)this.createMcpTransport()).requestTimeout(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Request timeout must not be null");
    }

    @Test
    void testListToolsWithoutInitialization() {
        this.verifyCallTimesOut(client -> client.listTools(null), "listing tools");
    }

    @Test
    void testListTools() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListToolsResult tools = mcpSyncClient.listTools(null);
            ((ObjectAssert)Assertions.assertThat((Object)tools).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
                McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
                Assertions.assertThat((String)firstTool.name()).isNotNull();
                Assertions.assertThat((String)firstTool.description()).isNotNull();
            }});
        });
    }

    @Test
    void testCallToolsWithoutInitialization() {
        this.verifyCallTimesOut(client -> client.callTool(new McpSchema.CallToolRequest("add", Map.of("a", 3, "b", 4))), "calling tools");
    }

    @Test
    void testCallTools() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.CallToolResult toolResult = mcpSyncClient.callTool(new McpSchema.CallToolRequest("add", Map.of("a", 3, "b", 4)));
            ((ObjectAssert)Assertions.assertThat((Object)toolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.content()).hasSize(1);
                McpSchema.TextContent content = (McpSchema.TextContent)result.content().get(0);
                Assertions.assertThat((Object)content).isNotNull();
                Assertions.assertThat((String)content.text()).isNotNull();
                Assertions.assertThat((String)content.text()).contains(new CharSequence[]{"7"});
            }});
        });
    }

    @Test
    void testPingWithoutInitialization() {
        this.verifyCallTimesOut(client -> client.ping(), "pinging the server");
    }

    @Test
    void testPing() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            Assertions.assertThatCode(() -> mcpSyncClient.ping()).doesNotThrowAnyException();
        });
    }

    @Test
    void testCallToolWithoutInitialization() {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", TEST_MESSAGE));
        this.verifyCallTimesOut(client -> client.callTool(callToolRequest), "calling tools");
    }

    @Test
    void testCallTool() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", TEST_MESSAGE));
            McpSchema.CallToolResult callToolResult = mcpSyncClient.callTool(callToolRequest);
            ((ObjectAssert)Assertions.assertThat((Object)callToolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.content()).isNotNull();
                Assertions.assertThat((Boolean)result.isError()).isNull();
            }});
        });
    }

    @Test
    void testCallToolWithInvalidTool() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.CallToolRequest invalidRequest = new McpSchema.CallToolRequest("nonexistent_tool", Map.of("message", TEST_MESSAGE));
            Assertions.assertThatThrownBy(() -> mcpSyncClient.callTool(invalidRequest)).isInstanceOf(Exception.class);
        });
    }

    @Test
    void testRootsListChangedWithoutInitialization() {
        this.verifyNotificationTimesOut(client -> client.rootsListChangedNotification(), "sending roots list changed notification");
    }

    @Test
    void testRootsListChanged() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            Assertions.assertThatCode(() -> mcpSyncClient.rootsListChangedNotification()).doesNotThrowAnyException();
        });
    }

    @Test
    void testListResourcesWithoutInitialization() {
        this.verifyCallTimesOut(client -> client.listResources(null), "listing resources");
    }

    @Test
    void testListResources() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListResourcesResult resources = mcpSyncClient.listResources(null);
            ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.resources()).isNotNull();
                if (!result.resources().isEmpty()) {
                    McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                    Assertions.assertThat((String)firstResource.uri()).isNotNull();
                    Assertions.assertThat((String)firstResource.name()).isNotNull();
                }
            }});
        });
    }

    @Test
    void testClientSessionState() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThat((Object)mcpSyncClient).isNotNull());
    }

    @Test
    void testInitializeWithRootsListProviders() {
        this.withClient(this.createMcpTransport(), builder -> builder.roots(new McpSchema.Root[]{new McpSchema.Root("file:///test/path", "test-root")}), mcpSyncClient -> Assertions.assertThatCode(() -> {
            mcpSyncClient.initialize();
            mcpSyncClient.close();
        }).doesNotThrowAnyException());
    }

    @Test
    void testAddRoot() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.Root newRoot = new McpSchema.Root("file:///new/test/path", "new-test-root");
            Assertions.assertThatCode(() -> mcpSyncClient.addRoot(newRoot)).doesNotThrowAnyException();
        });
    }

    @Test
    void testAddRootWithNullValue() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThatThrownBy(() -> mcpSyncClient.addRoot(null)).hasMessageContaining("Root must not be null"));
    }

    @Test
    void testRemoveRoot() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.Root root = new McpSchema.Root("file:///test/path/to/remove", "root-to-remove");
            Assertions.assertThatCode(() -> {
                mcpSyncClient.addRoot(root);
                mcpSyncClient.removeRoot(root.uri());
            }).doesNotThrowAnyException();
        });
    }

    @Test
    void testRemoveNonExistentRoot() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThatThrownBy(() -> mcpSyncClient.removeRoot("nonexistent-uri")).hasMessageContaining("Root with uri 'nonexistent-uri' not found"));
    }

    @Test
    void testReadResourceWithoutInitialization() {
        McpSchema.Resource resource = new McpSchema.Resource("test://uri", "Test Resource", null, null, null);
        this.verifyCallTimesOut(client -> client.readResource(resource), "reading resources");
    }

    @Test
    void testReadResource() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListResourcesResult resources = mcpSyncClient.listResources(null);
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                McpSchema.ReadResourceResult result = mcpSyncClient.readResource(firstResource);
                Assertions.assertThat((Object)result).isNotNull();
                Assertions.assertThat((List)result.contents()).isNotNull();
            }
        });
    }

    @Test
    void testListResourceTemplatesWithoutInitialization() {
        this.verifyCallTimesOut(client -> client.listResourceTemplates(null), "listing resource templates");
    }

    @Test
    void testListResourceTemplates() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListResourceTemplatesResult result = mcpSyncClient.listResourceTemplates(null);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
        });
    }

    void testResourceSubscription() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.ListResourcesResult resources = mcpSyncClient.listResources(null);
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                Assertions.assertThatCode(() -> mcpSyncClient.subscribeResource(new McpSchema.SubscribeRequest(firstResource.uri()))).doesNotThrowAnyException();
                Assertions.assertThatCode(() -> mcpSyncClient.unsubscribeResource(new McpSchema.UnsubscribeRequest(firstResource.uri()))).doesNotThrowAnyException();
            }
        });
    }

    @Test
    void testNotificationHandlers() {
        AtomicBoolean toolsNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean resourcesNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean promptsNotificationReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.toolsChangeConsumer(tools -> toolsNotificationReceived.set(true)).resourcesChangeConsumer(resources -> resourcesNotificationReceived.set(true)).promptsChangeConsumer(prompts -> promptsNotificationReceived.set(true)), client -> Assertions.assertThatCode(() -> {
            client.initialize();
            client.close();
        }).doesNotThrowAnyException());
    }

    @Test
    void testLoggingLevelsWithoutInitialization() {
        this.verifyNotificationTimesOut(client -> client.setLoggingLevel(McpSchema.LoggingLevel.DEBUG), "setting logging level");
    }

    @Test
    void testLoggingLevels() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            for (McpSchema.LoggingLevel level : McpSchema.LoggingLevel.values()) {
                Assertions.assertThatCode(() -> mcpSyncClient.setLoggingLevel(level)).doesNotThrowAnyException();
            }
        });
    }

    @Test
    void testLoggingConsumer() {
        AtomicBoolean logReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.requestTimeout(this.getRequestTimeout()).loggingConsumer(notification -> logReceived.set(true)), client -> Assertions.assertThatCode(() -> {
            client.initialize();
            client.close();
        }).doesNotThrowAnyException());
    }

    @Test
    void testLoggingWithNullNotification() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThatThrownBy(() -> mcpSyncClient.setLoggingLevel(null)).hasMessageContaining("Logging level must not be null"));
    }
}

