/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class AbstractMcpAsyncClientTests {
    private static final String ECHO_TEST_MESSAGE = "Hello MCP Spring AI!";

    protected abstract McpClientTransport createMcpTransport();

    protected void onStart() {
    }

    protected void onClose() {
    }

    protected Duration getRequestTimeout() {
        return Duration.ofSeconds(14L);
    }

    protected Duration getInitializationTimeout() {
        return Duration.ofSeconds(2L);
    }

    McpAsyncClient client(McpClientTransport transport) {
        return this.client(transport, Function.identity());
    }

    McpAsyncClient client(McpClientTransport transport, Function<McpClient.AsyncSpec, McpClient.AsyncSpec> customizer) {
        AtomicReference client = new AtomicReference();
        Assertions.assertThatCode(() -> {
            McpClient.AsyncSpec builder = McpClient.async((McpClientTransport)transport).requestTimeout(this.getRequestTimeout()).initializationTimeout(this.getInitializationTimeout()).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build());
            builder = (McpClient.AsyncSpec)customizer.apply(builder);
            client.set(builder.build());
        }).doesNotThrowAnyException();
        return (McpAsyncClient)client.get();
    }

    void withClient(McpClientTransport transport, Consumer<McpAsyncClient> c) {
        this.withClient(transport, Function.identity(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withClient(McpClientTransport transport, Function<McpClient.AsyncSpec, McpClient.AsyncSpec> customizer, Consumer<McpAsyncClient> c) {
        McpAsyncClient client = this.client(transport, customizer);
        try {
            c.accept(client);
        }
        finally {
            StepVerifier.create((Publisher)client.closeGracefully()).expectComplete().verify(Duration.ofSeconds(10L));
        }
    }

    @BeforeEach
    void setUp() {
        this.onStart();
    }

    @AfterEach
    void tearDown() {
        this.onClose();
    }

    <T> void verifyInitializationTimeout(Function<McpAsyncClient, Mono<T>> operation, String action) {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.withVirtualTime(() -> (Publisher)operation.apply((McpAsyncClient)mcpAsyncClient)).expectSubscription().thenAwait(this.getInitializationTimeout()).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Client must be initialized before " + action)).verify());
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.async(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.async((McpClientTransport)this.createMcpTransport()).requestTimeout(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Request timeout must not be null");
    }

    @Test
    void testListToolsWithoutInitialization() {
        this.verifyInitializationTimeout(client -> client.listTools(null), "listing tools");
    }

    @Test
    void testListTools() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listTools(null))).consumeNextWith(result -> {
            ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
            McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
            Assertions.assertThat((String)firstTool.name()).isNotNull();
            Assertions.assertThat((String)firstTool.description()).isNotNull();
        }).verifyComplete());
    }

    @Test
    void testPingWithoutInitialization() {
        this.verifyInitializationTimeout(client -> client.ping(), "pinging the server");
    }

    @Test
    void testPing() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.ping())).expectNextCount(1L).verifyComplete());
    }

    @Test
    void testCallToolWithoutInitialization() {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", ECHO_TEST_MESSAGE));
        this.verifyInitializationTimeout(client -> client.callTool(callToolRequest), "calling tools");
    }

    @Test
    void testCallTool() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", ECHO_TEST_MESSAGE));
            StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.callTool(callToolRequest))).consumeNextWith(callToolResult -> ((ObjectAssert)Assertions.assertThat((Object)callToolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.content()).isNotNull();
                Assertions.assertThat((Boolean)result.isError()).isNull();
            }})).verifyComplete();
        });
    }

    @Test
    void testCallToolWithInvalidTool() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.CallToolRequest invalidRequest = new McpSchema.CallToolRequest("nonexistent_tool", Map.of("message", ECHO_TEST_MESSAGE));
            StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.callTool(invalidRequest))).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Unknown tool: nonexistent_tool")).verify();
        });
    }

    @Test
    void testListResourcesWithoutInitialization() {
        this.verifyInitializationTimeout(client -> client.listResources(null), "listing resources");
    }

    @Test
    void testListResources() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResources(null))).consumeNextWith(resources -> ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.resources()).isNotNull();
            if (!result.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                Assertions.assertThat((String)firstResource.uri()).isNotNull();
                Assertions.assertThat((String)firstResource.name()).isNotNull();
            }
        }})).verifyComplete());
    }

    @Test
    void testMcpAsyncClientState() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> Assertions.assertThat((Object)mcpAsyncClient).isNotNull());
    }

    @Test
    void testListPromptsWithoutInitialization() {
        this.verifyInitializationTimeout(client -> client.listPrompts(null), "listing prompts");
    }

    @Test
    void testListPrompts() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listPrompts(null))).consumeNextWith(prompts -> ((ObjectAssert)Assertions.assertThat((Object)prompts).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.prompts()).isNotNull();
            if (!result.prompts().isEmpty()) {
                McpSchema.Prompt firstPrompt = (McpSchema.Prompt)result.prompts().get(0);
                Assertions.assertThat((String)firstPrompt.name()).isNotNull();
                Assertions.assertThat((String)firstPrompt.description()).isNotNull();
            }
        }})).verifyComplete());
    }

    @Test
    void testGetPromptWithoutInitialization() {
        McpSchema.GetPromptRequest request = new McpSchema.GetPromptRequest("simple_prompt", Map.of());
        this.verifyInitializationTimeout(client -> client.getPrompt(request), "getting prompts");
    }

    @Test
    void testGetPrompt() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.getPrompt(new McpSchema.GetPromptRequest("simple_prompt", Map.of())))).consumeNextWith(prompt -> ((ObjectAssert)Assertions.assertThat((Object)prompt).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.messages()).isNotEmpty();
            Assertions.assertThat((List)result.messages()).hasSize(1);
        }})).verifyComplete());
    }

    @Test
    void testRootsListChangedWithoutInitialization() {
        this.verifyInitializationTimeout(client -> client.rootsListChangedNotification(), "sending roots list changed notification");
    }

    @Test
    void testRootsListChanged() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.rootsListChangedNotification())).verifyComplete());
    }

    @Test
    void testInitializeWithRootsListProviders() {
        this.withClient(this.createMcpTransport(), builder -> builder.roots(new McpSchema.Root[]{new McpSchema.Root("file:///test/path", "test-root")}), client -> StepVerifier.create((Publisher)client.initialize().then(client.closeGracefully())).verifyComplete());
    }

    @Test
    void testAddRoot() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.Root newRoot = new McpSchema.Root("file:///new/test/path", "new-test-root");
            StepVerifier.create((Publisher)mcpAsyncClient.addRoot(newRoot)).verifyComplete();
        });
    }

    @Test
    void testAddRootWithNullValue() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.addRoot(null)).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Root must not be null")).verify());
    }

    @Test
    void testRemoveRoot() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.Root root = new McpSchema.Root("file:///test/path/to/remove", "root-to-remove");
            StepVerifier.create((Publisher)mcpAsyncClient.addRoot(root)).verifyComplete();
            StepVerifier.create((Publisher)mcpAsyncClient.removeRoot(root.uri())).verifyComplete();
        });
    }

    @Test
    void testRemoveNonExistentRoot() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.removeRoot("nonexistent-uri")).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Root with uri 'nonexistent-uri' not found")).verify());
    }

    @Test
    @Disabled
    void testReadResource() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.listResources()).consumeNextWith(resources -> {
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                StepVerifier.create((Publisher)mcpAsyncClient.readResource(firstResource)).consumeNextWith(result -> {
                    Assertions.assertThat((Object)result).isNotNull();
                    Assertions.assertThat((List)result.contents()).isNotNull();
                }).verifyComplete();
            }
        }).verifyComplete());
    }

    @Test
    void testListResourceTemplatesWithoutInitialization() {
        this.verifyInitializationTimeout(client -> client.listResourceTemplates(), "listing resource templates");
    }

    @Test
    void testListResourceTemplates() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResourceTemplates())).consumeNextWith(result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
        }).verifyComplete());
    }

    void testResourceSubscription() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.listResources()).consumeNextWith(resources -> {
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                StepVerifier.create((Publisher)mcpAsyncClient.subscribeResource(new McpSchema.SubscribeRequest(firstResource.uri()))).verifyComplete();
                StepVerifier.create((Publisher)mcpAsyncClient.unsubscribeResource(new McpSchema.UnsubscribeRequest(firstResource.uri()))).verifyComplete();
            }
        }).verifyComplete());
    }

    @Test
    void testNotificationHandlers() {
        AtomicBoolean toolsNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean resourcesNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean promptsNotificationReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.toolsChangeConsumer(tools -> Mono.fromRunnable(() -> toolsNotificationReceived.set(true))).resourcesChangeConsumer(resources -> Mono.fromRunnable(() -> resourcesNotificationReceived.set(true))).promptsChangeConsumer(prompts -> Mono.fromRunnable(() -> promptsNotificationReceived.set(true))), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize()).expectNextMatches(Objects::nonNull).verifyComplete());
    }

    @Test
    void testInitializeWithSamplingCapability() {
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().sampling().build();
        McpSchema.CreateMessageResult createMessageResult = McpSchema.CreateMessageResult.builder().message("test").model("test-model").build();
        this.withClient(this.createMcpTransport(), builder -> builder.capabilities(capabilities).sampling(request -> Mono.just((Object)createMessageResult)), client -> StepVerifier.create((Publisher)client.initialize()).expectNextMatches(Objects::nonNull).verifyComplete());
    }

    @Test
    void testInitializeWithAllCapabilities() {
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().experimental(Map.of("feature", "test")).roots(Boolean.valueOf(true)).sampling().build();
        Function<McpSchema.CreateMessageRequest, Mono> samplingHandler = request -> Mono.just((Object)McpSchema.CreateMessageResult.builder().message("test").model("test-model").build());
        this.withClient(this.createMcpTransport(), builder -> builder.capabilities(capabilities).sampling(samplingHandler), client -> StepVerifier.create((Publisher)client.initialize()).assertNext(result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Object)result.capabilities()).isNotNull();
        }).verifyComplete());
    }

    @Test
    void testLoggingLevelsWithoutInitialization() {
        this.verifyInitializationTimeout(client -> client.setLoggingLevel(McpSchema.LoggingLevel.DEBUG), "setting logging level");
    }

    @Test
    void testLoggingLevels() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            Mono testAllLevels = mcpAsyncClient.initialize().then(Mono.defer(() -> {
                Mono chain = Mono.empty();
                for (McpSchema.LoggingLevel level : McpSchema.LoggingLevel.values()) {
                    chain = chain.then(mcpAsyncClient.setLoggingLevel(level));
                }
                return chain;
            }));
            StepVerifier.create((Publisher)testAllLevels).verifyComplete();
        });
    }

    @Test
    void testLoggingConsumer() {
        AtomicBoolean logReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.loggingConsumer(notification -> Mono.fromRunnable(() -> logReceived.set(true))), client -> {
            StepVerifier.create((Publisher)client.initialize()).expectNextMatches(Objects::nonNull).verifyComplete();
            StepVerifier.create((Publisher)client.closeGracefully()).verifyComplete();
        });
    }

    @Test
    void testLoggingWithNullNotification() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.setLoggingLevel(null)).expectErrorMatches(error -> error.getMessage().contains("Logging level must not be null")).verify());
    }
}

