/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpStatelessAsyncServer;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.server.McpStatelessSyncServer;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import reactor.core.publisher.Mono;

public abstract class AbstractStatelessIntegrationTests {
    protected ConcurrentHashMap<String, McpClient.SyncSpec> clientBuilders = new ConcurrentHashMap();
    String emptyJsonSchema = "{\n\t\"$schema\": \"http://json-schema.org/draft-07/schema#\",\n\t\"type\": \"object\",\n\t\"properties\": {}\n}\n";

    protected abstract void prepareClients(int var1, String var2);

    protected abstract McpServer.StatelessAsyncSpecification prepareAsyncServerBuilder();

    protected abstract McpServer.StatelessSyncSpecification prepareSyncServerBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void simple(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpStatelessAsyncServer server = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").requestTimeout(Duration.ofSeconds(1000L)).build();
        try (McpSyncClient client = clientBuilder.clientInfo(new McpSchema.Implementation("Sample client", "0.0.0")).requestTimeout(Duration.ofSeconds(1000L)).build();){
            Assertions.assertThat((Object)client.initialize()).isNotNull();
        }
        finally {
            server.closeGracefully().block();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testToolCallSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        McpStatelessServerFeatures.SyncToolSpecification tool1 = McpStatelessServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((ctx, request) -> {
            try {
                HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/modelcontextprotocol/java-sdk/refs/heads/main/README.md")).GET().build(), HttpResponse.BodyHandlers.ofString());
                String responseBody = response.body();
                Assertions.assertThat((String)responseBody).isNotBlank();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return callResponse;
        }).build();
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpStatelessServerFeatures.SyncToolSpecification[]{tool1}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThat((List)mcpClient.listTools().tools()).contains((Object[])new McpSchema.Tool[]{tool1.tool()});
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()));
            ((ObjectAssert)Assertions.assertThat((Object)response).isNotNull()).isEqualTo((Object)callResponse);
        }
        finally {
            mcpServer.closeGracefully().block();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testThrowingToolCallIsCaughtBeforeTimeout(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpStatelessServerFeatures.SyncToolSpecification[]{McpStatelessServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((context, request) -> {
            Mono.never().block(Duration.ofSeconds(1L));
            return null;
        }).build()}).build();
        try (McpSyncClient mcpClient = clientBuilder.requestTimeout(Duration.ofMillis(6666L)).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThatExceptionOfType(McpError.class).isThrownBy(() -> mcpClient.callTool(new McpSchema.CallToolRequest("tool1", Map.of()))).withMessageContaining("Timeout on blocking read");
        }
        finally {
            mcpServer.closeGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testToolListChangeHandlingSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpSchema.CallToolResult callResponse = new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("CALL RESPONSE")), null);
        McpStatelessServerFeatures.SyncToolSpecification tool1 = McpStatelessServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool1").description("tool1 description").inputSchema(this.emptyJsonSchema).build()).callHandler((ctx, request) -> {
            try {
                HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/modelcontextprotocol/java-sdk/refs/heads/main/README.md")).GET().build(), HttpResponse.BodyHandlers.ofString());
                String responseBody = response.body();
                Assertions.assertThat((String)responseBody).isNotBlank();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return callResponse;
        }).build();
        AtomicReference rootsRef = new AtomicReference();
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpStatelessServerFeatures.SyncToolSpecification[]{tool1}).build();
        try (McpSyncClient mcpClient = clientBuilder.toolsChangeConsumer(toolsUpdate -> {
            try {
                HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/modelcontextprotocol/java-sdk/refs/heads/main/README.md")).GET().build(), HttpResponse.BodyHandlers.ofString());
                String responseBody = response.body();
                Assertions.assertThat((String)responseBody).isNotBlank();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rootsRef.set(toolsUpdate);
        }).build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThat((List)((List)rootsRef.get())).isNull();
            Assertions.assertThat((List)mcpClient.listTools().tools()).contains((Object[])new McpSchema.Tool[]{tool1.tool()});
            mcpServer.removeTool("tool1");
            McpStatelessServerFeatures.SyncToolSpecification tool2 = McpStatelessServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("tool2").description("tool2 description").inputSchema(this.emptyJsonSchema).build()).callHandler((exchange, request) -> callResponse).build();
            mcpServer.addTool(tool2);
        }
        finally {
            mcpServer.closeGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testInitialize(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
        }
        finally {
            mcpServer.closeGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputValidationSuccess(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("result", Map.of("type", "number"), "operation", Map.of("type", "string"), "timestamp", Map.of("type", "string")), "required", List.of("result", "operation"));
        McpSchema.Tool calculatorTool = McpSchema.Tool.builder().name("calculator").description("Performs mathematical calculations").outputSchema(outputSchema).build();
        McpStatelessServerFeatures.SyncToolSpecification tool = McpStatelessServerFeatures.SyncToolSpecification.builder().tool(calculatorTool).callHandler((exchange, request) -> {
            String expression = request.arguments().getOrDefault("expression", "2 + 3");
            double result = this.evaluateExpression(expression);
            return McpSchema.CallToolResult.builder().structuredContent(Map.of("result", result, "operation", expression, "timestamp", "2024-01-01T10:00:00Z")).build();
        }).build();
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpStatelessServerFeatures.SyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.ListToolsResult toolsList = mcpClient.listTools();
            Assertions.assertThat((List)toolsList.tools()).hasSize(1);
            Assertions.assertThat((String)((McpSchema.Tool)toolsList.tools().get(0)).name()).isEqualTo("calculator");
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("calculator", Map.of("expression", "2 + 3")));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isFalse();
            if (response.structuredContent() != null) {
                ((MapAssert)((MapAssert)Assertions.assertThat((Map)response.structuredContent()).containsEntry((Object)"result", (Object)5.0)).containsEntry((Object)"operation", (Object)"2 + 3")).containsEntry((Object)"timestamp", (Object)"2024-01-01T10:00:00Z");
            } else {
                Assertions.assertThat((List)response.content()).isNotEmpty();
            }
            Assertions.assertThat((Map)response.structuredContent()).isNotNull();
            JsonAssertions.assertThatJson((Object)response.structuredContent()).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_EXTRA_ARRAY_ITEMS, new Option[0]).isObject().isEqualTo(JsonAssertions.json((Object)"{\"result\":5.0,\"operation\":\"2 + 3\",\"timestamp\":\"2024-01-01T10:00:00Z\"}"));
        }
        finally {
            mcpServer.closeGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputValidationFailure(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("result", Map.of("type", "number"), "operation", Map.of("type", "string")), "required", List.of("result", "operation"));
        McpSchema.Tool calculatorTool = McpSchema.Tool.builder().name("calculator").description("Performs mathematical calculations").outputSchema(outputSchema).build();
        McpStatelessServerFeatures.SyncToolSpecification tool = McpStatelessServerFeatures.SyncToolSpecification.builder().tool(calculatorTool).callHandler((exchange, request) -> McpSchema.CallToolResult.builder().addTextContent("Invalid calculation").structuredContent(Map.of("result", "not-a-number", "extra", "field")).build()).build();
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpStatelessServerFeatures.SyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("calculator", Map.of("expression", "2 + 3")));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isTrue();
            Assertions.assertThat((List)response.content()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.Content)response.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            String errorMessage = ((McpSchema.TextContent)response.content().get(0)).text();
            Assertions.assertThat((String)errorMessage).contains(new CharSequence[]{"Validation failed"});
        }
        finally {
            mcpServer.closeGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputMissingStructuredContent(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("result", Map.of("type", "number")), "required", List.of("result"));
        McpSchema.Tool calculatorTool = McpSchema.Tool.builder().name("calculator").description("Performs mathematical calculations").outputSchema(outputSchema).build();
        McpStatelessServerFeatures.SyncToolSpecification tool = McpStatelessServerFeatures.SyncToolSpecification.builder().tool(calculatorTool).callHandler((exchange, request) -> McpSchema.CallToolResult.builder().addTextContent("Calculation completed").build()).build();
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpStatelessServerFeatures.SyncToolSpecification[]{tool}).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("calculator", Map.of("expression", "2 + 3")));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isTrue();
            Assertions.assertThat((List)response.content()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.Content)response.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            String errorMessage = ((McpSchema.TextContent)response.content().get(0)).text();
            Assertions.assertThat((String)errorMessage).isEqualTo("Response missing structured content which is expected when calling tool with non-empty outputSchema");
        }
        finally {
            mcpServer.closeGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"httpclient", "webflux"})
    void testStructuredOutputRuntimeToolAddition(String clientType) {
        McpClient.SyncSpec clientBuilder = this.clientBuilders.get(clientType);
        McpStatelessSyncServer mcpServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        try (McpSyncClient mcpClient = clientBuilder.build();){
            McpSchema.InitializeResult initResult = mcpClient.initialize();
            Assertions.assertThat((Object)initResult).isNotNull();
            Assertions.assertThat((List)mcpClient.listTools().tools()).isEmpty();
            Map<String, List<String>> outputSchema = Map.of("type", "object", "properties", Map.of("message", Map.of("type", "string"), "count", Map.of("type", "integer")), "required", List.of("message", "count"));
            McpSchema.Tool dynamicTool = McpSchema.Tool.builder().name("dynamic-tool").description("Dynamically added tool").outputSchema(outputSchema).build();
            McpStatelessServerFeatures.SyncToolSpecification toolSpec = McpStatelessServerFeatures.SyncToolSpecification.builder().tool(dynamicTool).callHandler((exchange, request) -> {
                int count = request.arguments().getOrDefault("count", 1);
                return McpSchema.CallToolResult.builder().addTextContent("Dynamic tool executed " + count + " times").structuredContent(Map.of("message", "Dynamic execution", "count", count)).build();
            }).build();
            mcpServer.addTool(toolSpec);
            Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((List)mcpClient.listTools().tools()).hasSize(1));
            McpSchema.ListToolsResult toolsList = mcpClient.listTools();
            Assertions.assertThat((List)toolsList.tools()).hasSize(1);
            Assertions.assertThat((String)((McpSchema.Tool)toolsList.tools().get(0)).name()).isEqualTo("dynamic-tool");
            McpSchema.CallToolResult response = mcpClient.callTool(new McpSchema.CallToolRequest("dynamic-tool", Map.of("count", 3)));
            Assertions.assertThat((Object)response).isNotNull();
            Assertions.assertThat((Boolean)response.isError()).isFalse();
            Assertions.assertThat((List)response.content()).hasSize(1);
            Assertions.assertThat((Object)((McpSchema.Content)response.content().get(0))).isInstanceOf(McpSchema.TextContent.class);
            Assertions.assertThat((String)((McpSchema.TextContent)response.content().get(0)).text()).isEqualTo("Dynamic tool executed 3 times");
            Assertions.assertThat((Map)response.structuredContent()).isNotNull();
            JsonAssertions.assertThatJson((Object)response.structuredContent()).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(Option.IGNORING_EXTRA_ARRAY_ITEMS, new Option[0]).isObject().isEqualTo(JsonAssertions.json((Object)"{\"count\":3,\"message\":\"Dynamic execution\"}"));
        }
        finally {
            mcpServer.closeGracefully();
        }
    }

    private double evaluateExpression(String expression) {
        return switch (expression) {
            case "2 + 3" -> 5.0;
            case "10 * 2" -> 20.0;
            case "7 + 8" -> 15.0;
            case "5 + 3" -> 8.0;
            default -> 0.0;
        };
    }
}

