/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.test.StepVerifier;

public abstract class AbstractMcpSyncClientTests {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMcpSyncClientTests.class);
    private static final String TEST_MESSAGE = "Hello MCP Spring AI!";
    static final Object DUMMY_RETURN_VALUE = new Object();

    protected abstract McpClientTransport createMcpTransport();

    protected void onStart() {
    }

    protected void onClose() {
    }

    protected Duration getRequestTimeout() {
        return Duration.ofSeconds(14L);
    }

    protected Duration getInitializationTimeout() {
        return Duration.ofSeconds(2L);
    }

    McpSyncClient client(McpClientTransport transport) {
        return this.client(transport, Function.identity());
    }

    McpSyncClient client(McpClientTransport transport, Function<McpClient.SyncSpec, McpClient.SyncSpec> customizer) {
        AtomicReference client = new AtomicReference();
        Assertions.assertThatCode(() -> {
            McpClient.SyncSpec builder = McpClient.sync((McpClientTransport)transport).requestTimeout(this.getRequestTimeout()).initializationTimeout(this.getInitializationTimeout()).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).build());
            builder = (McpClient.SyncSpec)customizer.apply(builder);
            client.set(builder.build());
        }).doesNotThrowAnyException();
        return (McpSyncClient)client.get();
    }

    void withClient(McpClientTransport transport, Consumer<McpSyncClient> c) {
        this.withClient(transport, Function.identity(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withClient(McpClientTransport transport, Function<McpClient.SyncSpec, McpClient.SyncSpec> customizer, Consumer<McpSyncClient> c) {
        McpSyncClient client = this.client(transport, customizer);
        try {
            c.accept(client);
        }
        finally {
            Assertions.assertThat((boolean)client.closeGracefully()).isTrue();
        }
    }

    @BeforeEach
    void setUp() {
        this.onStart();
    }

    @AfterEach
    void tearDown() {
        this.onClose();
    }

    <T> void verifyNotificationSucceedsWithImplicitInitialization(Consumer<McpSyncClient> operation, String action) {
        this.verifyCallSucceedsWithImplicitInitialization(client -> {
            operation.accept((McpSyncClient)client);
            return DUMMY_RETURN_VALUE;
        }, action);
    }

    <T> void verifyCallSucceedsWithImplicitInitialization(Function<McpSyncClient, T> blockingOperation, String action) {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> StepVerifier.create((Publisher)Mono.fromSupplier(() -> blockingOperation.apply((McpSyncClient)mcpSyncClient)).subscribeOn(Schedulers.boundedElastic())).expectNextCount(1L).verifyComplete());
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.sync((McpClientTransport)this.createMcpTransport()).requestTimeout(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Request timeout must not be null");
    }

    @Test
    void testListToolsWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.listTools(McpSchema.FIRST_PAGE), "listing tools");
    }

    @Test
    void testListTools() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListToolsResult tools = mcpSyncClient.listTools(McpSchema.FIRST_PAGE);
            ((ObjectAssert)Assertions.assertThat((Object)tools).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
                McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
                Assertions.assertThat((String)firstTool.name()).isNotNull();
                Assertions.assertThat((String)firstTool.description()).isNotNull();
            }});
        });
    }

    @Test
    void testListAllTools() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListToolsResult tools = mcpSyncClient.listTools();
            ((ObjectAssert)Assertions.assertThat((Object)tools).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
                McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
                Assertions.assertThat((String)firstTool.name()).isNotNull();
                Assertions.assertThat((String)firstTool.description()).isNotNull();
            }});
        });
    }

    @Test
    void testCallToolsWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.callTool(new McpSchema.CallToolRequest("add", Map.of("a", 3, "b", 4))), "calling tools");
    }

    @Test
    void testCallTools() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.CallToolResult toolResult = mcpSyncClient.callTool(new McpSchema.CallToolRequest("add", Map.of("a", 3, "b", 4)));
            ((ObjectAssert)Assertions.assertThat((Object)toolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.content()).hasSize(1);
                McpSchema.TextContent content = (McpSchema.TextContent)result.content().get(0);
                Assertions.assertThat((Object)content).isNotNull();
                Assertions.assertThat((String)content.text()).isNotNull();
                Assertions.assertThat((String)content.text()).contains(new CharSequence[]{"7"});
            }});
        });
    }

    @Test
    void testPingWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.ping(), "pinging the server");
    }

    @Test
    void testPing() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            Assertions.assertThatCode(() -> mcpSyncClient.ping()).doesNotThrowAnyException();
        });
    }

    @Test
    void testCallToolWithoutInitialization() {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", TEST_MESSAGE));
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.callTool(callToolRequest), "calling tools");
    }

    @Test
    void testCallTool() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", TEST_MESSAGE));
            McpSchema.CallToolResult callToolResult = mcpSyncClient.callTool(callToolRequest);
            ((ObjectAssert)Assertions.assertThat((Object)callToolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.content()).isNotNull();
                Assertions.assertThat((Boolean)result.isError()).isNull();
            }});
        });
    }

    @Test
    void testCallToolWithInvalidTool() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.CallToolRequest invalidRequest = new McpSchema.CallToolRequest("nonexistent_tool", Map.of("message", TEST_MESSAGE));
            Assertions.assertThatThrownBy(() -> mcpSyncClient.callTool(invalidRequest)).isInstanceOf(Exception.class);
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"success", "error", "debug"})
    void testCallToolWithMessageAnnotations(String messageType) {
        McpClientTransport transport = this.createMcpTransport();
        this.withClient(transport, client -> {
            client.initialize();
            McpSchema.CallToolResult result = client.callTool(new McpSchema.CallToolRequest("annotatedMessage", Map.of("messageType", messageType, "includeImage", true)));
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Boolean)result.isError()).isNotEqualTo(true);
            Assertions.assertThat((List)result.content()).isNotEmpty();
            Assertions.assertThat((List)result.content()).allSatisfy(content -> {
                block4 : switch (content.type()) {
                    case "text": {
                        McpSchema.TextContent textContent = (McpSchema.TextContent)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.TextContent.class, (Object)content);
                        Assertions.assertThat((String)textContent.text()).isNotEmpty();
                        Assertions.assertThat((Object)textContent.annotations()).isNotNull();
                        switch (messageType) {
                            case "error": {
                                Assertions.assertThat((Double)textContent.annotations().priority()).isEqualTo(1.0);
                                Assertions.assertThat((List)textContent.annotations().audience()).containsOnly((Object[])new McpSchema.Role[]{McpSchema.Role.USER, McpSchema.Role.ASSISTANT});
                                break block4;
                            }
                            case "success": {
                                Assertions.assertThat((Double)textContent.annotations().priority()).isEqualTo(0.7);
                                Assertions.assertThat((List)textContent.annotations().audience()).containsExactly((Object[])new McpSchema.Role[]{McpSchema.Role.USER});
                                break block4;
                            }
                            case "debug": {
                                Assertions.assertThat((Double)textContent.annotations().priority()).isEqualTo(0.3);
                                Assertions.assertThat((List)textContent.annotations().audience()).containsExactly((Object[])new McpSchema.Role[]{McpSchema.Role.ASSISTANT});
                                break block4;
                            }
                        }
                        throw new IllegalStateException("Unexpected value: " + content.type());
                    }
                    case "image": {
                        McpSchema.ImageContent imageContent = (McpSchema.ImageContent)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.ImageContent.class, (Object)content);
                        Assertions.assertThat((String)imageContent.data()).isNotEmpty();
                        Assertions.assertThat((Object)imageContent.annotations()).isNotNull();
                        Assertions.assertThat((Double)imageContent.annotations().priority()).isEqualTo(0.5);
                        Assertions.assertThat((List)imageContent.annotations().audience()).containsExactly((Object[])new McpSchema.Role[]{McpSchema.Role.USER});
                        break;
                    }
                    default: {
                        Assertions.fail((String)("Unexpected content type: " + content.type()));
                    }
                }
            });
        });
    }

    @Test
    void testRootsListChangedWithoutInitialization() {
        this.verifyNotificationSucceedsWithImplicitInitialization(client -> client.rootsListChangedNotification(), "sending roots list changed notification");
    }

    @Test
    void testRootsListChanged() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            Assertions.assertThatCode(() -> mcpSyncClient.rootsListChangedNotification()).doesNotThrowAnyException();
        });
    }

    @Test
    void testListResourcesWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.listResources(McpSchema.FIRST_PAGE), "listing resources");
    }

    @Test
    void testListResources() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListResourcesResult resources = mcpSyncClient.listResources(McpSchema.FIRST_PAGE);
            ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.resources()).isNotNull();
                if (!result.resources().isEmpty()) {
                    McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                    Assertions.assertThat((String)firstResource.uri()).isNotNull();
                    Assertions.assertThat((String)firstResource.name()).isNotNull();
                }
            }});
        });
    }

    @Test
    void testListAllResources() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListResourcesResult resources = mcpSyncClient.listResources();
            ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.resources()).isNotNull();
                if (!result.resources().isEmpty()) {
                    McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                    Assertions.assertThat((String)firstResource.uri()).isNotNull();
                    Assertions.assertThat((String)firstResource.name()).isNotNull();
                }
            }});
        });
    }

    @Test
    void testClientSessionState() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThat((Object)mcpSyncClient).isNotNull());
    }

    @Test
    void testInitializeWithRootsListProviders() {
        this.withClient(this.createMcpTransport(), builder -> builder.roots(new McpSchema.Root[]{new McpSchema.Root("file:///test/path", "test-root")}), mcpSyncClient -> Assertions.assertThatCode(() -> {
            mcpSyncClient.initialize();
            mcpSyncClient.close();
        }).doesNotThrowAnyException());
    }

    @Test
    void testAddRoot() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.Root newRoot = new McpSchema.Root("file:///new/test/path", "new-test-root");
            Assertions.assertThatCode(() -> mcpSyncClient.addRoot(newRoot)).doesNotThrowAnyException();
        });
    }

    @Test
    void testAddRootWithNullValue() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThatThrownBy(() -> mcpSyncClient.addRoot(null)).hasMessageContaining("Root must not be null"));
    }

    @Test
    void testRemoveRoot() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.Root root = new McpSchema.Root("file:///test/path/to/remove", "root-to-remove");
            Assertions.assertThatCode(() -> {
                mcpSyncClient.addRoot(root);
                mcpSyncClient.removeRoot(root.uri());
            }).doesNotThrowAnyException();
        });
    }

    @Test
    void testRemoveNonExistentRoot() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThatThrownBy(() -> mcpSyncClient.removeRoot("nonexistent-uri")).hasMessageContaining("Root with uri 'nonexistent-uri' not found"));
    }

    @Test
    void testReadResourceWithoutInitialization() {
        AtomicReference resources = new AtomicReference();
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            resources.set(mcpSyncClient.listResources().resources());
        });
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.readResource((McpSchema.Resource)((List)resources.get()).get(0)), "reading resources");
    }

    @Test
    void testReadResource() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            int readResourceCount = 0;
            mcpSyncClient.initialize();
            McpSchema.ListResourcesResult resources = mcpSyncClient.listResources(null);
            Assertions.assertThat((Object)resources).isNotNull();
            Assertions.assertThat((List)resources.resources()).isNotNull();
            ((ListAssert)Assertions.assertThat((List)resources.resources()).isNotNull()).isNotEmpty();
            for (McpSchema.Resource resource : resources.resources()) {
                McpSchema.ReadResourceResult result = mcpSyncClient.readResource(resource);
                Assertions.assertThat((Object)result).isNotNull();
                ((ListAssert)Assertions.assertThat((List)result.contents()).isNotNull()).isNotEmpty();
                ++readResourceCount;
                block9: for (McpSchema.ResourceContents content : result.contents()) {
                    McpSchema.TextResourceContents textContent;
                    Assertions.assertThat((Object)content).isNotNull();
                    ((AbstractStringAssert)Assertions.assertThat((String)content.uri()).isNotNull()).isNotEmpty();
                    ((AbstractStringAssert)Assertions.assertThat((String)content.mimeType()).isNotNull()).isNotEmpty();
                    switch (content.mimeType()) {
                        case "text/plain": {
                            textContent = (McpSchema.TextResourceContents)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.TextResourceContents.class, (Object)content);
                            ((AbstractStringAssert)Assertions.assertThat((String)textContent.text()).isNotNull()).isNotEmpty();
                            Assertions.assertThat((String)textContent.uri()).isEqualTo(resource.uri());
                            continue block9;
                        }
                        case "application/octet-stream": {
                            McpSchema.BlobResourceContents blobContent = (McpSchema.BlobResourceContents)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.BlobResourceContents.class, (Object)content);
                            ((AbstractStringAssert)Assertions.assertThat((String)blobContent.blob()).isNotNull()).isNotEmpty();
                            Assertions.assertThat((String)blobContent.uri()).isEqualTo(resource.uri());
                            Assertions.assertThat((String)blobContent.blob()).matches((CharSequence)"^[A-Za-z0-9+/]*={0,2}$");
                            continue block9;
                        }
                    }
                    logger.warn("Warning: Encountered unexpected MIME type: {} for resource: {}", (Object)content.mimeType(), (Object)resource.uri());
                    if (content instanceof McpSchema.TextResourceContents) {
                        textContent = (McpSchema.TextResourceContents)content;
                        Assertions.assertThat((String)textContent.text()).isNotNull();
                        continue;
                    }
                    if (!(content instanceof McpSchema.BlobResourceContents)) continue;
                    McpSchema.BlobResourceContents blobContent = (McpSchema.BlobResourceContents)content;
                    Assertions.assertThat((String)blobContent.blob()).isNotNull();
                }
            }
            Assertions.assertThat((int)readResourceCount).isEqualTo(10);
        });
    }

    @Test
    void testListResourceTemplatesWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.listResourceTemplates(McpSchema.FIRST_PAGE), "listing resource templates");
    }

    @Test
    void testListResourceTemplates() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListResourceTemplatesResult result = mcpSyncClient.listResourceTemplates(McpSchema.FIRST_PAGE);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
        });
    }

    @Test
    void testListAllResourceTemplates() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            McpSchema.ListResourceTemplatesResult result = mcpSyncClient.listResourceTemplates();
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
        });
    }

    void testResourceSubscription() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            McpSchema.ListResourcesResult resources = mcpSyncClient.listResources(null);
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                Assertions.assertThatCode(() -> mcpSyncClient.subscribeResource(new McpSchema.SubscribeRequest(firstResource.uri()))).doesNotThrowAnyException();
                Assertions.assertThatCode(() -> mcpSyncClient.unsubscribeResource(new McpSchema.UnsubscribeRequest(firstResource.uri()))).doesNotThrowAnyException();
            }
        });
    }

    @Test
    void testNotificationHandlers() {
        AtomicBoolean toolsNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean resourcesNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean promptsNotificationReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.toolsChangeConsumer(tools -> toolsNotificationReceived.set(true)).resourcesChangeConsumer(resources -> resourcesNotificationReceived.set(true)).promptsChangeConsumer(prompts -> promptsNotificationReceived.set(true)), client -> Assertions.assertThatCode(() -> {
            client.initialize();
            client.close();
        }).doesNotThrowAnyException());
    }

    @Test
    void testLoggingLevelsWithoutInitialization() {
        this.verifyNotificationSucceedsWithImplicitInitialization(client -> client.setLoggingLevel(McpSchema.LoggingLevel.DEBUG), "setting logging level");
    }

    @Test
    void testLoggingLevels() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> {
            mcpSyncClient.initialize();
            for (McpSchema.LoggingLevel level : McpSchema.LoggingLevel.values()) {
                Assertions.assertThatCode(() -> mcpSyncClient.setLoggingLevel(level)).doesNotThrowAnyException();
            }
        });
    }

    @Test
    void testLoggingConsumer() {
        AtomicBoolean logReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.requestTimeout(this.getRequestTimeout()).loggingConsumer(notification -> logReceived.set(true)), client -> Assertions.assertThatCode(() -> {
            client.initialize();
            client.close();
        }).doesNotThrowAnyException());
    }

    @Test
    void testLoggingWithNullNotification() {
        this.withClient(this.createMcpTransport(), mcpSyncClient -> Assertions.assertThatThrownBy(() -> mcpSyncClient.setLoggingLevel(null)).hasMessageContaining("Logging level must not be null"));
    }

    @Test
    void testSampling() {
        McpClientTransport transport = this.createMcpTransport();
        String message = "Hello, world!";
        String response = "Goodbye, world!";
        int maxTokens = 100;
        AtomicReference receivedPrompt = new AtomicReference();
        AtomicReference receivedMessage = new AtomicReference();
        AtomicInteger receivedMaxTokens = new AtomicInteger();
        this.withClient(transport, spec -> spec.capabilities(McpSchema.ClientCapabilities.builder().sampling().build()).sampling(request -> {
            McpSchema.TextContent messageText = (McpSchema.TextContent)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.TextContent.class, (Object)((McpSchema.SamplingMessage)request.messages().get(0)).content());
            receivedPrompt.set(request.systemPrompt());
            receivedMessage.set(messageText.text());
            receivedMaxTokens.set(request.maxTokens());
            return new McpSchema.CreateMessageResult(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Goodbye, world!"), "modelId", McpSchema.CreateMessageResult.StopReason.END_TURN);
        }), client -> {
            client.initialize();
            McpSchema.CallToolResult result = client.callTool(new McpSchema.CallToolRequest("sampleLLM", Map.of("prompt", "Hello, world!", "maxTokens", 100)));
            Assertions.assertThat((List)result.content()).hasAtLeastOneElementOfType(McpSchema.TextContent.class);
            Assertions.assertThat((List)result.content()).allSatisfy(content -> {
                if (!(content instanceof McpSchema.TextContent)) {
                    return;
                }
                McpSchema.TextContent text = (McpSchema.TextContent)content;
                Assertions.assertThat((String)text.text()).endsWith((CharSequence)"Goodbye, world!");
            });
            Assertions.assertThat((String)((String)receivedPrompt.get())).isNotEmpty();
            Assertions.assertThat((String)((String)receivedMessage.get())).endsWith((CharSequence)"Hello, world!");
            Assertions.assertThat((int)receivedMaxTokens.get()).isEqualTo(100);
        });
    }

    @Test
    void testProgressConsumer() {
        AtomicInteger progressNotificationCount = new AtomicInteger(0);
        CopyOnWriteArrayList receivedNotifications = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(2);
        this.withClient(this.createMcpTransport(), builder -> builder.progressConsumer(notification -> {
            System.out.println("Received progress notification: " + String.valueOf(notification));
            receivedNotifications.add(notification);
            progressNotificationCount.incrementAndGet();
            latch.countDown();
        }), client -> {
            client.initialize();
            McpSchema.CallToolRequest request = McpSchema.CallToolRequest.builder().name("longRunningOperation").arguments(Map.of("duration", 1, "steps", 2)).progressToken("test-token").build();
            McpSchema.CallToolResult result = client.callTool(request);
            Assertions.assertThat((Object)result).isNotNull();
            try {
                latch.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Assertions.assertThat((int)progressNotificationCount.get()).isEqualTo(2);
            Assertions.assertThat((List)receivedNotifications).isNotEmpty();
            Assertions.assertThat((String)((McpSchema.ProgressNotification)receivedNotifications.get(0)).progressToken()).isEqualTo("test-token");
        });
    }
}

