/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.json.schema.jackson3;

import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.Dialects;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.json.JsonMapper;

public class DefaultJsonSchemaValidator
implements JsonSchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJsonSchemaValidator.class);
    private final JsonMapper jsonMapper;
    private final SchemaRegistry schemaFactory;
    private final ConcurrentHashMap<String, Schema> schemaCache;

    public DefaultJsonSchemaValidator() {
        this(JsonMapper.shared());
    }

    public DefaultJsonSchemaValidator(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.schemaFactory = SchemaRegistry.withDialect((Dialect)Dialects.getDraft202012());
        this.schemaCache = new ConcurrentHashMap();
    }

    public JsonSchemaValidator.ValidationResponse validate(Map<String, Object> schema, Object structuredContent) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null");
        }
        if (structuredContent == null) {
            throw new IllegalArgumentException("Structured content must not be null");
        }
        try {
            JsonNode jsonStructuredOutput = structuredContent instanceof String ? this.jsonMapper.readTree((String)structuredContent) : this.jsonMapper.valueToTree(structuredContent);
            List validationResult = this.getOrCreateJsonSchema(schema).validate(jsonStructuredOutput);
            if (!validationResult.isEmpty()) {
                return JsonSchemaValidator.ValidationResponse.asInvalid((String)("Validation failed: structuredContent does not match tool outputSchema. Validation errors: " + String.valueOf(validationResult)));
            }
            return JsonSchemaValidator.ValidationResponse.asValid((String)jsonStructuredOutput.toString());
        }
        catch (JacksonException e) {
            logger.error("Failed to validate CallToolResult: Error parsing schema: {}", (Throwable)e);
            return JsonSchemaValidator.ValidationResponse.asInvalid((String)("Error parsing tool JSON Schema: " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error("Failed to validate CallToolResult: Unexpected error: {}", (Throwable)e);
            return JsonSchemaValidator.ValidationResponse.asInvalid((String)("Unexpected validation error: " + e.getMessage()));
        }
    }

    private Schema getOrCreateJsonSchema(Map<String, Object> schema) throws JacksonException {
        String cacheKey = this.generateCacheKey(schema);
        Schema cachedSchema = this.schemaCache.get(cacheKey);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        Schema newSchema = this.createJsonSchema(schema);
        Schema existingSchema = this.schemaCache.putIfAbsent(cacheKey, newSchema);
        return existingSchema != null ? existingSchema : newSchema;
    }

    private Schema createJsonSchema(Map<String, Object> schema) throws JacksonException {
        JsonNode schemaNode = this.jsonMapper.valueToTree(schema);
        if (schemaNode == null) {
            throw new JacksonException("Failed to convert schema to JsonNode"){};
        }
        return this.schemaFactory.getSchema(schemaNode);
    }

    protected String generateCacheKey(Map<String, Object> schema) {
        if (schema.containsKey("$id")) {
            return String.valueOf(schema.get("$id"));
        }
        return String.valueOf(schema.hashCode());
    }

    public void clearCache() {
        this.schemaCache.clear();
    }

    public int getCacheSize() {
        return this.schemaCache.size();
    }
}

