/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClientFeatures;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public interface McpClient {
    public static SyncSpec sync(McpClientTransport transport) {
        return new SyncSpec(transport);
    }

    public static AsyncSpec async(McpClientTransport transport) {
        return new AsyncSpec(transport);
    }

    public static class SyncSpec {
        private final McpClientTransport transport;
        private Duration requestTimeout = Duration.ofSeconds(20L);
        private Duration initializationTimeout = Duration.ofSeconds(20L);
        private McpSchema.ClientCapabilities capabilities;
        private McpSchema.Implementation clientInfo = new McpSchema.Implementation("Java SDK MCP Client", "1.0.0");
        private final Map<String, McpSchema.Root> roots = new HashMap<String, McpSchema.Root>();
        private final List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Tool>>>();
        private final List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers = new ArrayList<Consumer<List<McpSchema.Resource>>>();
        private final List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers = new ArrayList<Consumer<List<McpSchema.ResourceContents>>>();
        private final List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers = new ArrayList<Consumer<List<McpSchema.Prompt>>>();
        private final List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers = new ArrayList<Consumer<McpSchema.LoggingMessageNotification>>();
        private final List<Consumer<McpSchema.ProgressNotification>> progressConsumers = new ArrayList<Consumer<McpSchema.ProgressNotification>>();
        private Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler;
        private Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler;
        private Supplier<McpTransportContext> contextProvider = () -> McpTransportContext.EMPTY;
        private JsonSchemaValidator jsonSchemaValidator;
        private boolean enableCallToolSchemaCaching = false;

        private SyncSpec(McpClientTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public SyncSpec requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public SyncSpec initializationTimeout(Duration initializationTimeout) {
            Assert.notNull(initializationTimeout, "Initialization timeout must not be null");
            this.initializationTimeout = initializationTimeout;
            return this;
        }

        public SyncSpec capabilities(McpSchema.ClientCapabilities capabilities) {
            Assert.notNull(capabilities, "Capabilities must not be null");
            this.capabilities = capabilities;
            return this;
        }

        public SyncSpec clientInfo(McpSchema.Implementation clientInfo) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            return this;
        }

        public SyncSpec roots(List<McpSchema.Root> roots) {
            Assert.notNull(roots, "Roots must not be null");
            for (McpSchema.Root root : roots) {
                this.roots.put(root.uri(), root);
            }
            return this;
        }

        public SyncSpec roots(McpSchema.Root ... roots) {
            Assert.notNull(roots, "Roots must not be null");
            for (McpSchema.Root root : roots) {
                this.roots.put(root.uri(), root);
            }
            return this;
        }

        public SyncSpec sampling(Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
            Assert.notNull(samplingHandler, "Sampling handler must not be null");
            this.samplingHandler = samplingHandler;
            return this;
        }

        public SyncSpec elicitation(Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler) {
            Assert.notNull(elicitationHandler, "Elicitation handler must not be null");
            this.elicitationHandler = elicitationHandler;
            return this;
        }

        public SyncSpec toolsChangeConsumer(Consumer<List<McpSchema.Tool>> toolsChangeConsumer) {
            Assert.notNull(toolsChangeConsumer, "Tools change consumer must not be null");
            this.toolsChangeConsumers.add(toolsChangeConsumer);
            return this;
        }

        public SyncSpec resourcesChangeConsumer(Consumer<List<McpSchema.Resource>> resourcesChangeConsumer) {
            Assert.notNull(resourcesChangeConsumer, "Resources change consumer must not be null");
            this.resourcesChangeConsumers.add(resourcesChangeConsumer);
            return this;
        }

        public SyncSpec promptsChangeConsumer(Consumer<List<McpSchema.Prompt>> promptsChangeConsumer) {
            Assert.notNull(promptsChangeConsumer, "Prompts change consumer must not be null");
            this.promptsChangeConsumers.add(promptsChangeConsumer);
            return this;
        }

        public SyncSpec loggingConsumer(Consumer<McpSchema.LoggingMessageNotification> loggingConsumer) {
            Assert.notNull(loggingConsumer, "Logging consumer must not be null");
            this.loggingConsumers.add(loggingConsumer);
            return this;
        }

        public SyncSpec loggingConsumers(List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers) {
            Assert.notNull(loggingConsumers, "Logging consumers must not be null");
            this.loggingConsumers.addAll(loggingConsumers);
            return this;
        }

        public SyncSpec progressConsumer(Consumer<McpSchema.ProgressNotification> progressConsumer) {
            Assert.notNull(progressConsumer, "Progress consumer must not be null");
            this.progressConsumers.add(progressConsumer);
            return this;
        }

        public SyncSpec progressConsumers(List<Consumer<McpSchema.ProgressNotification>> progressConsumers) {
            Assert.notNull(progressConsumers, "Progress consumers must not be null");
            this.progressConsumers.addAll(progressConsumers);
            return this;
        }

        public SyncSpec transportContextProvider(Supplier<McpTransportContext> contextProvider) {
            this.contextProvider = contextProvider;
            return this;
        }

        public SyncSpec jsonSchemaValidator(JsonSchemaValidator jsonSchemaValidator) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            this.jsonSchemaValidator = jsonSchemaValidator;
            return this;
        }

        public SyncSpec enableCallToolSchemaCaching(boolean enableCallToolSchemaCaching) {
            this.enableCallToolSchemaCaching = enableCallToolSchemaCaching;
            return this;
        }

        public McpSyncClient build() {
            McpClientFeatures.Sync syncFeatures = new McpClientFeatures.Sync(this.clientInfo, this.capabilities, this.roots, this.toolsChangeConsumers, this.resourcesChangeConsumers, this.resourcesUpdateConsumers, this.promptsChangeConsumers, this.loggingConsumers, this.progressConsumers, this.samplingHandler, this.elicitationHandler, this.enableCallToolSchemaCaching);
            McpClientFeatures.Async asyncFeatures = McpClientFeatures.Async.fromSync(syncFeatures);
            return new McpSyncClient(new McpAsyncClient(this.transport, this.requestTimeout, this.initializationTimeout, this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault(), asyncFeatures), this.contextProvider);
        }
    }

    public static class AsyncSpec {
        private final McpClientTransport transport;
        private Duration requestTimeout = Duration.ofSeconds(20L);
        private Duration initializationTimeout = Duration.ofSeconds(20L);
        private McpSchema.ClientCapabilities capabilities;
        private McpSchema.Implementation clientInfo = new McpSchema.Implementation("Spring AI MCP Client", "0.3.1");
        private final Map<String, McpSchema.Root> roots = new HashMap<String, McpSchema.Root>();
        private final List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>();
        private final List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>();
        private final List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers = new ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>>();
        private final List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>();
        private final List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>();
        private final List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers = new ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>>();
        private Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler;
        private Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler;
        private JsonSchemaValidator jsonSchemaValidator;
        private boolean enableCallToolSchemaCaching = false;

        private AsyncSpec(McpClientTransport transport) {
            Assert.notNull(transport, "Transport must not be null");
            this.transport = transport;
        }

        public AsyncSpec requestTimeout(Duration requestTimeout) {
            Assert.notNull(requestTimeout, "Request timeout must not be null");
            this.requestTimeout = requestTimeout;
            return this;
        }

        public AsyncSpec initializationTimeout(Duration initializationTimeout) {
            Assert.notNull(initializationTimeout, "Initialization timeout must not be null");
            this.initializationTimeout = initializationTimeout;
            return this;
        }

        public AsyncSpec capabilities(McpSchema.ClientCapabilities capabilities) {
            Assert.notNull(capabilities, "Capabilities must not be null");
            this.capabilities = capabilities;
            return this;
        }

        public AsyncSpec clientInfo(McpSchema.Implementation clientInfo) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            return this;
        }

        public AsyncSpec roots(List<McpSchema.Root> roots) {
            Assert.notNull(roots, "Roots must not be null");
            for (McpSchema.Root root : roots) {
                this.roots.put(root.uri(), root);
            }
            return this;
        }

        public AsyncSpec roots(McpSchema.Root ... roots) {
            Assert.notNull(roots, "Roots must not be null");
            for (McpSchema.Root root : roots) {
                this.roots.put(root.uri(), root);
            }
            return this;
        }

        public AsyncSpec sampling(Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler) {
            Assert.notNull(samplingHandler, "Sampling handler must not be null");
            this.samplingHandler = samplingHandler;
            return this;
        }

        public AsyncSpec elicitation(Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler) {
            Assert.notNull(elicitationHandler, "Elicitation handler must not be null");
            this.elicitationHandler = elicitationHandler;
            return this;
        }

        public AsyncSpec toolsChangeConsumer(Function<List<McpSchema.Tool>, Mono<Void>> toolsChangeConsumer) {
            Assert.notNull(toolsChangeConsumer, "Tools change consumer must not be null");
            this.toolsChangeConsumers.add(toolsChangeConsumer);
            return this;
        }

        public AsyncSpec resourcesChangeConsumer(Function<List<McpSchema.Resource>, Mono<Void>> resourcesChangeConsumer) {
            Assert.notNull(resourcesChangeConsumer, "Resources change consumer must not be null");
            this.resourcesChangeConsumers.add(resourcesChangeConsumer);
            return this;
        }

        public AsyncSpec resourcesUpdateConsumer(Function<List<McpSchema.ResourceContents>, Mono<Void>> resourcesUpdateConsumer) {
            Assert.notNull(resourcesUpdateConsumer, "Resources update consumer must not be null");
            this.resourcesUpdateConsumers.add(resourcesUpdateConsumer);
            return this;
        }

        public AsyncSpec promptsChangeConsumer(Function<List<McpSchema.Prompt>, Mono<Void>> promptsChangeConsumer) {
            Assert.notNull(promptsChangeConsumer, "Prompts change consumer must not be null");
            this.promptsChangeConsumers.add(promptsChangeConsumer);
            return this;
        }

        public AsyncSpec loggingConsumer(Function<McpSchema.LoggingMessageNotification, Mono<Void>> loggingConsumer) {
            Assert.notNull(loggingConsumer, "Logging consumer must not be null");
            this.loggingConsumers.add(loggingConsumer);
            return this;
        }

        public AsyncSpec loggingConsumers(List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers) {
            Assert.notNull(loggingConsumers, "Logging consumers must not be null");
            this.loggingConsumers.addAll(loggingConsumers);
            return this;
        }

        public AsyncSpec progressConsumer(Function<McpSchema.ProgressNotification, Mono<Void>> progressConsumer) {
            Assert.notNull(progressConsumer, "Progress consumer must not be null");
            this.progressConsumers.add(progressConsumer);
            return this;
        }

        public AsyncSpec progressConsumers(List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers) {
            Assert.notNull(progressConsumers, "Progress consumers must not be null");
            this.progressConsumers.addAll(progressConsumers);
            return this;
        }

        public AsyncSpec jsonSchemaValidator(JsonSchemaValidator jsonSchemaValidator) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            this.jsonSchemaValidator = jsonSchemaValidator;
            return this;
        }

        public AsyncSpec enableCallToolSchemaCaching(boolean enableCallToolSchemaCaching) {
            this.enableCallToolSchemaCaching = enableCallToolSchemaCaching;
            return this;
        }

        public McpAsyncClient build() {
            JsonSchemaValidator jsonSchemaValidator = this.jsonSchemaValidator != null ? this.jsonSchemaValidator : JsonSchemaValidator.getDefault();
            return new McpAsyncClient(this.transport, this.requestTimeout, this.initializationTimeout, jsonSchemaValidator, new McpClientFeatures.Async(this.clientInfo, this.capabilities, this.roots, this.toolsChangeConsumers, this.resourcesChangeConsumers, this.resourcesUpdateConsumers, this.promptsChangeConsumers, this.loggingConsumers, this.progressConsumers, this.samplingHandler, this.elicitationHandler, this.enableCallToolSchemaCaching));
        }
    }
}

