/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionConfig;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.ExecutionContextCustomizer;
import com.networknt.schema.FailFastAssertionException;
import com.networknt.schema.InputFormat;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.InvalidSchemaRefException;
import com.networknt.schema.OutputFormat;
import com.networknt.schema.Result;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaIdValidator;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRegistryConfig;
import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.Validator;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.keyword.TypeValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.path.PathType;
import com.networknt.schema.resource.ClasspathResourceLoader;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.ResourceLoader;
import com.networknt.schema.utils.JsonNodes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Schema
implements Validator {
    private static final long DRAFT_2019_09_VALUE = SpecificationVersion.DRAFT_2019_09.getOrder();
    private final String id;
    private List<KeywordValidator> validators = null;
    private boolean unevaluatedPropertiesPresent = false;
    private boolean unevaluatedItemsPresent = false;
    private boolean validatorsLoaded = false;
    private boolean recursiveAnchor = false;
    protected final JsonNode schemaNode;
    protected final Schema parentSchema;
    protected final SchemaLocation schemaLocation;
    protected final SchemaContext schemaContext;
    protected final boolean suppressSubSchemaRetrieval;
    private static final Comparator<KeywordValidator> VALIDATOR_SORT = (lhs, rhs) -> {
        String rhsName;
        String lhsName = lhs.getKeyword();
        if (lhsName.equals(rhsName = rhs.getKeyword())) {
            return 0;
        }
        if (lhsName.equals("discriminator")) {
            return -1;
        }
        if (rhsName.equals("discriminator")) {
            return 1;
        }
        if (lhsName.equals("type")) {
            return -1;
        }
        if (rhsName.equals("type")) {
            return 1;
        }
        if (lhsName.equals("properties")) {
            return -1;
        }
        if (rhsName.equals("properties")) {
            return 1;
        }
        if (lhsName.equals("patternProperties")) {
            return -1;
        }
        if (rhsName.equals("patternProperties")) {
            return 1;
        }
        if (lhsName.equals("unevaluatedItems")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedItems")) {
            return -1;
        }
        if (lhsName.equals("unevaluatedProperties")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedProperties")) {
            return -1;
        }
        return 0;
    };

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    @Override
    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    public Schema getParentSchema() {
        return this.parentSchema;
    }

    public boolean isSuppressSubSchemaRetrieval() {
        return this.suppressSubSchemaRetrieval;
    }

    protected Schema fetchSubSchemaNode(SchemaContext schemaContext) {
        return this.suppressSubSchemaRetrieval ? null : Schema.obtainSubSchemaNode(this.schemaNode, schemaContext);
    }

    private static Schema obtainSubSchemaNode(JsonNode schemaNode, SchemaContext schemaContext) {
        JsonNode node = schemaNode.get("id");
        if (node == null) {
            return null;
        }
        if (node.equals(schemaNode.get("$schema"))) {
            return null;
        }
        String text = node.textValue();
        if (text == null) {
            return null;
        }
        SchemaLocation schemaLocation = SchemaLocation.of(node.textValue());
        return schemaContext.getSchemaRegistry().getSchema(schemaLocation);
    }

    public void validate(ExecutionContext executionContext, JsonNode node) {
        executionContext.evaluationPath = this.atRoot();
        this.validate(executionContext, node, node, this.atRoot());
    }

    protected NodePath atRoot() {
        if (this.schemaContext.getSchemaRegistryConfig().getPathType().equals((Object)PathType.JSON_POINTER)) {
            return JsonNodePathJsonPointer.getInstance();
        }
        if (this.schemaContext.getSchemaRegistryConfig().getPathType().equals((Object)PathType.LEGACY)) {
            return JsonNodePathLegacy.getInstance();
        }
        if (this.schemaContext.getSchemaRegistryConfig().getPathType().equals((Object)PathType.JSON_PATH)) {
            return JsonNodePathJsonPath.getInstance();
        }
        return new NodePath(this.schemaContext.getSchemaRegistryConfig().getPathType());
    }

    static Schema from(SchemaContext schemaContext, SchemaLocation schemaLocation, JsonNode schemaNode, Schema parent, boolean suppressSubSchemaRetrieval) {
        return new Schema(schemaContext, schemaLocation, schemaNode, parent, suppressSubSchemaRetrieval);
    }

    private boolean hasNoFragment(SchemaLocation schemaLocation) {
        NodePath fragment = this.schemaLocation.getFragment();
        return fragment == null || fragment.getParent() == null && fragment.getNameCount() == 0;
    }

    private static SchemaLocation resolve(SchemaLocation schemaLocation, JsonNode schemaNode, boolean rootSchema, SchemaContext schemaContext) {
        String id = schemaContext.resolveSchemaId(schemaNode);
        if (id != null) {
            String resolve = id;
            int fragment = id.indexOf(35);
            if (fragment != -1 && fragment + 1 < id.length()) {
                resolve = id.substring(0, fragment);
            }
            SchemaLocation result = !"".equals(resolve) ? schemaLocation.resolve(resolve) : schemaLocation;
            SchemaIdValidator validator = schemaContext.getSchemaRegistryConfig().getSchemaIdValidator();
            if (validator != null && !validator.validate(id, rootSchema, schemaLocation, result, schemaContext)) {
                SchemaLocation idSchemaLocation = schemaLocation.append(schemaContext.getDialect().getIdKeyword());
                Error error = ((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)Error.builder().messageKey(KeywordType.ID.getValue())).keyword(KeywordType.ID.getValue())).instanceLocation(idSchemaLocation.getFragment())).arguments(id, schemaContext.getDialect().getIdKeyword(), idSchemaLocation)).schemaLocation(idSchemaLocation)).schemaNode(schemaNode)).messageFormatter(args -> schemaContext.getSchemaRegistryConfig().getMessageSource().getMessage(KeywordType.ID.getValue(), schemaContext.getSchemaRegistryConfig().getLocale(), args))).build();
                throw new InvalidSchemaException(error);
            }
            return result;
        }
        return schemaLocation;
    }

    private Schema(SchemaContext schemaContext, SchemaLocation schemaLocation, JsonNode schemaNode, Schema parent, boolean suppressSubSchemaRetrieval) {
        String dynamicAnchor;
        this.schemaContext = schemaContext;
        this.schemaLocation = Schema.resolve(schemaLocation, schemaNode, parent == null, schemaContext);
        this.schemaNode = schemaNode;
        this.parentSchema = parent;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
        String id = this.schemaContext.resolveSchemaId(this.schemaNode);
        if (id != null) {
            SchemaLocation result = id.indexOf(35) != -1 ? schemaLocation.resolve(id) : this.schemaLocation;
            this.id = this.hasNoFragment(result) ? id : null;
            this.schemaContext.getSchemaResources().putIfAbsent(result != null ? result.toString() : id, this);
        } else if (this.hasNoFragment(schemaLocation)) {
            this.id = schemaLocation.getAbsoluteIri() != null ? schemaLocation.getAbsoluteIri().toString() : "";
            this.schemaContext.getSchemaResources().putIfAbsent(schemaLocation != null ? schemaLocation.toString() : this.id, this);
        } else {
            this.id = null;
        }
        String anchor = this.schemaContext.getDialect().readAnchor(this.schemaNode);
        if (anchor != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.schemaContext.getSchemaResources().putIfAbsent(absoluteIri + "#" + anchor, this);
        }
        if ((dynamicAnchor = this.schemaContext.getDialect().readDynamicAnchor(schemaNode)) != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.schemaContext.getDynamicAnchors().putIfAbsent(absoluteIri + "#" + dynamicAnchor, this);
        }
        this.getValidators();
    }

    protected Schema(List<KeywordValidator> validators, boolean validatorsLoaded, boolean recursiveAnchor, TypeValidator typeValidator, String id, boolean suppressSubSchemaRetrieval, JsonNode schemaNode, SchemaContext schemaContext, Schema parentSchema, SchemaLocation schemaLocation, Map<String, String> errorMessage) {
        this.validators = validators;
        this.validatorsLoaded = validatorsLoaded;
        this.recursiveAnchor = recursiveAnchor;
        this.id = id;
        this.schemaContext = schemaContext;
        this.schemaLocation = schemaLocation;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public boolean hasKeyword(String keyword) {
        return this.schemaNode.has(keyword);
    }

    public JsonNode getRefSchemaNode(String ref) {
        Schema schema = this.findSchemaResourceRoot();
        JsonNode node = schema.getSchemaNode();
        String jsonPointer = ref;
        if (schema.getId() != null && ref.startsWith(schema.getId())) {
            String refValue;
            jsonPointer = refValue = ref.substring(schema.getId().length());
        }
        if (jsonPointer.startsWith("#/")) {
            jsonPointer = jsonPointer.substring(1);
        }
        if (jsonPointer.startsWith("/")) {
            try {
                jsonPointer = URLDecoder.decode(jsonPointer, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            node = node.at(jsonPointer);
            if (node.isMissingNode()) {
                node = this.handleNullNode(ref, schema);
            }
        }
        return node;
    }

    public Schema getRefSchema(NodePath fragment) {
        if (PathType.JSON_POINTER.equals((Object)fragment.getPathType())) {
            return this.getSubSchema(fragment);
        }
        String base = this.getSchemaLocation().getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
        String anchor = base + "#" + fragment;
        Schema result = (Schema)this.schemaContext.getSchemaResources().get(anchor);
        if (result == null) {
            result = (Schema)this.schemaContext.getDynamicAnchors().get(anchor);
        }
        if (result == null) {
            throw new SchemaException("Unable to find anchor " + anchor);
        }
        return result;
    }

    public Schema getSubSchema(NodePath fragment) {
        Schema document;
        Schema parent = document = this.findSchemaResourceRoot();
        Schema subSchema = null;
        JsonNode parentNode = parent.getSchemaNode();
        SchemaLocation schemaLocation = document.getSchemaLocation();
        int nameCount = fragment.getNameCount();
        for (int x = 0; x < nameCount; ++x) {
            Object segment = fragment.getElement(x);
            JsonNode subSchemaNode = this.getNode(parentNode, segment);
            if (subSchemaNode != null) {
                if (segment instanceof Number && parentNode.isArray()) {
                    int index = ((Number)segment).intValue();
                    schemaLocation = schemaLocation.append(index);
                } else {
                    schemaLocation = schemaLocation.append(segment.toString());
                }
                String id = parent.getSchemaContext().resolveSchemaId(subSchemaNode);
                if (id != null || x == nameCount - 1) {
                    parent = subSchema = parent.getSchemaContext().newSchema(schemaLocation, subSchemaNode, parent);
                    schemaLocation = subSchema.getSchemaLocation();
                }
            } else {
                Schema found = document.findSchemaResourceRoot().fetchSubSchemaNode(this.schemaContext);
                if (found != null) {
                    found = found.getSubSchema(fragment);
                }
                if (found == null) {
                    Error error = ((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)Error.builder().keyword(KeywordType.REF.getValue())).messageKey("internal.unresolvedRef")).message("Reference {0} cannot be resolved")).instanceLocation(schemaLocation.getFragment())).schemaLocation(schemaLocation)).evaluationPath(null)).arguments(fragment)).build();
                    throw new InvalidSchemaRefException(error);
                }
                return found;
            }
            parentNode = subSchemaNode;
        }
        return subSchema;
    }

    protected JsonNode getNode(Object propertyOrIndex) {
        return this.getNode(this.schemaNode, propertyOrIndex);
    }

    protected JsonNode getNode(JsonNode node, Object propertyOrIndex) {
        return JsonNodes.get(node, propertyOrIndex);
    }

    public Schema findLexicalRoot() {
        Schema ancestor = this;
        while (ancestor.getId() == null && null != ancestor.getParentSchema()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public Schema findSchemaResourceRoot() {
        Schema ancestor = this;
        while (!ancestor.isSchemaResourceRoot()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public boolean isSchemaResourceRoot() {
        if (this.getId() != null) {
            return true;
        }
        if (this.getParentSchema() == null) {
            return true;
        }
        return !Objects.equals(this.getSchemaLocation().getAbsoluteIri(), this.getParentSchema().getSchemaLocation().getAbsoluteIri());
    }

    public String getId() {
        return this.id;
    }

    public Schema findAncestor() {
        Schema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, Schema schema) {
        Schema subSchema = schema.fetchSubSchemaNode(this.schemaContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private List<KeywordValidator> read(JsonNode schemaNode) {
        ArrayList<KeywordValidator> validators;
        if (schemaNode.isBoolean()) {
            validators = new ArrayList<KeywordValidator>(1);
            if (schemaNode.booleanValue()) {
                KeywordValidator validator = this.schemaContext.newValidator(this.getSchemaLocation().append("true"), "true", schemaNode, this);
                validators.add(validator);
            } else {
                KeywordValidator validator = this.schemaContext.newValidator(this.getSchemaLocation().append("false"), "false", schemaNode, this);
                validators.add(validator);
            }
        } else {
            KeywordValidator refValidator = null;
            Iterator<Map.Entry<String, JsonNode>> iterator = schemaNode.fields();
            validators = new ArrayList(schemaNode.size());
            while (iterator.hasNext()) {
                KeywordValidator validator;
                Map.Entry<String, JsonNode> entry = iterator.next();
                String pname = entry.getKey();
                JsonNode nodeToUse = entry.getValue();
                SchemaLocation schemaPath = this.getSchemaLocation().append(pname);
                if ("$recursiveAnchor".equals(pname)) {
                    if (!nodeToUse.isBoolean()) {
                        Error error = ((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)((Error.Builder)Error.builder().keyword("$recursiveAnchor")).messageKey("internal.invalidRecursiveAnchor")).message("The value of a $recursiveAnchor must be a Boolean literal but is {0}")).instanceLocation(null)).evaluationPath(null)).schemaLocation(schemaPath)).arguments(nodeToUse.getNodeType().toString())).build();
                        throw new SchemaException(error);
                    }
                    this.recursiveAnchor = nodeToUse.booleanValue();
                }
                if ((validator = this.schemaContext.newValidator(schemaPath, pname, nodeToUse, this)) == null) continue;
                validators.add(validator);
                if ("unevaluatedProperties".equals(pname)) {
                    this.unevaluatedPropertiesPresent = true;
                } else if ("unevaluatedItems".equals(pname)) {
                    this.unevaluatedItemsPresent = true;
                }
                if (!"$ref".equals(pname)) continue;
                refValidator = validator;
            }
            if (null != refValidator && (long)this.getSchemaContext().getDialect().getSpecificationVersion().getOrder() < DRAFT_2019_09_VALUE) {
                validators.clear();
                validators.add(refValidator);
            }
        }
        if (validators.size() > 1) {
            Collections.sort(validators, VALIDATOR_SORT);
        }
        return validators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, NodePath instanceLocation) {
        List<KeywordValidator> validators = this.getValidators();
        executionContext.evaluationSchema.addLast(this);
        boolean unevaluatedPropertiesPresent = executionContext.unevaluatedPropertiesPresent;
        boolean unevaluatedItemsPresent = executionContext.unevaluatedItemsPresent;
        if (this.unevaluatedPropertiesPresent) {
            executionContext.unevaluatedPropertiesPresent = this.unevaluatedPropertiesPresent;
        }
        if (this.unevaluatedItemsPresent) {
            executionContext.unevaluatedItemsPresent = this.unevaluatedItemsPresent;
        }
        try {
            List<Annotation> annotations;
            int currentErrors = executionContext.getErrors().size();
            for (KeywordValidator v : validators) {
                executionContext.evaluationPathAddLast(v.getKeyword());
                executionContext.evaluationSchemaPath.addLast(v.getKeyword());
                try {
                    v.validate(executionContext, jsonNode, rootNode, instanceLocation);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    executionContext.evaluationSchemaPath.removeLast();
                }
            }
            if (executionContext.getErrors().size() > currentErrors && (annotations = executionContext.getAnnotations().asMap().get(instanceLocation)) != null) {
                for (Annotation annotation : annotations) {
                    if (!annotation.getEvaluationPath().startsWith(executionContext.getEvaluationPath())) continue;
                    annotation.setValid(false);
                }
            }
        }
        finally {
            executionContext.evaluationSchema.removeLast();
            executionContext.unevaluatedPropertiesPresent = unevaluatedPropertiesPresent;
            executionContext.unevaluatedItemsPresent = unevaluatedItemsPresent;
        }
    }

    public List<Error> validate(JsonNode rootNode) {
        return this.validate(rootNode, OutputFormat.DEFAULT);
    }

    public List<Error> validate(JsonNode rootNode, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public List<Error> validate(JsonNode rootNode, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format) {
        return this.validate(rootNode, format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, (ExecutionContext executionContext, SchemaContext schemaContext) -> executionCustomizer.accept(executionContext));
    }

    public List<Error> validate(String input, InputFormat inputFormat) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT);
    }

    public List<Error> validate(String input, InputFormat inputFormat, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public List<Error> validate(String input, InputFormat inputFormat, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format) {
        return this.validate(this.deserialize(input, inputFormat), format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, (ExecutionContext executionContext, SchemaContext schemaContext) -> executionCustomizer.accept(executionContext));
    }

    public List<Error> validate(AbsoluteIri input, InputFormat inputFormat) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT);
    }

    public List<Error> validate(AbsoluteIri input, InputFormat inputFormat, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public List<Error> validate(AbsoluteIri input, InputFormat inputFormat, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(AbsoluteIri input, InputFormat inputFormat, OutputFormat<T> format) {
        return this.validate(this.deserialize(input, inputFormat), format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(AbsoluteIri input, InputFormat inputFormat, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, executionCustomizer);
    }

    public <T> T validate(AbsoluteIri input, InputFormat inputFormat, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, (ExecutionContext executionContext, SchemaContext schemaContext) -> executionCustomizer.accept(executionContext));
    }

    public List<Error> validate(ExecutionContext executionContext, String input, InputFormat inputFormat) {
        return this.validate(executionContext, this.deserialize(input, inputFormat), OutputFormat.DEFAULT);
    }

    public List<Error> validate(ExecutionContext executionContext, String input, InputFormat inputFormat, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(executionContext, this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public List<Error> validate(ExecutionContext executionContext, String input, InputFormat inputFormat, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(executionContext, this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(ExecutionContext executionContext, String input, InputFormat inputFormat, OutputFormat<T> format) {
        return this.validate(executionContext, this.deserialize(input, inputFormat), format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(ExecutionContext executionContext, String input, InputFormat inputFormat, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(executionContext, this.deserialize(input, inputFormat), format, executionCustomizer);
    }

    public <T> T validate(ExecutionContext executionContext, String input, InputFormat inputFormat, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(executionContext, this.deserialize(input, inputFormat), format, (ExecutionContext execContext, SchemaContext schemaContext) -> executionCustomizer.accept(execContext));
    }

    public <T> T validate(ExecutionContext executionContext, JsonNode node, OutputFormat<T> format) {
        return this.validate(executionContext, node, format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(ExecutionContext executionContext, JsonNode node, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(executionContext, node, format, (ExecutionContext execContext, SchemaContext schemaContext) -> executionCustomizer.accept(execContext));
    }

    public <T> T validate(ExecutionContext executionContext, JsonNode node, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        format.customize(executionContext, this.schemaContext);
        if (executionCustomizer != null) {
            executionCustomizer.customize(executionContext, this.schemaContext);
        }
        try {
            this.validate(executionContext, node);
        }
        catch (FailFastAssertionException e) {
            executionContext.setErrors(e.getErrors());
        }
        return format.format(this, executionContext, this.schemaContext);
    }

    private JsonNode deserialize(String input, InputFormat inputFormat) {
        try {
            return this.getSchemaContext().getSchemaRegistry().readTree(input, inputFormat);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Invalid input", e);
        }
    }

    private JsonNode deserialize(AbsoluteIri input, InputFormat inputFormat) {
        JsonNode jsonNode;
        block9: {
            InputStreamSource result = this.getInputResource(input);
            if (result == null) {
                throw new UncheckedIOException(new FileNotFoundException(input.toString() + " not found"));
            }
            InputStream inputStream = result.getInputStream();
            try {
                jsonNode = this.getSchemaContext().getSchemaRegistry().readTree(inputStream, inputFormat);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Invalid input", e);
                }
            }
            inputStream.close();
        }
        return jsonNode;
    }

    private InputStreamSource getInputResource(AbsoluteIri input) {
        InputStreamSource result = null;
        List<ResourceLoader> resourceLoaders = this.getSchemaContext().getSchemaRegistry().getSchemaLoader().getResourceLoaders();
        for (ResourceLoader loader : resourceLoaders) {
            result = loader.getResource(input);
            if (result == null) continue;
            return result;
        }
        return ClasspathResourceLoader.getInstance().getResource(input);
    }

    public Result walk(ExecutionContext executionContext, JsonNode node, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, executionCustomizer);
    }

    public <T> T walk(ExecutionContext executionContext, JsonNode node, OutputFormat<T> outputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, executionCustomizer);
    }

    public Result walk(ExecutionContext executionContext, JsonNode node, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, executionCustomizer);
    }

    public <T> T walk(ExecutionContext executionContext, JsonNode node, OutputFormat<T> outputFormat, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, executionCustomizer);
    }

    public Result walk(ExecutionContext executionContext, JsonNode node, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, (ExecutionContextCustomizer)null);
    }

    public Result walk(ExecutionContext executionContext, String input, InputFormat inputFormat, boolean validate) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, (ExecutionContextCustomizer)null);
    }

    public <T> T walk(ExecutionContext executionContext, String input, InputFormat inputFormat, OutputFormat<T> outputFormat, boolean validate) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, (ExecutionContextCustomizer)null);
    }

    public Result walk(ExecutionContext executionContext, String input, InputFormat inputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, executionCustomizer);
    }

    public <T> T walk(ExecutionContext executionContext, String input, InputFormat inputFormat, OutputFormat<T> outputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, executionCustomizer);
    }

    public Result walk(JsonNode node, boolean validate) {
        return this.walk(this.createExecutionContext(), node, validate);
    }

    public Result walk(JsonNode node, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walk(this.createExecutionContext(), node, validate, executionCustomizer);
    }

    public Result walk(JsonNode node, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walk(this.createExecutionContext(), node, validate, executionCustomizer);
    }

    public <T> T walk(JsonNode node, OutputFormat<T> outputFormat, boolean validate) {
        return this.walk(this.createExecutionContext(), node, outputFormat, validate, (ExecutionContextCustomizer)null);
    }

    public Result walk(String input, InputFormat inputFormat, boolean validate) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate);
    }

    public Result walk(String input, InputFormat inputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate, executionCustomizer);
    }

    public Result walk(String input, InputFormat inputFormat, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate, executionCustomizer);
    }

    public Result walk(AbsoluteIri input, InputFormat inputFormat, boolean validate) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate);
    }

    public Result walk(AbsoluteIri input, InputFormat inputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate, executionCustomizer);
    }

    public Result walk(AbsoluteIri input, InputFormat inputFormat, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate, executionCustomizer);
    }

    public Result walkAtNode(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, rootNode, instanceLocation, validate, OutputFormat.RESULT, (ExecutionContextCustomizer)null);
    }

    private <T> T walkAtNodeInternal(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean validate, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, rootNode, instanceLocation, validate, format, (ExecutionContext executeContext, SchemaContext schemaContext) -> executionCustomizer.accept(executeContext));
    }

    private <T> T walkAtNodeInternal(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean validate, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        if (executionCustomizer != null) {
            executionCustomizer.customize(executionContext, this.schemaContext);
        }
        executionContext.evaluationPath = this.atRoot();
        this.walk(executionContext, node, rootNode, instanceLocation, validate);
        return format.format(this, executionContext, this.schemaContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        List<KeywordValidator> validators = this.getValidators();
        executionContext.evaluationSchema.addLast(this);
        boolean unevaluatedPropertiesPresent = executionContext.unevaluatedPropertiesPresent;
        boolean unevaluatedItemsPresent = executionContext.unevaluatedItemsPresent;
        if (this.unevaluatedPropertiesPresent) {
            executionContext.unevaluatedPropertiesPresent = this.unevaluatedPropertiesPresent;
        }
        if (this.unevaluatedItemsPresent) {
            executionContext.unevaluatedItemsPresent = this.unevaluatedItemsPresent;
        }
        try {
            int currentErrors = executionContext.getErrors().size();
            for (KeywordValidator validator : validators) {
                try {
                    if (!executionContext.getWalkConfig().getKeywordWalkHandler().preWalk(executionContext, validator.getKeyword(), node, rootNode, instanceLocation, this, validator)) continue;
                    executionContext.evaluationPathAddLast(validator.getKeyword());
                    executionContext.evaluationSchemaPath.addLast(validator.getKeyword());
                    try {
                        validator.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                    }
                    finally {
                        executionContext.evaluationPathRemoveLast();
                        executionContext.evaluationSchemaPath.removeLast();
                    }
                }
                finally {
                    executionContext.getWalkConfig().getKeywordWalkHandler().postWalk(executionContext, validator.getKeyword(), node, rootNode, instanceLocation, this, validator, executionContext.getErrors().subList(currentErrors, executionContext.getErrors().size()));
                }
            }
        }
        finally {
            executionContext.evaluationSchema.removeLast();
            executionContext.unevaluatedPropertiesPresent = unevaluatedPropertiesPresent;
            executionContext.unevaluatedItemsPresent = unevaluatedItemsPresent;
        }
    }

    public String toString() {
        return this.getSchemaNode().toString();
    }

    public List<KeywordValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableList(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            this.validatorsLoaded = true;
            try {
                for (KeywordValidator validator : this.getValidators()) {
                    validator.preloadSchema();
                }
            }
            catch (RuntimeException e) {
                this.validatorsLoaded = false;
                throw e;
            }
        }
    }

    public boolean isRecursiveAnchor() {
        return this.recursiveAnchor;
    }

    public ExecutionContext createExecutionContext() {
        SchemaRegistryConfig config = this.schemaContext.getSchemaRegistryConfig();
        ExecutionConfig executionConfig = ((ExecutionConfig.Builder)((ExecutionConfig.Builder)((ExecutionConfig.Builder)ExecutionConfig.builder().locale(config.getLocale())).formatAssertionsEnabled(config.getFormatAssertionsEnabled())).failFast(config.isFailFast())).build();
        ExecutionContext executionContext = new ExecutionContext(executionConfig);
        if (config.getExecutionContextCustomizer() != null) {
            config.getExecutionContextCustomizer().customize(executionContext, this.schemaContext);
        }
        return executionContext;
    }

    public static class JsonNodePathJsonPointer {
        private static final NodePath INSTANCE = new NodePath(PathType.JSON_POINTER);

        public static NodePath getInstance() {
            return INSTANCE;
        }
    }

    public static class JsonNodePathLegacy {
        private static final NodePath INSTANCE = new NodePath(PathType.LEGACY);

        public static NodePath getInstance() {
            return INSTANCE;
        }
    }

    public static class JsonNodePathJsonPath {
        private static final NodePath INSTANCE = new NodePath(PathType.JSON_PATH);

        public static NodePath getInstance() {
            return INSTANCE;
        }
    }
}

